/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import javax.persistence.PersistenceContextType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.PropertyMetaDataParser;
import org.jboss.metadata.parser.ee.ResourceInjectionMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class PersistenceContextReferenceMetaDataParser
extends MetaDataElementParser {
    public static PersistenceContextReferenceMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        PersistenceContextReferenceMetaData pcReference = new PersistenceContextReferenceMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    pcReference.setId(value);
                    continue block9;
                }
                default: {
                    throw PersistenceContextReferenceMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions)) {
                if (pcReference.getDescriptions() != null) continue;
                pcReference.setDescriptions(descriptions);
                continue;
            }
            if (ResourceInjectionMetaDataParser.parse(reader, pcReference)) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENCE_CONTEXT_REF_NAME: {
                    pcReference.setPersistenceContextRefName(PersistenceContextReferenceMetaDataParser.getElementText(reader));
                    continue block10;
                }
                case PERSISTENCE_CONTEXT_TYPE: {
                    pcReference.setPersistenceContextType(PersistenceContextType.valueOf((String)PersistenceContextReferenceMetaDataParser.getElementText(reader).toUpperCase()));
                    continue block10;
                }
                case PERSISTENCE_UNIT_NAME: {
                    pcReference.setPersistenceUnitName(PersistenceContextReferenceMetaDataParser.getElementText(reader));
                    continue block10;
                }
                case PERSISTENCE_PROPERTY: {
                    PropertiesMetaData properties = pcReference.getProperties();
                    if (properties == null) {
                        properties = new PropertiesMetaData();
                        pcReference.setProperties(properties);
                    }
                    properties.add(PropertyMetaDataParser.parse(reader));
                    continue block10;
                }
            }
            throw PersistenceContextReferenceMetaDataParser.unexpectedElement(reader);
        }
        return pcReference;
    }
}

