/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import javax.ejb.EJB;
import org.jboss.metadata.annotation.creator.AbstractInjectionTargetProcessor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

public abstract class AbstractEJBProcessor<E extends AnnotatedElement>
extends AbstractInjectionTargetProcessor<E> {
    public AbstractEJBProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(AnnotatedEJBReferencesMetaData refs, E element) {
        EJB annotation = this.finder.getAnnotation(element, EJB.class);
        if (annotation == null) {
            return;
        }
        this.process(refs, element, annotation);
    }

    protected void process(AnnotatedEJBReferencesMetaData refs, E element, EJB annotation) {
        AnnotatedEJBReferenceMetaData ref = this.createEJB(annotation, element);
        this.addReference(refs, ref);
    }

    protected abstract String getName(E var1);

    protected abstract Class getType(E var1);

    protected AnnotatedEJBReferenceMetaData createEJB(EJB annotation, E element) {
        String name;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        AnnotatedEJBReferenceMetaData ref = new AnnotatedEJBReferenceMetaData();
        if (annotation.name().length() > 0) {
            ref.setEjbRefName(annotation.name());
        } else {
            ref.setEjbRefName(this.getName(element));
        }
        if (annotation.beanInterface() != Object.class) {
            ref.setBeanInterface(annotation.beanInterface());
        } else {
            ref.setBeanInterface(this.getType(element));
        }
        if (annotation.description().length() > 0) {
            DescriptionImpl description = new DescriptionImpl();
            description.setDescription(annotation.description());
            DescriptionsImpl descriptions = new DescriptionsImpl();
            descriptions.add(description);
            ref.setDescriptions(descriptions);
        }
        if (annotation.beanName().length() > 0) {
            ref.setLink(annotation.beanName());
        }
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        if (annotation.lookup() != null && !annotation.lookup().trim().isEmpty()) {
            ref.setLookupName(annotation.lookup());
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(name = ProcessorUtils.getName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(EJB.class);
    }
}

