/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.DescriptionImpl;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorUtils {
    public static <E extends AnnotatedElement> Set<ResourceInjectionTargetMetaData> getInjectionTargets(String name, E element) {
        Set<ResourceInjectionTargetMetaData> injectionTargets = null;
        if (!(element instanceof Class)) {
            ResourceInjectionTargetMetaData target = new ResourceInjectionTargetMetaData();
            target.setInjectionTargetClass(ProcessorUtils.getDeclaringClass(element));
            target.setInjectionTargetName(name);
            injectionTargets = Collections.singleton(target);
        }
        return injectionTargets;
    }

    public static <E extends AnnotatedElement> String getName(E element) {
        String name = element.getClass().getSimpleName();
        if (element instanceof Class) {
            Class c = (Class)element;
            name = c.getSimpleName();
        } else if (element instanceof Field) {
            Field f = (Field)element;
            name = f.getName();
        } else if (element instanceof Method) {
            Method m = (Method)element;
            name = m.getName();
        }
        return name;
    }

    public static <E extends AnnotatedElement> String getDeclaringClass(E element) {
        String c = null;
        if (element instanceof Field) {
            Field f = (Field)element;
            c = f.getDeclaringClass().getName();
        } else if (element instanceof Method) {
            Method m = (Method)element;
            c = m.getDeclaringClass().getName();
        }
        return c;
    }

    public static Descriptions getDescription(String description) {
        DescriptionsImpl descriptions = null;
        if (description.length() > 0) {
            DescriptionImpl di = new DescriptionImpl();
            di.setDescription(description);
            descriptions = new DescriptionsImpl();
            descriptions.add(di);
        }
        return descriptions;
    }

    public static DescriptionGroupMetaData getDescriptionGroup(String description) {
        DescriptionGroupMetaData dg = null;
        if (description.length() > 0) {
            dg = new DescriptionGroupMetaData();
            Descriptions descriptions = ProcessorUtils.getDescription(description);
            dg.setDescriptions(descriptions);
        }
        return dg;
    }

    public static Collection<Class<? extends Annotation>> createAnnotationSet(Class<? extends Annotation> annotation) {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>(1);
        set.add(annotation);
        return set;
    }

    public static Collection<Class<? extends Annotation>> createAnnotationSet(Class<? extends Annotation> ... annotations) {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>();
        for (Class<? extends Annotation> annotation : annotations) {
            set.add(annotation);
        }
        return set;
    }
}

