/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.spec;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import org.jboss.metadata.javaee.spec.PortComponentRef;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlersMetaData;
import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="service-refType", propOrder={"descriptionGroup", "serviceRefName", "serviceInterface", "serviceRefType", "wsdlFile", "jaxrpcMappingFile", "serviceQname", "portComponentRef", "handlers", "handlerChains", "mappedName", "lookupName", "injectionTargets"})
public class ServiceReferenceMetaData
extends ResourceInjectionMetaDataWithDescriptionGroup
implements MergeableMappedMetaData<ServiceReferenceMetaData> {
    private static final long serialVersionUID = 5693673588576610322L;
    private String serviceInterface;
    private String serviceRefType;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private QName serviceQname;
    private List<PortComponentRef> portComponentRef;
    private ServiceReferenceHandlersMetaData handlers;
    private ServiceReferenceHandlerChainsMetaData handlerChains;
    private transient AnnotatedElement anElement;
    private transient boolean processed;
    private transient String handlerChain;
    private transient boolean addressingEnabled;
    private transient boolean addressingRequired;
    private transient String addressingResponses = "ALL";
    private transient boolean mtomEnabled;
    private transient int mtomThreshold;
    private transient boolean respectBindingEnabled;

    @Override
    public ServiceReferenceMetaData merge(ServiceReferenceMetaData original) {
        ServiceReferenceMetaData merged = new ServiceReferenceMetaData();
        merged.merge(this, original);
        return merged;
    }

    public void merge(ServiceReferenceMetaData override, ServiceReferenceMetaData original) {
        super.merge(override, original);
        if (override != null && override.getServiceRefName() != null) {
            this.setServiceRefName(override.getServiceRefName());
        } else if (original != null && original.getServiceRefName() != null) {
            this.setServiceRefName(original.getServiceRefName());
        }
        if (override != null && override.getServiceInterface() != null) {
            this.setServiceInterface(override.getServiceInterface());
        } else if (original != null && original.getServiceInterface() != null) {
            this.setServiceInterface(original.getServiceInterface());
        }
        if (override != null && override.getServiceRefType() != null) {
            this.setServiceRefType(override.getServiceRefType());
        } else if (original != null && original.getServiceRefType() != null) {
            this.setServiceRefType(original.getServiceRefType());
        }
        if (override != null && override.getWsdlFile() != null) {
            this.setWsdlFile(override.getWsdlFile());
        } else if (original != null && original.getWsdlFile() != null) {
            this.setWsdlFile(original.getWsdlFile());
        }
        if (override != null && override.getJaxrpcMappingFile() != null) {
            this.setJaxrpcMappingFile(override.getJaxrpcMappingFile());
        } else if (original != null && original.getJaxrpcMappingFile() != null) {
            this.setJaxrpcMappingFile(original.getJaxrpcMappingFile());
        }
        if (override != null && override.getServiceQname() != null) {
            this.setServiceQname(override.getServiceQname());
        } else if (original != null && original.getServiceQname() != null) {
            this.setServiceQname(original.getServiceQname());
        }
        if (override != null && override.getPortComponentRef() != null) {
            this.setPortComponentRef(override.getPortComponentRef());
        } else if (original != null && original.getPortComponentRef() != null) {
            this.setPortComponentRef(original.getPortComponentRef());
        }
        if (override != null && override.getHandlers() != null) {
            this.setHandlers(override.getHandlers());
        } else if (original != null && original.getHandlers() != null) {
            this.setHandlers(original.getHandlers());
        }
        if (override != null && override.getHandlerChains() != null) {
            this.setHandlerChains(override.getHandlerChains());
        } else if (original != null && original.getHandlerChains() != null) {
            this.setHandlerChains(original.getHandlerChains());
        }
        if (override != null && override.getAnnotatedElement() != null) {
            this.setAnnotatedElement(override.getAnnotatedElement());
        } else if (original != null && original.getAnnotatedElement() != null) {
            this.setAnnotatedElement(original.getAnnotatedElement());
        }
        if (override != null && override.getHandlerChain() != null) {
            this.setHandlerChain(override.getHandlerChain());
        } else if (original != null && original.getHandlerChain() != null) {
            this.setHandlerChain(original.getHandlerChain());
        }
        if (override != null && override.isAddressingEnabled()) {
            this.setAddressingEnabled(override.isAddressingEnabled());
        } else if (original != null && original.isAddressingEnabled()) {
            this.setAddressingEnabled(original.isAddressingEnabled());
        }
        if (override != null && override.isAddressingRequired()) {
            this.setAddressingRequired(override.isAddressingRequired());
        } else if (original != null && original.isAddressingRequired()) {
            this.setAddressingRequired(original.isAddressingRequired());
        }
        if (override != null && !"ALL".equals(override.getAddressingResponses())) {
            this.setAddressingResponses(override.getAddressingResponses());
        } else if (original != null && !"ALL".equals(original.isAddressingRequired())) {
            this.setAddressingResponses(original.getAddressingResponses());
        }
        if (override != null && override.isMtomEnabled()) {
            this.setMtomEnabled(override.isMtomEnabled());
        } else if (original != null && original.isMtomEnabled()) {
            this.setMtomEnabled(original.isMtomEnabled());
        }
        if (override != null && override.getMtomThreshold() > 0) {
            this.setMtomThreshold(override.getMtomThreshold());
        } else if (original != null && original.getMtomThreshold() > 0) {
            this.setMtomThreshold(original.getMtomThreshold());
        }
        if (override != null && override.isRespectBindingEnabled()) {
            this.setRespectBindingEnabled(override.isRespectBindingEnabled());
        } else if (original != null && original.isRespectBindingEnabled()) {
            this.setRespectBindingEnabled(original.isRespectBindingEnabled());
        }
    }

    public String getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(String handlerChain) {
        this.handlerChain = handlerChain;
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        if (!("ANONYMOUS".equals(responsesTypes) || "NON_ANONYMOUS".equals(responsesTypes) || "ALL".equals(responsesTypes))) {
            throw new IllegalArgumentException("Only ALL, ANONYMOUS or NON_ANONYMOUS strings are allowed");
        }
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public String getServiceRefName() {
        return this.getName();
    }

    public void setServiceRefName(String serviceRefName) {
        this.setName(serviceRefName);
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        if (jaxrpcMappingFile == null) {
            throw new IllegalArgumentException("Null jaxrpcMappingFile");
        }
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException("Null serviceInterface");
        }
        this.serviceInterface = serviceInterface;
    }

    public QName getServiceQname() {
        return this.serviceQname;
    }

    public void setServiceQname(QName serviceQname) {
        if (serviceQname == null) {
            throw new IllegalArgumentException("Null serviceQname");
        }
        this.serviceQname = serviceQname;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    @XmlElement(required=false)
    public void setServiceRefType(String serviceRefType) {
        if (serviceRefType == null) {
            throw new IllegalArgumentException("Null serviceRefType");
        }
        this.serviceRefType = serviceRefType;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        if (wsdlFile == null) {
            throw new IllegalArgumentException("Null wsdlFile");
        }
        this.wsdlFile = wsdlFile;
    }

    public List<? extends PortComponentRef> getPortComponentRef() {
        return this.portComponentRef;
    }

    @XmlElement(name="port-component-ref", type=PortComponentRef.class)
    public void setPortComponentRef(List<? extends PortComponentRef> portComponentRef) {
        this.portComponentRef = portComponentRef;
    }

    public ServiceReferenceHandlersMetaData getHandlers() {
        return this.handlers;
    }

    @XmlElement(name="handler")
    public void setHandlers(ServiceReferenceHandlersMetaData handlers) {
        if (handlers == null) {
            throw new IllegalArgumentException("Null handlers");
        }
        this.handlers = handlers;
    }

    public ServiceReferenceHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    @XmlElement(required=false)
    public void setHandlerChains(ServiceReferenceHandlerChainsMetaData handlerChains) {
        if (handlerChains == null) {
            throw new IllegalArgumentException("Null handlerChains");
        }
        this.handlerChains = handlerChains;
    }

    @XmlTransient
    public AnnotatedElement getAnnotatedElement() {
        return this.anElement;
    }

    public void setAnnotatedElement(AnnotatedElement anElement) {
        this.anElement = anElement;
        this.processAddressingAnnotation();
        this.processMTOMAnnotation();
        this.processRespectBindingAnnotation();
        this.processHandlerChainAnnotation();
        this.processServiceRefType();
    }

    @XmlTransient
    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("ServiceReferenceMetaData");
        sb.append("\n ").append("serviceInterface=").append(this.serviceInterface);
        sb.append("\n ").append("serviceRefType=").append(this.serviceRefType);
        sb.append("\n ").append("wsdlFile=").append(this.wsdlFile);
        sb.append("\n ").append("jaxrpcMappingFile=").append(this.jaxrpcMappingFile);
        sb.append("\n ").append("serviceQname=").append(this.serviceQname);
        sb.append("\n ").append("portComponentRefs=").append(this.portComponentRef);
        sb.append("\n ").append("handlers=").append(this.handlers);
        sb.append("\n ").append("addressingEnabled=" + this.addressingEnabled);
        sb.append("\n ").append("addressingRequired=" + this.addressingRequired);
        sb.append("\n ").append("addressingResponses=" + this.addressingResponses);
        sb.append("\n ").append("mtomEnabled=" + this.mtomEnabled);
        sb.append("\n ").append("mtomThreshold=" + this.mtomThreshold);
        sb.append("\n ").append("respectBindingEnabled=" + this.respectBindingEnabled);
        sb.append("\n ").append("handlerChain=" + this.handlerChain);
        return sb.toString();
    }

    private void processAddressingAnnotation() {
        Addressing addressingAnnotation = this.getAnnotation(Addressing.class);
        if (addressingAnnotation != null) {
            this.setAddressingEnabled(addressingAnnotation.enabled());
            this.setAddressingRequired(addressingAnnotation.required());
            this.setAddressingResponses(addressingAnnotation.responses().toString());
        }
    }

    private void processMTOMAnnotation() {
        MTOM mtomAnnotation = this.getAnnotation(MTOM.class);
        if (mtomAnnotation != null) {
            this.setMtomEnabled(mtomAnnotation.enabled());
            this.setMtomThreshold(mtomAnnotation.threshold());
        }
    }

    private void processRespectBindingAnnotation() {
        RespectBinding respectBindingAnnotation = this.getAnnotation(RespectBinding.class);
        if (respectBindingAnnotation != null) {
            this.setRespectBindingEnabled(respectBindingAnnotation.enabled());
        }
    }

    private void processServiceRefType() {
        if (this.anElement instanceof Field) {
            Class<?> targetClass = ((Field)this.anElement).getType();
            this.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                this.setServiceInterface(targetClass.getName());
            }
        } else if (this.anElement instanceof Method) {
            Class<?> targetClass = ((Method)this.anElement).getParameterTypes()[0];
            this.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                this.setServiceInterface(targetClass.getName());
            }
        } else {
            WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation();
            Class targetClass = null;
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
                this.setServiceRefType(targetClass.getName());
                if (Service.class.isAssignableFrom(targetClass)) {
                    this.setServiceInterface(targetClass.getName());
                }
            }
        }
    }

    private void processHandlerChainAnnotation() {
        HandlerChain handlerChainAnnotation = this.getAnnotation(HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = null;
            if (handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    Class<?> declaringClass = this.getDeclaringClass(this.anElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                this.setHandlerChain(handlerChain);
            }
        }
    }

    private Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.anElement != null ? (T)this.anElement.getAnnotation(annotationClass) : null;
    }

    private WebServiceRef getWebServiceRefAnnotation() {
        WebServiceRef webServiceRefAnnotation = this.getAnnotation(WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = this.getAnnotation(WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!this.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }

    private Class<?> getTargetClass() {
        Class targetClass = null;
        if (this.anElement instanceof Field) {
            targetClass = ((Field)this.anElement).getType();
        } else if (this.anElement instanceof Method) {
            targetClass = ((Method)this.anElement).getParameterTypes()[0];
        } else {
            WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation();
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
            }
        }
        return targetClass;
    }
}

