/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.serviceref;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualFileAdaptor
implements UnifiedVirtualFile {
    private static final long serialVersionUID = -4509594124653184347L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootUrl", URL.class), new ObjectStreamField("path", String.class)};
    private URL rootUrl;
    private String path;
    private transient VirtualFile file;

    public VirtualFileAdaptor(VirtualFile file) {
        this.file = file;
    }

    public VirtualFileAdaptor(URL rootUrl, String path) {
        if (rootUrl == null) {
            throw new IllegalArgumentException("Null root url");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.rootUrl = rootUrl;
        this.path = path;
    }

    protected VirtualFile getFile() throws IOException {
        if (this.file == null) {
            VirtualFile root;
            try {
                root = VFS.getChild((URL)this.rootUrl);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to get Virtualfile from URL: " + this.rootUrl, e);
            }
            this.file = root.getChild(this.path);
        }
        return this.file;
    }

    public UnifiedVirtualFile findChild(String child) throws IOException {
        VirtualFile vf = this.getFile().getChild(child);
        return new VirtualFileAdaptor(vf);
    }

    public URL toURL() {
        try {
            return this.getFile().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, URISyntaxException {
        String pathName;
        URL url = this.rootUrl;
        if (url == null) {
            VirtualFile parentFile = this.getFile().getParent();
            URL uRL = url = parentFile != null ? parentFile.toURL() : null;
        }
        if ((pathName = this.path) == null) {
            pathName = this.getFile().getName();
        }
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootUrl", url);
        fields.put("path", pathName);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.rootUrl = (URL)fields.get("rootUrl", null);
        this.path = (String)fields.get("path", null);
    }

    public List<UnifiedVirtualFile> getChildren() throws IOException {
        List vfList = this.getFile().getChildren();
        if (vfList == null) {
            return null;
        }
        LinkedList<UnifiedVirtualFile> uvfList = new LinkedList<UnifiedVirtualFile>();
        for (VirtualFile vf : vfList) {
            uvfList.add(new VirtualFileAdaptor(vf));
        }
        return uvfList;
    }

    public String getName() {
        try {
            return this.getFile().getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

