/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jboss.jdocbook.render.PublishingSource;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;

public class PackageMojo
extends AbstractDocBookMojo {
    protected void process() throws RenderingException, XSLTException {
        File projectArtifactFile = new File(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getFinalName() + ".war");
        JarArchiver archiver = new JarArchiver();
        archiver.setDestFile(projectArtifactFile);
        try {
            for (PublishingSource source : this.getPublishingSources(true)) {
                for (FormatPlan formatPlan : this.getFormatPlans()) {
                    archiver.addDirectory(new File(source.resolvePublishingDirectory(), formatPlan.getName()), formatPlan.getName() + "/");
                }
            }
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new RenderingException("Unable to create archive [" + projectArtifactFile.getAbsolutePath() + "]", e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Unable to populate archive [" + projectArtifactFile.getAbsolutePath() + "]", e);
        }
        this.project.getArtifact().setFile(projectArtifactFile);
    }
}

