/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XIncludeFallbackResolver
implements EntityResolver {
    private final EntityResolver mainResolver;
    private final String baseSourceDirectoryURI;
    private final String baseFallbackURLPath;
    private final int baseSourceDirectoryURILength;

    public XIncludeFallbackResolver(EntityResolver mainResolver, String baseSourceDirectoryPath, String baseFallbackURLPath) {
        this.mainResolver = mainResolver;
        this.baseSourceDirectoryURI = "file:" + this.cleanupBaseSourceDirectoryPath(baseSourceDirectoryPath);
        this.baseSourceDirectoryURILength = this.baseSourceDirectoryURI.length();
        this.baseFallbackURLPath = baseFallbackURLPath.endsWith("/") ? baseFallbackURLPath : baseFallbackURLPath + "/";
    }

    private String cleanupBaseSourceDirectoryPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource resolvedSource = this.mainResolver.resolveEntity(publicId, systemId);
        if (resolvedSource == null) {
            resolvedSource = this.resolveFallback(publicId, systemId);
        }
        return resolvedSource;
    }

    protected InputSource resolveFallback(String publicId, String systemId) {
        if (publicId != null || systemId == null || !systemId.startsWith(this.baseSourceDirectoryURI)) {
            return null;
        }
        String ref = systemId.substring(this.baseSourceDirectoryURILength);
        String possibleFallback = this.baseFallbackURLPath + ref;
        try {
            URL url = new URL(possibleFallback);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            urlConnection.connect();
            return new InputSource(urlConnection.getInputStream());
        }
        catch (MalformedURLException ignore) {
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return null;
    }
}

