/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import com.icl.saxon.output.Emitter;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.xml.sax.Attributes;

public abstract class TransformerType {
    public static final TransformerType SAXON = new SaxonTransformerType();
    public static final TransformerType XALAN = new XalanTransformerType();
    private final String name;
    private SAXTransformerFactory factory;

    private TransformerType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SAXTransformerFactory getSAXTransformerFactory() {
        if (this.factory == null) {
            this.factory = this.buildSAXTransformerFactory();
        }
        return this.factory;
    }

    protected abstract SAXTransformerFactory buildSAXTransformerFactory();

    public static TransformerType parse(String name) {
        if (TransformerType.XALAN.name.equals(name)) {
            return XALAN;
        }
        return SAXON;
    }

    public static class XalanTransformerType
    extends TransformerType {
        public XalanTransformerType() {
            super("xalan");
        }

        public SAXTransformerFactory buildSAXTransformerFactory() {
            return new TransformerFactoryImpl();
        }
    }

    public static class SaxonXslMessageEmitter
    extends Emitter {
        private StringBuffer buffer;

        public void startDocument() throws TransformerException {
            if (this.buffer != null) {
                System.out.println("Unexpected call sequence on SaxonXslMessageEmitter; discarding [" + this.buffer.toString() + "]");
            }
            this.buffer = new StringBuffer();
        }

        public void endDocument() throws TransformerException {
            System.out.println("[STYLESHEET MESSAGE] " + this.buffer.toString());
            this.buffer.setLength(0);
            this.buffer = null;
        }

        public void startElement(int i, Attributes attributes, int[] ints, int i1) throws TransformerException {
        }

        public void endElement(int i) throws TransformerException {
        }

        public void characters(char[] chars, int start, int end) throws TransformerException {
            for (int i = start; i < end; ++i) {
                this.buffer.append(chars[i]);
            }
        }

        public void processingInstruction(String s, String s1) throws TransformerException {
        }

        public void comment(char[] chars, int i, int i1) throws TransformerException {
        }
    }

    public static class SaxonTransformerType
    extends TransformerType {
        public SaxonTransformerType() {
            super("saxon");
        }

        public SAXTransformerFactory buildSAXTransformerFactory() {
            com.icl.saxon.TransformerFactoryImpl factoryImpl = new com.icl.saxon.TransformerFactoryImpl();
            factoryImpl.setAttribute("http://icl.com/saxon/feature/messageEmitterClass", (Object)SaxonXslMessageEmitter.class.getName());
            return factoryImpl;
        }
    }
}

