/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookProcessException;

public class ResourceHelper {
    private final ClassLoader combinedClassLoader;

    public ResourceHelper(Environment environment) {
        this.combinedClassLoader = new URLClassLoader(this.extractClasspathUrls(environment), Thread.currentThread().getContextClassLoader());
    }

    private URL[] extractClasspathUrls(Environment environment) {
        URL[] combined;
        URL[] styleUrls = environment.getClasspathUriResolverBaseUrls();
        if (environment.getStagingDirectory() != null) {
            combined = new URL[styleUrls.length + 1];
            try {
                combined[0] = environment.getStagingDirectory().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("Unable to resolve staging dir to URL", e);
            }
            System.arraycopy(styleUrls, 0, combined, 1, styleUrls.length);
        } else {
            combined = styleUrls;
        }
        return combined;
    }

    public ClassLoader getCombinedClassLoader() {
        return this.combinedClassLoader;
    }

    public URL requireResource(String name) {
        URL resource = this.locateResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("could not locate resource [" + name + "]");
        }
        return resource;
    }

    public URL locateResource(String name) {
        if (name.startsWith("classpath:")) {
            return this.locateClassPathResource(name.substring(10));
        }
        if (name.startsWith("file:")) {
            try {
                return new URL(name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("malformed explicit file url [" + name + "]");
            }
        }
        return this.locateClassPathResource(name);
    }

    private URL locateClassPathResource(String name) {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        URL result = this.combinedClassLoader.getResource(name);
        if (result == null) {
            result = this.combinedClassLoader.getResource("/" + name);
        }
        return result;
    }
}

