/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.impl.fop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.render.PublishingSource;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptors;
import org.jboss.jdocbook.render.impl.XslFoGenerator;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.xslt.XSLTException;

public class XslFoGeneratorImpl
implements XslFoGenerator {
    private final RenderingEnvironment environment;
    private final FormatPlan formatPlan;

    public XslFoGeneratorImpl(RenderingEnvironment environment, FormatPlan formatPlan) {
        this.environment = environment;
        this.formatPlan = formatPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateXslFo() throws RenderingException, XSLTException {
        Transformer transformer = this.buildXslFoTransformer();
        for (PublishingSource source : this.environment.getPublishingSources(true)) {
            boolean createFile;
            boolean created;
            String sourceFileBasename = FileUtils.basename((String)source.resolveDocumentFile().getAbsolutePath());
            File fo = new File(source.resolveXslFoDirectory(), sourceFileBasename + ".fo");
            String lang = LocaleUtils.render(source.getLocale(), this.environment.getOptions().getLocaleSeparator());
            transformer.setParameter("l10n.gentext.language", lang);
            if (!fo.getParentFile().exists()) {
                created = fo.getParentFile().mkdirs();
                if (!created) {
                    throw new RenderingException("Unable to create FO file directory");
                }
                createFile = true;
            } else {
                boolean bl = createFile = !fo.exists();
            }
            if (createFile) {
                try {
                    created = fo.createNewFile();
                    if (!created) {
                        this.environment.log().info("Filesystem indicated problem creating FO file {}", fo);
                    }
                }
                catch (IOException e) {
                    throw new RenderingException("Unable to create FO file " + fo.toString());
                }
            }
            try {
                FileOutputStream out = new FileOutputStream(fo);
                try {
                    File sourceFile = source.resolveDocumentFile();
                    StreamSource sourceStream = new StreamSource(sourceFile);
                    StreamResult resultStream = new StreamResult(out);
                    try {
                        transformer.transform(sourceStream, resultStream);
                    }
                    catch (TransformerException e) {
                        throw new RenderingException("Unable to apply FO transformation", e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        this.environment.log().info("Unable to close output stream {}", fo);
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.environment.log().info("Unable to close output stream {}", fo);
                }
            }
            catch (FileNotFoundException e) {
                throw new RenderingException("Unable to open output stream to FO file", e);
            }
        }
    }

    private Transformer buildXslFoTransformer() {
        URL transformationStylesheet = this.formatPlan.getStylesheetResource() == null ? this.environment.getResourceHelper().requireResource(StandardDocBookFormatDescriptors.PDF.getStylesheetResource()) : this.environment.getResourceHelper().requireResource(this.formatPlan.getStylesheetResource());
        return this.environment.getTransformerBuilder().buildTransformer(this.formatPlan, transformationStylesheet);
    }
}

