/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.injection;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstantAttribute;
import javassist.bytecode.FieldInfo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.maven.plugins.injection.BytecodeInjection;
import org.jboss.maven.plugins.injection.Constant;
import org.jboss.maven.plugins.injection.MethodBodyReturn;
import org.jboss.maven.plugins.injection.TargetMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeInjectionMojo
extends AbstractMojo {
    protected MavenProject project;
    protected BytecodeInjection[] bytecodeInjections;
    private LoaderClassPath loaderClassPath;
    private ClassPool classPool;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader mavenProjectCompileClassPathClassLoader = this.buildProjectCompileClassLoader();
        this.loaderClassPath = new LoaderClassPath(mavenProjectCompileClassPathClassLoader);
        this.classPool = new ClassPool(true);
        this.classPool.appendClassPath((ClassPath)this.loaderClassPath);
        for (BytecodeInjection injection : this.bytecodeInjections) {
            for (TargetMember member : injection.getTargetMembers()) {
                BaseInjectionTarget injectionTarget;
                if (member instanceof Constant) {
                    injectionTarget = new ConstantInjectionTarget((Constant)member);
                } else if (member instanceof MethodBodyReturn) {
                    injectionTarget = new MethodBodyReturnReplacementTarget((MethodBodyReturn)member);
                } else {
                    throw new MojoExecutionException("Unexpected injection member type : " + member);
                }
                injectionTarget.inject(injection.getExpression());
            }
        }
        this.loaderClassPath.close();
    }

    private ClassLoader buildProjectCompileClassLoader() throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        for (String path : this.projectCompileClasspathElements()) {
            try {
                this.getLog().debug((CharSequence)("Adding project compile classpath element : " + path));
                classPathUrls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to build path URL [" + path + "]");
            }
        }
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<String> projectCompileClasspathElements() throws MojoExecutionException {
        try {
            return this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Call to MavenProject#getCompileClasspathElements required dependency resolution");
        }
    }

    private class MethodBodyReturnReplacementTarget
    extends BaseInjectionTarget {
        private final CtMethod ctMethod;

        private MethodBodyReturnReplacementTarget(MethodBodyReturn method) throws MojoExecutionException {
            super(method);
            try {
                for (CtMethod ctMethod : this.getCtClass().getMethods()) {
                    if (!method.getMethodName().equals(ctMethod.getName())) continue;
                    this.ctMethod = ctMethod;
                    return;
                }
                throw new MojoExecutionException("Could not locate method [" + method.getQualifiedName() + "]");
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Unable to resolve method [" + method.getQualifiedName() + "]", e);
            }
        }

        public void inject(String value) throws MojoExecutionException {
            try {
                this.ctMethod.setBody("{return \"" + value + "\";}");
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Unable to replace method body", t);
            }
            this.writeOutChanges();
        }
    }

    private class ConstantInjectionTarget
    extends BaseInjectionTarget {
        private final FieldInfo ctFieldInfo;

        private ConstantInjectionTarget(Constant constant) throws MojoExecutionException {
            super(constant);
            try {
                this.ctFieldInfo = this.getCtClass().getField(constant.getFieldName()).getFieldInfo();
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Unable to resolve class field [" + constant.getQualifiedName() + "]", e);
            }
        }

        public void inject(String value) throws MojoExecutionException {
            this.ctFieldInfo.addAttribute((AttributeInfo)new ConstantAttribute(this.ctFieldInfo.getConstPool(), this.ctFieldInfo.getConstPool().addStringInfo(value)));
            this.writeOutChanges();
        }
    }

    private abstract class BaseInjectionTarget
    implements InjectionTarget {
        private final TargetMember targetMember;
        private final File classFileLocation;
        private final CtClass ctClass;

        public TargetMember getTargetMember() {
            return this.targetMember;
        }

        public File getClassFileLocation() {
            return this.classFileLocation;
        }

        public CtClass getCtClass() {
            return this.ctClass;
        }

        protected BaseInjectionTarget(TargetMember targetMember) throws MojoExecutionException {
            this.targetMember = targetMember;
            try {
                this.classFileLocation = new File(BytecodeInjectionMojo.this.loaderClassPath.find(targetMember.getClassName()).toURI());
                this.ctClass = BytecodeInjectionMojo.this.classPool.get(targetMember.getClassName());
            }
            catch (Throwable e) {
                throw new MojoExecutionException("Unable to resolve class file path", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeOutChanges() throws MojoExecutionException {
            BytecodeInjectionMojo.this.getLog().info((CharSequence)("writing injection changes back [" + this.classFileLocation.getAbsolutePath() + "]"));
            ClassFile classFile = this.ctClass.getClassFile();
            classFile.compact();
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.classFileLocation)));
                try {
                    classFile.write(out);
                    out.flush();
                    if (!this.classFileLocation.setLastModified(System.currentTimeMillis())) {
                        BytecodeInjectionMojo.this.getLog().info((CharSequence)"Unable to manually update class file timestamp");
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write out modified class file", (Exception)e);
            }
        }
    }

    public static interface InjectionTarget {
        public void inject(String var1) throws MojoExecutionException;
    }
}

