/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jboss.marshalling.UnmarshallingFilter;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    private static final Logger LOG = Logger.getLogger(JDKSpecific.class.getName());
    private static final ReflectionFactory reflectionFactory = System.getSecurityManager() == null ? ReflectionFactory.getReflectionFactory() : AccessController.doPrivileged(new PrivilegedAction<ReflectionFactory>(){

        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    });
    private static final StackWalker stackWalker = System.getSecurityManager() == null ? StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE) : AccessController.doPrivileged(new PrivilegedAction<StackWalker>(){

        @Override
        public StackWalker run() {
            return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        }
    });
    private static final Function<Stream<StackWalker.StackFrame>, Class<?>> callerFinder = new Function<Stream<StackWalker.StackFrame>, Class<?>>(){

        @Override
        public Class<?> apply(Stream<StackWalker.StackFrame> stream) {
            StackWalker.StackFrame frame;
            Iterator iterator = stream.iterator();
            do {
                if (iterator.hasNext()) continue;
                throw new IllegalStateException();
            } while ((frame = (StackWalker.StackFrame)iterator.next()).getDeclaringClass() != JDKSpecific.class);
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            return ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
        }
    };

    private JDKSpecific() {
    }

    static OptionalDataException createOptionalDataException(int length) {
        OptionalDataException optionalDataException = JDKSpecific.createOptionalDataException(false);
        optionalDataException.length = length;
        return optionalDataException;
    }

    static OptionalDataException createOptionalDataException(boolean eof) {
        return reflectionFactory.newOptionalDataExceptionForSerialization(eof);
    }

    static Class<?> getMyCaller() {
        return stackWalker.walk(callerFinder);
    }

    static void setObjectInputStreamFilter(ObjectInputStream ois, UnmarshallingFilter filter) {
        LOG.finer(String.format("Setting UnmarshallingFilter %s to ObjectInputStream %s", filter, ois));
        ois.setObjectInputFilter(new ObjectInputFilterAdapter(filter));
    }

    static UnmarshallingFilter getJEPS290ProcessWideFilter() {
        ObjectInputFilter serialFilter = ObjectInputFilter.Config.getSerialFilter();
        if (serialFilter != null) {
            return new UnmarshallingFilterAdapter(serialFilter);
        }
        return null;
    }

    private static class ObjectInputFilterAdapter
    implements ObjectInputFilter {
        private final UnmarshallingFilter unmarshallingFilter;

        public ObjectInputFilterAdapter(UnmarshallingFilter unmarshallingFilter) {
            this.unmarshallingFilter = unmarshallingFilter;
        }

        @Override
        public ObjectInputFilter.Status checkInput(final ObjectInputFilter.FilterInfo filterInfo) {
            UnmarshallingFilter.FilterResponse response = this.unmarshallingFilter.checkInput(new FilterInput(){

                @Override
                public Class<?> getUnmarshalledClass() {
                    return filterInfo.serialClass();
                }

                @Override
                public long getArrayLength() {
                    return filterInfo.arrayLength();
                }

                @Override
                public long getDepth() {
                    return filterInfo.depth();
                }

                @Override
                public long getReferences() {
                    return filterInfo.references();
                }

                @Override
                public long getStreamBytes() {
                    return filterInfo.streamBytes();
                }

                @Override
                public Class<?> serialClass() {
                    return filterInfo.serialClass();
                }

                @Override
                public long arrayLength() {
                    return filterInfo.arrayLength();
                }

                @Override
                public long depth() {
                    return filterInfo.depth();
                }

                @Override
                public long references() {
                    return filterInfo.references();
                }

                @Override
                public long streamBytes() {
                    return filterInfo.streamBytes();
                }
            });
            switch (response) {
                case ACCEPT: {
                    return ObjectInputFilter.Status.ALLOWED;
                }
                case REJECT: {
                    return ObjectInputFilter.Status.REJECTED;
                }
                case UNDECIDED: {
                    return ObjectInputFilter.Status.UNDECIDED;
                }
            }
            throw new IllegalStateException("Unexpected filtering decision: " + response);
        }
    }

    private static class UnmarshallingFilterAdapter
    implements UnmarshallingFilter {
        private final ObjectInputFilter delegate;

        public UnmarshallingFilterAdapter(ObjectInputFilter delegate) {
            this.delegate = delegate;
        }

        @Override
        public UnmarshallingFilter.FilterResponse checkInput(FilterInput input) {
            ObjectInputFilter.Status status = this.delegate.checkInput(input);
            switch (status) {
                case ALLOWED: {
                    return UnmarshallingFilter.FilterResponse.ACCEPT;
                }
                case REJECTED: {
                    return UnmarshallingFilter.FilterResponse.REJECT;
                }
                case UNDECIDED: {
                    return UnmarshallingFilter.FilterResponse.UNDECIDED;
                }
            }
            throw new IllegalStateException("Unexpected filtering decision: " + status);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface FilterInput
    extends ObjectInputFilter.FilterInfo {
        public Class<?> getUnmarshalledClass();

        public long getArrayLength();

        public long getDepth();

        public long getReferences();

        public long getStreamBytes();

        @Override
        default public Class<?> serialClass() {
            return this.getUnmarshalledClass();
        }

        @Override
        default public long arrayLength() {
            return this.getArrayLength();
        }

        @Override
        default public long depth() {
            return this.getDepth();
        }

        @Override
        default public long references() {
            return this.getReferences();
        }

        @Override
        default public long streamBytes() {
            return this.getStreamBytes();
        }
    }
}

