/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.AbstractObjectInput;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.JDKSpecific;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.UnmarshallingFilter;

public abstract class AbstractUnmarshaller
extends AbstractObjectInput
implements Unmarshaller {
    protected final ClassExternalizerFactory classExternalizerFactory;
    protected final StreamHeader streamHeader;
    protected final ClassResolver classResolver;
    protected final ObjectResolver objectResolver;
    protected final ObjectResolver objectPreResolver;
    protected final ClassTable classTable;
    protected final ObjectTable objectTable;
    protected final ExceptionListener exceptionListener;
    protected final SerializabilityChecker serializabilityChecker;
    protected final UnmarshallingFilter unmarshallingFilter;
    protected final int configuredVersion;

    protected AbstractUnmarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        super(configuration.getBufferSize());
        ClassExternalizerFactory classExternalizerFactory = configuration.getClassExternalizerFactory();
        this.classExternalizerFactory = classExternalizerFactory == null ? marshallerFactory.getDefaultClassExternalizerFactory() : classExternalizerFactory;
        StreamHeader streamHeader = configuration.getStreamHeader();
        this.streamHeader = streamHeader == null ? marshallerFactory.getDefaultStreamHeader() : streamHeader;
        ClassResolver classResolver = configuration.getClassResolver();
        this.classResolver = classResolver == null ? marshallerFactory.getDefaultClassResolver() : classResolver;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectResolver;
        ObjectResolver objectPreResolver = configuration.getObjectPreResolver();
        this.objectPreResolver = objectPreResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectPreResolver;
        ClassTable classTable = configuration.getClassTable();
        this.classTable = classTable == null ? marshallerFactory.getDefaultClassTable() : classTable;
        ObjectTable objectTable = configuration.getObjectTable();
        this.objectTable = objectTable == null ? marshallerFactory.getDefaultObjectTable() : objectTable;
        ExceptionListener exceptionListener = configuration.getExceptionListener();
        this.exceptionListener = exceptionListener == null ? ExceptionListener.NO_OP : exceptionListener;
        SerializabilityChecker serializabilityChecker = configuration.getSerializabilityChecker();
        this.serializabilityChecker = serializabilityChecker == null ? SerializabilityChecker.DEFAULT : serializabilityChecker;
        UnmarshallingFilter unmarshallingFilter = configuration.getUnmarshallingFilter();
        this.unmarshallingFilter = unmarshallingFilter == null ? UnmarshallingFilter.ACCEPTING : unmarshallingFilter;
        int configuredVersion = configuration.getVersion();
        this.configuredVersion = configuredVersion == -1 ? marshallerFactory.getDefaultVersion() : configuredVersion;
    }

    @Override
    public void start(ByteInput byteInput) throws IOException {
        this.byteInput = byteInput;
        this.limit = 0;
        this.position = 0;
        this.streamHeader.readHeader(this);
    }

    @Override
    public void finish() throws IOException {
        this.limit = -1;
        this.position = 0;
        this.byteInput = null;
        this.clearClassCache();
    }

    protected final void filterCheck(Class<?> unmarshallClass, long arrayLength, long depth, long references, long streamBytes) throws InvalidClassException {
        if (this.unmarshallingFilter != UnmarshallingFilter.ACCEPTING) {
            FilterInputImpl input = new FilterInputImpl(unmarshallClass, arrayLength, depth, references, streamBytes);
            UnmarshallingFilter.FilterResponse response = null;
            RuntimeException ex = null;
            try {
                response = this.unmarshallingFilter.checkInput(input);
            }
            catch (RuntimeException re) {
                ex = re;
                InvalidClassException ice = new InvalidClassException(String.format("Filtering failed for %s", input));
                ice.initCause(re);
                throw ice;
            }
            finally {
                Logging.logFilterResponse(input, response, ex);
            }
            if (response == UnmarshallingFilter.FilterResponse.REJECT) {
                throw new InvalidClassException(String.format("Filtering rejected %s", input));
            }
        }
    }

    protected static void setObjectInputStreamFilter(ObjectInputStream ois, UnmarshallingFilter filter) {
        JDKSpecific.setObjectInputStreamFilter(ois, filter);
    }

    private static class FilterInputImpl
    implements JDKSpecific.FilterInput {
        private final Class<?> unmarshallClass;
        private final long arrayLength;
        private final long depth;
        private final long references;
        private final long streamBytes;

        private FilterInputImpl(Class<?> unmarshallClass, long arrayLength, long depth, long references, long streamBytes) {
            this.unmarshallClass = unmarshallClass;
            this.arrayLength = arrayLength;
            this.depth = depth;
            this.references = references;
            this.streamBytes = streamBytes;
        }

        @Override
        public Class<?> getUnmarshalledClass() {
            return this.unmarshallClass;
        }

        @Override
        public long getArrayLength() {
            return this.arrayLength;
        }

        @Override
        public long getDepth() {
            return this.depth;
        }

        @Override
        public long getReferences() {
            return this.references;
        }

        @Override
        public long getStreamBytes() {
            return this.streamBytes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString()).append(": ");
            if (this.unmarshallClass != null) {
                builder.append("unmarshallClass=<").append(this.unmarshallClass.toString()).append("> ");
            }
            builder.append("arrayLength=<").append(this.arrayLength).append("> ");
            builder.append("depth=<").append(this.depth).append("> ");
            builder.append("references=<").append(this.references).append("> ");
            builder.append("streamBytes=<").append(this.streamBytes).append("> ");
            return builder.toString();
        }
    }

    private static class Logging {
        static final Logger marshallingLogger = Logger.getLogger("org.jboss.marshalling");

        private Logging() {
        }

        private static void logFilterResponse(JDKSpecific.FilterInput input, UnmarshallingFilter.FilterResponse response, RuntimeException ex) {
            if (response == null || response == UnmarshallingFilter.FilterResponse.REJECT) {
                Logging.logFilterResponse(input, response, ex, Level.FINER);
            } else {
                Logging.logFilterResponse(input, response, ex, Level.FINEST);
            }
        }

        private static void logFilterResponse(JDKSpecific.FilterInput input, UnmarshallingFilter.FilterResponse response, RuntimeException ex, Level level) {
            if (marshallingLogger.isLoggable(level)) {
                String message = String.format("UnmarshallingFilter %s: %s, array length: %d, nRefs: %d, depth: %d, bytes: %d, ex: %s", new Object[]{response, input.getUnmarshalledClass(), input.getArrayLength(), input.getReferences(), input.getDepth(), input.getStreamBytes(), Objects.toString(ex, "n/a")});
                if (Level.FINEST.equals(level)) {
                    marshallingLogger.log(level, message, ex);
                } else {
                    marshallingLogger.log(level, message);
                }
            }
        }
    }
}

