/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.UnlockedHashMap;

public final class SerializableClassRegistry {
    private static final SerializableClassRegistry INSTANCE = new SerializableClassRegistry();
    private static final SerializablePermission PERMISSION = new SerializablePermission("allowSerializationReflection");
    private final ConcurrentMap<ClassLoader, ConcurrentMap<Class<?>, SerializableClass>> registry = new UnlockedHashMap();

    private SerializableClassRegistry() {
    }

    public static SerializableClassRegistry getInstance() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(PERMISSION);
        }
        return INSTANCE;
    }

    static SerializableClassRegistry getInstanceUnchecked() {
        return INSTANCE;
    }

    public SerializableClass lookup(final Class<?> subject) {
        SerializableClass info;
        ConcurrentMap existing;
        if (subject == null) {
            return null;
        }
        ClassLoader classLoader = subject.getClassLoader();
        ConcurrentMap<Class<?>, SerializableClass> loaderMap = (UnlockedHashMap)this.registry.get(classLoader);
        if (loaderMap == null && (existing = (ConcurrentMap)this.registry.putIfAbsent(classLoader, loaderMap = new UnlockedHashMap())) != null) {
            loaderMap = existing;
        }
        if ((info = (SerializableClass)loaderMap.get(subject)) != null) {
            return info;
        }
        SecurityManager sm = System.getSecurityManager();
        info = sm != null ? AccessController.doPrivileged(new PrivilegedAction<SerializableClass>(){

            @Override
            public SerializableClass run() {
                return new SerializableClass(subject);
            }
        }) : new SerializableClass(subject);
        SerializableClass existing2 = loaderMap.putIfAbsent(subject, info);
        return existing2 != null ? existing2 : info;
    }

    public void release(ClassLoader classLoader) {
        this.registry.remove(classLoader);
    }

    static final class DuhMap<K, V>
    extends IdentityHashMap<K, V>
    implements ConcurrentMap<K, V> {
        DuhMap() {
        }

        @Override
        public V putIfAbsent(K key, V value) {
            return this.containsKey(key) ? this.get(key) : this.put(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.get(key) == value ? this.remove(key) != this : false;
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            return this.get(key) == oldValue ? this.put(key, newValue) != this : false;
        }

        @Override
        public V replace(K key, V value) {
            return this.containsKey(key) ? (V)this.put(key, value) : null;
        }
    }
}

