/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.lang.reflect.Field;
import org.jboss.marshalling.util.Kind;

public final class SerializableField {
    private final Class<?> type;
    private final Field field;
    private final String name;
    private final boolean unshared;
    private final Kind kind;

    public SerializableField(Class<?> type, String name, boolean unshared) {
        this(type, name, unshared, null);
    }

    SerializableField(Class<?> type, String name, boolean unshared, Field field) {
        this.type = type;
        this.name = name;
        this.unshared = unshared;
        this.field = field;
        if (field != null) {
            if (field.getType() != type) {
                throw new IllegalStateException("Constructed a serializable field with the wrong type (field type is " + field.getType() + ", our type is " + type + ")");
            }
            if (!field.getName().equals(name)) {
                throw new IllegalStateException("Constructed a serializable field with the wrong name (field name is " + field.getName() + ", our type is " + name + ")");
            }
        }
        this.kind = type == Boolean.TYPE ? Kind.BOOLEAN : (type == Byte.TYPE ? Kind.BYTE : (type == Short.TYPE ? Kind.SHORT : (type == Integer.TYPE ? Kind.INT : (type == Long.TYPE ? Kind.LONG : (type == Character.TYPE ? Kind.CHAR : (type == Float.TYPE ? Kind.FLOAT : (type == Double.TYPE ? Kind.DOUBLE : Kind.OBJECT)))))));
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<?> getType() throws ClassNotFoundException {
        return this.type;
    }
}

