/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.marshalling.reflect.SerializableClass;

public final class SerializableClassRegistry {
    private static final SerializableClassRegistry INSTANCE = new SerializableClassRegistry();
    private static final SerializablePermission PERMISSION = new SerializablePermission("allowSerializationReflection");
    private static final Object NULL_KEY = new Object();
    private final ConcurrentMap<Object, ConcurrentMap<Class<?>, SerializableClass>> registry = new ConcurrentHashMap();

    private SerializableClassRegistry() {
    }

    public static SerializableClassRegistry getInstance() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(PERMISSION);
        }
        return INSTANCE;
    }

    private static Object denull(ClassLoader classLoader) {
        return null != classLoader ? classLoader : NULL_KEY;
    }

    static SerializableClassRegistry getInstanceUnchecked() {
        return INSTANCE;
    }

    public SerializableClass lookup(final Class<?> subject) {
        SerializableClass info;
        ConcurrentMap existing;
        if (subject == null) {
            return null;
        }
        ClassLoader classLoader = System.getSecurityManager() == null ? subject.getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return subject.getClassLoader();
            }
        });
        Object registryKey = SerializableClassRegistry.denull(classLoader);
        ConcurrentMap<Class<?>, SerializableClass> loaderMap = (ConcurrentHashMap)this.registry.get(registryKey);
        if (loaderMap == null && (existing = (ConcurrentMap)this.registry.putIfAbsent(registryKey, loaderMap = new ConcurrentHashMap())) != null) {
            loaderMap = existing;
        }
        if ((info = (SerializableClass)loaderMap.get(subject)) != null) {
            return info;
        }
        SecurityManager sm = System.getSecurityManager();
        info = sm != null ? AccessController.doPrivileged(new PrivilegedAction<SerializableClass>(){

            @Override
            public SerializableClass run() {
                return new SerializableClass(subject);
            }
        }) : new SerializableClass(subject);
        SerializableClass existing2 = loaderMap.putIfAbsent(subject, info);
        return existing2 != null ? existing2 : info;
    }

    public void release(ClassLoader classLoader) {
        this.registry.remove(SerializableClassRegistry.denull(classLoader));
    }
}

