/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.marshalling.reflect.SerializableField;
import sun.reflect.ReflectionFactory;

public final class SerializableClass {
    private static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private final WeakReference<Class<?>> subjectRef;
    private final LazyWeakMethodRef writeObject;
    private final LazyWeakMethodRef writeReplace;
    private final LazyWeakMethodRef readObject;
    private final LazyWeakMethodRef readObjectNoData;
    private final LazyWeakMethodRef readResolve;
    private final LazyWeakConstructorRef noArgConstructor;
    private final LazyWeakConstructorRef objectInputConstructor;
    private final LazyWeakConstructorRef nonInitConstructor;
    private final SerializableField[] fields;
    private final long effectiveSerialVersionUID;
    private static final Comparator<? super SerializableField> NAME_COMPARATOR = new Comparator<SerializableField>(){

        @Override
        public int compare(SerializableField o1, SerializableField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final SerializableField[] NOFIELDS = new SerializableField[0];
    private static final MethodFinder WRITE_OBJECT_FINDER = new PrivateMethodFinder("writeObject", new Class[]{ObjectOutputStream.class});
    private static final MethodFinder READ_OBJECT_FINDER = new PrivateMethodFinder("readObject", new Class[]{ObjectInputStream.class});
    private static final MethodFinder READ_OBJECT_NO_DATA_FINDER = new PrivateMethodFinder("readObjectNoData", new Class[0]);
    private static final MethodFinder WRITE_REPLACE_FINDER = new InheritableMethodFinder("writeReplace");
    private static final MethodFinder READ_RESOLVE_FINDER = new InheritableMethodFinder("readResolve");
    private static final ConstructorFinder SIMPLE_CONSTRUCTOR_FINDER = new PublicConstructorFinder(new Class[0]);
    private static final ConstructorFinder OBJECT_INPUT_CONSTRUCTOR_FINDER = new PublicConstructorFinder(new Class[]{ObjectInput.class});
    private static final ConstructorFinder NON_INIT_CONSTRUCTOR_FINDER = new NoInitConstructorFinder();

    SerializableClass(Class<?> subject) {
        WeakReference subjectRef = new WeakReference(subject);
        this.subjectRef = subjectRef;
        this.writeObject = LazyWeakMethodRef.getInstance(SerializableClass.WRITE_OBJECT_FINDER, subjectRef);
        this.readObject = LazyWeakMethodRef.getInstance(SerializableClass.READ_OBJECT_FINDER, subjectRef);
        this.readObjectNoData = LazyWeakMethodRef.getInstance(SerializableClass.READ_OBJECT_NO_DATA_FINDER, subjectRef);
        this.writeReplace = LazyWeakMethodRef.getInstance(SerializableClass.WRITE_REPLACE_FINDER, subjectRef);
        this.readResolve = LazyWeakMethodRef.getInstance(SerializableClass.READ_RESOLVE_FINDER, subjectRef);
        this.noArgConstructor = LazyWeakConstructorRef.getInstance(SerializableClass.SIMPLE_CONSTRUCTOR_FINDER, subjectRef);
        this.nonInitConstructor = LazyWeakConstructorRef.getInstance(SerializableClass.NON_INIT_CONSTRUCTOR_FINDER, subjectRef);
        this.objectInputConstructor = LazyWeakConstructorRef.getInstance(SerializableClass.OBJECT_INPUT_CONSTRUCTOR_FINDER, subjectRef);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(subject);
        this.effectiveSerialVersionUID = objectStreamClass == null ? 0L : objectStreamClass.getSerialVersionUID();
        this.fields = SerializableClass.getSerializableFields(subject);
    }

    private static SerializableField[] getSerializableFields(Class<?> clazz) {
        ObjectStreamField[] objectStreamFields = SerializableClass.getDeclaredSerialPersistentFields(clazz);
        if (objectStreamFields != null) {
            SerializableField[] fields = new SerializableField[objectStreamFields.length];
            for (int i = 0; i < objectStreamFields.length; ++i) {
                ObjectStreamField field = objectStreamFields[i];
                fields[i] = new SerializableField(clazz, field.getType(), field.getName(), field.isUnshared());
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<SerializableField> fields = new ArrayList<SerializableField>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            fields.add(new SerializableField(clazz, field.getType(), field.getName(), false));
        }
        Collections.sort(fields, NAME_COMPARATOR);
        return fields.toArray(new SerializableField[fields.size()]);
    }

    private static ObjectStreamField[] getDeclaredSerialPersistentFields(Class<?> clazz) {
        Field field;
        try {
            field = clazz.getDeclaredField("serialPersistentFields");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field == null) {
            return null;
        }
        int requiredModifiers = 26;
        if ((field.getModifiers() & 0x1A) != 26) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (ObjectStreamField[])field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public SerializableField[] getFields() {
        return this.fields;
    }

    public SerializableField getSerializableField(String name, Class<?> fieldType, boolean unshared) throws ClassNotFoundException {
        return new SerializableField(this.getSubjectClass(), fieldType, name, unshared);
    }

    public boolean hasWriteObject() {
        return this.writeObject != null;
    }

    public void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        try {
            this.writeObject.getMethod().invoke(object, outputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObject() {
        return this.readObject != null;
    }

    public void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        try {
            this.readObject.getMethod().invoke(object, inputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObjectNoData() {
        return this.readObjectNoData != null;
    }

    public void callReadObjectNoData(Object object) throws ObjectStreamException {
        try {
            this.readObjectNoData.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplace != null;
    }

    public Object callWriteReplace(Object object) throws ObjectStreamException {
        try {
            return this.writeReplace.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadResolve() {
        return this.readResolve != null;
    }

    public Object callReadResolve(Object object) throws ObjectStreamException {
        try {
            return this.readResolve.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasNoArgConstructor() {
        return this.noArgConstructor != null;
    }

    public Object callNoArgConstructor() throws IOException {
        return SerializableClass.invokeConstructor(this.noArgConstructor, new Object[0]);
    }

    public boolean hasObjectInputConstructor() {
        return this.objectInputConstructor != null;
    }

    public Object callObjectInputConstructor(ObjectInput objectInput) throws IOException {
        return SerializableClass.invokeConstructor(this.objectInputConstructor, objectInput);
    }

    public boolean hasNoInitConstructor() {
        return this.nonInitConstructor != null;
    }

    public Object callNonInitConstructor() {
        return SerializableClass.invokeConstructorNoException(this.nonInitConstructor, new Object[0]);
    }

    private static Object invokeConstructor(LazyWeakConstructorRef ref, Object ... args) throws IOException {
        try {
            return ref.getConstructor().newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    private static Object invokeConstructorNoException(LazyWeakConstructorRef ref, Object ... args) {
        try {
            return ref.getConstructor().newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    public long getEffectiveSerialVersionUID() {
        return this.effectiveSerialVersionUID;
    }

    public Class<?> getSubjectClass() throws ClassNotFoundException {
        return SerializableClass.dereference(this.subjectRef);
    }

    private static <T> Constructor<T> lookupPublicConstructor(Class<T> subject, Class<?> ... params) {
        try {
            Constructor<T> constructor = subject.getConstructor(params);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method lookupPrivateMethod(Class<?> subject, String name, Class<?> ... params) {
        try {
            Method method = subject.getDeclaredMethod(name, params);
            int modifiers = method.getModifiers();
            if ((modifiers & 2) == 0) {
                return null;
            }
            if ((modifiers & 8) != 0) {
                return null;
            }
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method lookupInheritableMethod(Class<?> subject, String name) {
        Class<?> foundClass = subject;
        Method method = null;
        while (method == null) {
            try {
                if (foundClass == null) {
                    return null;
                }
                method = foundClass.getDeclaredMethod(name, new Class[0]);
                if (method != null) continue;
                foundClass = foundClass.getSuperclass();
            }
            catch (NoSuchMethodException e) {
                foundClass = foundClass.getSuperclass();
            }
        }
        int modifiers = method.getModifiers();
        if ((modifiers & 8) != 0) {
            return null;
        }
        if ((modifiers & 0x400) != 0) {
            return null;
        }
        if ((modifiers & 2) != 0 && foundClass != subject) {
            return null;
        }
        if ((modifiers & 5) != 0 || SerializableClass.isSamePackage(foundClass, subject)) {
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private static boolean isSamePackage(Class<?> a, Class<?> b) {
        return a.getClassLoader() == b.getClassLoader() && SerializableClass.getPackageName(a).equals(SerializableClass.getPackageName(b));
    }

    private static String getPackageName(Class<?> c) {
        String name = c.getName();
        int idx = name.lastIndexOf(91);
        if (idx > -1) {
            name = name.substring(idx + 2);
        }
        if ((idx = name.lastIndexOf(46)) > -1) {
            name = name.substring(0, idx);
            return name;
        }
        return "";
    }

    <T> Constructor<T> getNoInitConstructor() {
        try {
            return this.nonInitConstructor.getConstructor();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static Class<?> dereference(WeakReference<Class<?>> classRef) throws ClassNotFoundException {
        Class clazz = (Class)classRef.get();
        if (clazz == null) {
            throw new ClassNotFoundException("Class was unloaded");
        }
        return clazz;
    }

    public String toString() {
        try {
            return String.format("Serializable %s", this.getSubjectClass());
        }
        catch (ClassNotFoundException e) {
            return "Unloaded serializable class";
        }
    }

    private static final class ConstructorFinderAction<T>
    implements PrivilegedAction<Constructor<T>> {
        private final ConstructorFinder finder;
        private final Class<T> clazz;

        private ConstructorFinderAction(ConstructorFinder finder, Class<T> clazz) {
            this.finder = finder;
            this.clazz = clazz;
        }

        @Override
        public Constructor<T> run() {
            return this.finder.get(this.clazz);
        }
    }

    private static final class NoInitConstructorFinder
    implements ConstructorFinder {
        private NoInitConstructorFinder() {
        }

        @Override
        public <T> Constructor<T> get(Class<T> clazz) {
            Constructor<T> topConstructor;
            Class<T> current = clazz;
            while (Serializable.class.isAssignableFrom(current)) {
                current = current.getSuperclass();
            }
            try {
                topConstructor = current.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            topConstructor.setAccessible(true);
            Constructor<?> generatedConstructor = reflectionFactory.newConstructorForSerialization(clazz, topConstructor);
            generatedConstructor.setAccessible(true);
            return generatedConstructor;
        }
    }

    private static final class PublicConstructorFinder
    implements ConstructorFinder {
        private final Class<?>[] params;

        private PublicConstructorFinder(Class<?> ... params) {
            this.params = params;
        }

        @Override
        public <T> Constructor<T> get(Class<T> clazz) {
            return SerializableClass.lookupPublicConstructor(clazz, this.params);
        }
    }

    private static final class MethodFinderAction
    implements PrivilegedAction<Method> {
        private final MethodFinder finder;
        private final Class<?> clazz;

        private MethodFinderAction(MethodFinder finder, Class<?> clazz) {
            this.finder = finder;
            this.clazz = clazz;
        }

        @Override
        public Method run() {
            return this.finder.get(this.clazz);
        }
    }

    private static final class InheritableMethodFinder
    implements MethodFinder {
        private final String name;

        private InheritableMethodFinder(String name) {
            this.name = name;
        }

        @Override
        public Method get(Class<?> clazz) {
            return SerializableClass.lookupInheritableMethod(clazz, this.name);
        }
    }

    private static final class PrivateMethodFinder
    implements MethodFinder {
        private final String name;
        private final Class<?>[] params;

        private PrivateMethodFinder(String name, Class<?> ... params) {
            this.name = name;
            this.params = params;
        }

        @Override
        public Method get(Class<?> clazz) {
            return SerializableClass.lookupPrivateMethod(clazz, this.name, this.params);
        }
    }

    private static class LazyWeakConstructorRef {
        private volatile WeakReference<Constructor<?>> ref;
        private final ConstructorFinder finder;
        private final WeakReference<Class<?>> classRef;
        private static final AtomicReferenceFieldUpdater<LazyWeakConstructorRef, WeakReference> refUpdater = AtomicReferenceFieldUpdater.newUpdater(LazyWeakConstructorRef.class, WeakReference.class, "ref");

        private LazyWeakConstructorRef(ConstructorFinder finder, Constructor<?> initial, WeakReference<Class<?>> classRef) {
            this.finder = finder;
            this.classRef = classRef;
            this.ref = new WeakReference(initial);
        }

        private static LazyWeakConstructorRef getInstance(ConstructorFinder finder, WeakReference<Class<?>> classRef) {
            Class clazz = (Class)classRef.get();
            if (clazz == null) {
                throw new NullPointerException("clazz is null (no strong reference held to class when serialization info was acquired");
            }
            Constructor constructor = finder.get(clazz);
            if (constructor == null) {
                return null;
            }
            return new LazyWeakConstructorRef(finder, constructor, classRef);
        }

        private Constructor<?> getConstructor() throws ClassNotFoundException {
            Constructor method;
            WeakReference<Constructor<?>> weakReference = this.ref;
            if (weakReference != null && (method = (Constructor)weakReference.get()) != null) {
                return method;
            }
            Class<?> clazz = SerializableClass.dereference(this.classRef);
            SecurityManager sm = System.getSecurityManager();
            Constructor<?> constructor = sm != null ? LazyWeakConstructorRef.doAction(this.finder, clazz) : this.finder.get(clazz);
            if (constructor == null) {
                throw new NullPointerException("constructor is null (was non-null on last check)");
            }
            WeakReference newVal = new WeakReference(constructor);
            refUpdater.compareAndSet(this, weakReference, newVal);
            return constructor;
        }

        private static <T> Constructor<T> doAction(ConstructorFinder finder, Class<T> clazz) {
            return (Constructor)AccessController.doPrivileged(new ConstructorFinderAction(finder, clazz));
        }
    }

    private static class LazyWeakMethodRef {
        private volatile WeakReference<Method> ref;
        private final MethodFinder finder;
        private final WeakReference<Class<?>> classRef;
        private static final AtomicReferenceFieldUpdater<LazyWeakMethodRef, WeakReference> refUpdater = AtomicReferenceFieldUpdater.newUpdater(LazyWeakMethodRef.class, WeakReference.class, "ref");

        private LazyWeakMethodRef(MethodFinder finder, Method initial, WeakReference<Class<?>> classRef) {
            this.finder = finder;
            this.classRef = classRef;
            this.ref = new WeakReference<Method>(initial);
        }

        private static LazyWeakMethodRef getInstance(MethodFinder finder, WeakReference<Class<?>> classRef) {
            Class clazz = (Class)classRef.get();
            if (clazz == null) {
                throw new NullPointerException("clazz is null (no strong reference held to class when serialization info was acquired");
            }
            Method method = finder.get(clazz);
            if (method == null) {
                return null;
            }
            return new LazyWeakMethodRef(finder, method, classRef);
        }

        private Method getMethod() throws ClassNotFoundException {
            Method method;
            WeakReference<Method> weakReference = this.ref;
            if (weakReference != null && (method = (Method)weakReference.get()) != null) {
                return method;
            }
            Class<?> clazz = SerializableClass.dereference(this.classRef);
            SecurityManager sm = System.getSecurityManager();
            Method method2 = sm != null ? AccessController.doPrivileged(new MethodFinderAction(this.finder, clazz)) : this.finder.get(clazz);
            if (method2 == null) {
                throw new NullPointerException("method is null (was non-null on last check)");
            }
            WeakReference<Method> newVal = new WeakReference<Method>(method2);
            refUpdater.compareAndSet(this, weakReference, newVal);
            return method2;
        }
    }

    private static interface ConstructorFinder {
        public <T> Constructor<T> get(Class<T> var1);
    }

    private static interface MethodFinder {
        public Method get(Class<?> var1);
    }
}

