/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.serial.BlockUnmarshaller;
import org.jboss.marshalling.serial.Descriptor;
import org.jboss.marshalling.serial.SerialObjectInputStream;
import org.jboss.marshalling.serial.SerialUnmarshaller;
import org.jboss.marshalling.util.BooleanReadField;
import org.jboss.marshalling.util.ByteReadField;
import org.jboss.marshalling.util.CharReadField;
import org.jboss.marshalling.util.DoubleReadField;
import org.jboss.marshalling.util.FloatReadField;
import org.jboss.marshalling.util.IntReadField;
import org.jboss.marshalling.util.Kind;
import org.jboss.marshalling.util.LongReadField;
import org.jboss.marshalling.util.ObjectReadField;
import org.jboss.marshalling.util.ReadField;
import org.jboss.marshalling.util.ShortReadField;

class PlainDescriptor
extends Descriptor
implements ObjectStreamConstants {
    private final SerializableField[] fields;
    private final int flags;

    protected PlainDescriptor(Class<?> type, Descriptor parent, SerializableField[] fields, int flags) {
        super(parent, type);
        this.fields = fields;
        this.flags = flags;
    }

    @Override
    public SerializableField[] getFields() {
        return this.fields;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    protected void readSerial(SerialUnmarshaller serialUnmarshaller, SerializableClass sc, Object subject) throws IOException, ClassNotFoundException {
        if ((this.flags & 1) != 0) {
            if (sc.hasReadObject()) {
                this.doReadObject(serialUnmarshaller, sc, subject);
            } else {
                this.defaultReadFields(serialUnmarshaller, subject);
            }
            BlockUnmarshaller blockUnmarshaller = serialUnmarshaller.getBlockUnmarshaller();
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
        } else if (sc.hasReadObject()) {
            BlockUnmarshaller blockUnmarshaller = serialUnmarshaller.getBlockUnmarshaller();
            blockUnmarshaller.endOfStream();
            this.doReadObject(serialUnmarshaller, sc, subject);
            blockUnmarshaller.unblock();
        } else {
            this.defaultReadFields(serialUnmarshaller, subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadObject(SerialUnmarshaller serialUnmarshaller, SerializableClass sc, Object subject) throws ClassNotFoundException, IOException {
        SerialObjectInputStream ois = serialUnmarshaller.getObjectInputStream();
        SerialObjectInputStream.State oldState = ois.saveState();
        PlainDescriptor oldDescriptor = ois.saveCurrentDescriptor(this);
        SerializableClass oldSerializableClass = ois.saveCurrentSerializableClass(sc);
        Object oldSubject = ois.saveCurrentSubject(subject);
        try {
            sc.callReadObject(subject, (ObjectInputStream)((Object)ois));
            if (sc.getFields().length > 0 && ois.restoreState(oldState) != SerialObjectInputStream.State.ON) {
                throw new StreamCorruptedException("readObject() did not read fields");
            }
        }
        finally {
            ois.restoreState(oldState);
            ois.setCurrentDescriptor(oldDescriptor);
            ois.setCurrentSerializableClass(oldSerializableClass);
            ois.setCurrentSubject(oldSubject);
        }
    }

    void defaultReadFields(SerialUnmarshaller serialUnmarshaller, Object subject) throws IOException, ClassNotFoundException {
        try {
            Field realField;
            block12: for (SerializableField serializableField : this.fields) {
                realField = serializableField.getField();
                if (realField == null) continue;
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        realField.setBoolean(subject, serialUnmarshaller.readBoolean());
                        continue block12;
                    }
                    case BYTE: {
                        realField.setByte(subject, serialUnmarshaller.readByte());
                        continue block12;
                    }
                    case CHAR: {
                        realField.setChar(subject, serialUnmarshaller.readChar());
                        continue block12;
                    }
                    case DOUBLE: {
                        realField.setDouble(subject, serialUnmarshaller.readDouble());
                        continue block12;
                    }
                    case FLOAT: {
                        realField.setFloat(subject, serialUnmarshaller.readFloat());
                        continue block12;
                    }
                    case INT: {
                        realField.setInt(subject, serialUnmarshaller.readInt());
                        continue block12;
                    }
                    case LONG: {
                        realField.setLong(subject, serialUnmarshaller.readLong());
                        continue block12;
                    }
                    case SHORT: {
                        realField.setShort(subject, serialUnmarshaller.readShort());
                    }
                }
            }
            for (SerializableField serializableField : this.fields) {
                if (serializableField.getKind() != Kind.OBJECT || (realField = serializableField.getField()) == null) continue;
                realField.set(subject, serialUnmarshaller.readObject());
            }
        }
        catch (IllegalAccessException e) {
            InvalidClassException ice = new InvalidClassException("Unexpected illegal access");
            ice.initCause(e);
            throw ice;
        }
    }

    ObjectInputStream.GetField getField(SerialUnmarshaller serialUnmarshaller, SerializableClass sc) throws IOException, ClassNotFoundException {
        BooleanReadField readField;
        final HashMap<String, BooleanReadField> readFields = new HashMap<String, BooleanReadField>();
        block24: for (SerializableField serializableField : sc.getFields()) {
            switch (serializableField.getKind()) {
                case BOOLEAN: {
                    readField = new BooleanReadField(serializableField);
                    break;
                }
                case BYTE: {
                    readField = new ByteReadField(serializableField);
                    break;
                }
                case CHAR: {
                    readField = new CharReadField(serializableField);
                    break;
                }
                case DOUBLE: {
                    readField = new DoubleReadField(serializableField);
                    break;
                }
                case FLOAT: {
                    readField = new FloatReadField(serializableField);
                    break;
                }
                case INT: {
                    readField = new IntReadField(serializableField);
                    break;
                }
                case LONG: {
                    readField = new LongReadField(serializableField);
                    break;
                }
                case OBJECT: {
                    readField = new ObjectReadField(serializableField);
                    break;
                }
                case SHORT: {
                    readField = new ShortReadField(serializableField);
                    break;
                }
                default: {
                    continue block24;
                }
            }
            readFields.put(serializableField.getName(), readField);
        }
        block25: for (SerializableField serializableField : this.fields) {
            switch (serializableField.getKind()) {
                case BOOLEAN: {
                    readField = new BooleanReadField(serializableField, serialUnmarshaller.readBoolean());
                    break;
                }
                case BYTE: {
                    readField = new ByteReadField(serializableField, serialUnmarshaller.readByte());
                    break;
                }
                case CHAR: {
                    readField = new CharReadField(serializableField, serialUnmarshaller.readChar());
                    break;
                }
                case DOUBLE: {
                    readField = new DoubleReadField(serializableField, serialUnmarshaller.readDouble());
                    break;
                }
                case FLOAT: {
                    readField = new FloatReadField(serializableField, serialUnmarshaller.readFloat());
                    break;
                }
                case INT: {
                    readField = new IntReadField(serializableField, serialUnmarshaller.readInt());
                    break;
                }
                case LONG: {
                    readField = new LongReadField(serializableField, serialUnmarshaller.readLong());
                    break;
                }
                case SHORT: {
                    readField = new ShortReadField(serializableField, serialUnmarshaller.readShort());
                    break;
                }
                default: {
                    continue block25;
                }
            }
            readFields.put(serializableField.getName(), readField);
        }
        block26: for (SerializableField serializableField : this.fields) {
            switch (serializableField.getKind()) {
                case OBJECT: {
                    readField = new ObjectReadField(serializableField, serialUnmarshaller.readObject());
                    break;
                }
                default: {
                    continue block26;
                }
            }
            readFields.put(serializableField.getName(), readField);
        }
        return new ObjectInputStream.GetField(){

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                throw new UnsupportedOperationException("getObjectStreamClass()");
            }

            @Override
            public boolean defaulted(String name) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted();
            }

            @Override
            public boolean get(String name, boolean val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getBoolean();
            }

            @Override
            public byte get(String name, byte val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getByte();
            }

            @Override
            public char get(String name, char val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getChar();
            }

            @Override
            public short get(String name, short val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getShort();
            }

            @Override
            public int get(String name, int val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getInt();
            }

            @Override
            public long get(String name, long val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getLong();
            }

            @Override
            public float get(String name, float val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getFloat();
            }

            @Override
            public double get(String name, double val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getDouble();
            }

            @Override
            public Object get(String name, Object val) throws IOException {
                ReadField field = (ReadField)readFields.get(name);
                return field == null || field.isDefaulted() ? val : field.getObject();
            }
        };
    }
}

