/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.serial.ExtendedObjectStreamConstants;

public final class Serial
implements ExtendedObjectStreamConstants {
    private Serial() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStream(InputStream serializedData, Writer destination) throws IOException {
        DataInputStream dis = serializedData instanceof DataInputStream ? (DataInputStream)serializedData : new DataInputStream(serializedData);
        BufferedWriter bw = destination instanceof BufferedWriter ? (BufferedWriter)destination : new BufferedWriter(destination);
        try {
            Serial.dumpStream(dis, bw);
        }
        finally {
            bw.flush();
            destination.flush();
        }
    }

    private static void dumpStream(DataInputStream serializedData, BufferedWriter destination) throws IOException {
        AtomicInteger seq = new AtomicInteger(0x7E0000);
        HashMap<Integer, ClassInfo> descrs = new HashMap<Integer, ClassInfo>();
        if (serializedData.readShort() != -21267) {
            Serial.printf(destination, 0, "Stream magic INVALID", new Object[0]);
            return;
        }
        Serial.printf(destination, 0, "[%04x] Stream magic", 44269);
        destination.write(String.format("[%04x] Stream version\n", serializedData.readUnsignedShort()));
        while (true) {
            int i;
            if ((i = serializedData.read()) == -1) {
                destination.write("--- End of stream ---\n");
                return;
            }
            Serial.dumpContent(descrs, seq, serializedData, destination, 0, i);
        }
    }

    private static void dumpContent(Map<Integer, ClassInfo> descrMap, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth, int leadByte) throws IOException {
        switch (leadByte) {
            case 119: {
                int len = dis.readUnsignedByte();
                Serial.printf(w, depth, "[%02x] TC_BLOCKDATA - Data block of %d bytes", 119, len);
                for (int i = 0; i < len; i += dis.skipBytes(len - i)) {
                }
                return;
            }
            case 122: {
                int len = dis.readInt();
                Serial.printf(w, depth, "[%02x] TC_BLOCKDATA - Data block of %d bytes", 119, len);
                for (int i = 0; i < len; i += dis.skipBytes(len - i)) {
                }
                return;
            }
        }
        Serial.dumpObject(descrMap, seq, dis, w, depth, leadByte);
    }

    private static void dumpObject(Map<Integer, ClassInfo> descrMap, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth, int leadByte) throws IOException {
        switch (leadByte) {
            case 115: {
                Serial.printf(w, depth, "[%02x] TC_OBJECT - New object", 115);
                ClassInfo classInfo = Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 1, dis.readUnsignedByte());
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth + 1, "[--] New object handle is [%08x]", handle);
                Serial.dumpFields(classInfo, descrMap, seq, dis, w, depth + 1);
                return;
            }
            case 241: {
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth, "[%02x] TC_OBJECTTABLE - New object from table, handle is [%08x]", 241, handle);
                Serial.dumpBlockData(descrMap, seq, dis, w, depth + 1);
            }
            case 118: {
                Serial.printf(w, depth, "[%02x] TC_CLASS - New class", 118);
                Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 1, dis.readUnsignedByte());
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth + 1, "[--] New class handle is [%08x]", handle);
                return;
            }
            case 117: {
                Serial.printf(w, depth, "[%02x] TC_ARRAY - New array", 117);
                ClassInfo classInfo = Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 1, dis.readUnsignedByte());
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth + 1, "[--] New array handle is [%08x]", handle);
                int len = dis.readInt();
                Serial.printf(w, depth + 1, "[%x08] Array of length %d", len, len);
                for (int i = 0; i < len; ++i) {
                    FieldType fieldType = FieldType.fromTypeCode(classInfo.name.charAt(1));
                    Serial.printf(w, depth + 2, "[%d] = %s", i, fieldType.getValueString(dis));
                    if (!fieldType.isObject()) continue;
                    Serial.dumpObject(descrMap, seq, dis, w, depth + 3, dis.readUnsignedByte());
                }
                return;
            }
            case 116: 
            case 124: {
                Serial.dumpString(descrMap, seq, dis, w, depth, leadByte);
                return;
            }
            case 126: {
                Serial.printf(w, depth, "[%02x] TC_ENUM - New enum", 126);
                Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 1, dis.readUnsignedByte());
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth + 1, "[--] New enum handle is [%08x], constant name follows", handle);
                Serial.dumpString(descrMap, seq, dis, w, depth + 2, dis.readUnsignedByte());
                return;
            }
            case 114: 
            case 125: 
            case 240: {
                Serial.dumpDescriptor(descrMap, seq, dis, w, depth, leadByte);
                return;
            }
            case 113: {
                Serial.printf(w, depth, "[%02x] TC_REFERENCE - Backreference [%08x]", 113, dis.readInt());
                return;
            }
            case 112: {
                Serial.printf(w, depth, "[%02x] TC_NULL - Null value", 112);
                return;
            }
        }
        throw new IllegalStateException("Wrong lead byte: " + leadByte);
    }

    private static void dumpString(Map<Integer, ClassInfo> descrMap, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth, int leadByte) throws IOException {
        switch (leadByte) {
            case 116: {
                int handle = seq.getAndIncrement();
                String str = dis.readUTF();
                Serial.printf(w, depth, "[%02x] TC_STRING - New string, handle [%08x] = \"%s\"", 116, handle, str);
                return;
            }
            case 124: {
                int handle = seq.getAndIncrement();
                String str = UTFUtils.readUTFBytesByByteCount((ByteInput)Marshalling.createByteInput((InputStream)dis), (long)dis.readLong());
                Serial.printf(w, depth, "[%02x] TC_LONGSTRING - New string, handle [%08x] = \"%s\"", 124, handle, str);
                return;
            }
            case 113: {
                Serial.printf(w, depth, "[%02x] TC_REFERENCE - Backreference [%08x]", 113, dis.readInt());
                return;
            }
            case 112: {
                Serial.printf(w, depth, "[%02x] TC_NULL - Null value", 112);
                return;
            }
        }
        throw new IllegalStateException("Wrong lead byte: " + leadByte);
    }

    private static void dumpFields(ClassInfo info, Map<Integer, ClassInfo> map, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth) throws IOException {
        if ((info.flags & 4) != 0) {
            Serial.printf(w, depth, "[--] Externalizable data block:", new Object[0]);
            Serial.dumpBlockData(map, seq, dis, w, depth + 1);
        } else if ((info.flags & 2) != 0) {
            if (info.parent != null) {
                Serial.dumpFields(info.parent, map, seq, dis, w, depth);
            }
            Serial.printf(w, depth, "[--] Fields for class %s:", info.name);
            for (FieldInfo fieldInfo : info.info) {
                Serial.printf(w, depth + 1, "[--] Field %s = %s", fieldInfo.name, fieldInfo.type.getValueString(dis));
                if (!fieldInfo.type.isObject()) continue;
                Serial.dumpObject(map, seq, dis, w, depth + 2, dis.readUnsignedByte());
            }
            if ((info.flags & 1) != 0) {
                Serial.printf(w, depth, "[--] Custom data for class %s:", info.name);
                Serial.dumpBlockData(map, seq, dis, w, depth + 1);
            }
        } else {
            if (info.parent != null) {
                Serial.dumpFields(info.parent, map, seq, dis, w, depth);
            }
            Serial.printf(w, depth, "[--] No info for class %s", info.name);
        }
    }

    private static void dumpBlockData(Map<Integer, ClassInfo> map, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth) throws IOException {
        while (true) {
            int leadByte;
            if ((leadByte = dis.readUnsignedByte()) == 120) {
                Serial.printf(w, depth, "[%02x] TC_ENDBLOCKDATA - End block data", (byte)120);
                return;
            }
            Serial.dumpContent(map, seq, dis, w, depth, leadByte);
        }
    }

    private static ClassInfo dumpDescriptor(Map<Integer, ClassInfo> descrMap, AtomicInteger seq, DataInputStream dis, BufferedWriter w, int depth, int leadByte) throws IOException {
        switch (leadByte) {
            case 113: {
                int h = dis.readInt();
                Serial.printf(w, depth, "[%02x] TC_REFERENCE - Backreference [%08x]", 113, h);
                return descrMap.get(h);
            }
            case 112: {
                Serial.printf(w, depth, "[%02x] TC_NULL - Null value", 112);
                return null;
            }
            case 240: {
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth, "[%02x] TC_CLASSTABLEDESC - New class descriptor from table, handle [%08x] - stream is indeterminate from this point on", 240, handle);
                Serial.dumpBlockData(descrMap, seq, dis, w, depth);
                return null;
            }
            case 114: {
                String name = dis.readUTF();
                long svu = dis.readLong();
                int handle = seq.getAndIncrement();
                Serial.printf(w, depth, "[%02x] TC_CLASSDESC - New class descriptor, class = \"%s\", uid = %d, handle [%08x]", 114, name, svu, handle);
                int flags = dis.readUnsignedByte();
                int fieldCount = dis.readUnsignedShort();
                FieldInfo[] info = new FieldInfo[fieldCount];
                Serial.printf(w, depth + 1, "[--] Flags: (" + ((flags & 8) != 0 ? " SC_BLOCK_DATA" : "") + ((flags & 0x10) != 0 ? " SC_ENUM" : "") + ((flags & 4) != 0 ? " SC_EXTERNALIZABLE" : "") + ((flags & 2) != 0 ? " SC_SERIALIZABLE" : "") + ((flags & 1) != 0 ? " SC_WRITE_METHOD" : "") + ")", new Object[0]);
                Serial.printf(w, depth + 1, "[--] %d fields", fieldCount);
                for (int i = 0; i < fieldCount; ++i) {
                    int typeCode = dis.readUnsignedByte();
                    String fieldName = dis.readUTF();
                    Serial.printf(w, depth + 2, "[--] Field \"%s\" type code '%s'%s", fieldName, Character.toString((char)typeCode), typeCode == 91 || typeCode == 76 ? ", type name follows" : "");
                    if (typeCode == 91 || typeCode == 76) {
                        Serial.dumpString(descrMap, seq, dis, w, depth + 3, dis.readUnsignedByte());
                    }
                    info[i] = new FieldInfo();
                    info[i].name = fieldName;
                    info[i].type = FieldType.fromTypeCode(typeCode);
                }
                Serial.printf(w, depth + 1, "[--] Class desc data block:", new Object[0]);
                Serial.dumpBlockData(descrMap, seq, dis, w, depth + 2);
                ClassInfo classInfo = new ClassInfo();
                descrMap.put(handle, classInfo);
                classInfo.info = Arrays.asList(info);
                classInfo.name = name;
                classInfo.flags = flags;
                classInfo.svu = svu;
                Serial.printf(w, depth + 1, "[--] Superclass descriptor follows", new Object[0]);
                classInfo.parent = Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 3, dis.readUnsignedByte());
                return classInfo;
            }
            case 125: {
                int handle = seq.getAndIncrement();
                int count = dis.readInt();
                Serial.printf(w, depth, "[%02x] TC_PROXYCLASSDESC - New proxy class descriptor, %d interfaces", 125, count);
                for (int i = 0; i < count; ++i) {
                    Serial.printf(w, depth + 1, "[--] Interface: \"%s\"", dis.readUTF());
                }
                Serial.printf(w, depth + 1, "[--] Class desc data block:", new Object[0]);
                Serial.dumpBlockData(descrMap, seq, dis, w, depth + 2);
                ClassInfo classInfo = new ClassInfo();
                descrMap.put(handle, classInfo);
                classInfo.info = Collections.emptyList();
                classInfo.name = String.format("proxy class %08x", handle);
                Serial.printf(w, depth + 2, "[--] Superclass descriptor follows", new Object[0]);
                classInfo.parent = Serial.dumpDescriptor(descrMap, seq, dis, w, depth + 3, dis.readUnsignedByte());
                return classInfo;
            }
        }
        throw new IllegalStateException("Wrong lead byte: " + leadByte);
    }

    private static void printf(BufferedWriter w, int depth, String format, Object ... args) throws IOException {
        for (int i = 0; i < depth; ++i) {
            w.write("    ");
        }
        w.write(String.format(format + "\n", args));
        w.flush();
    }

    private static final class ClassInfo {
        private List<FieldInfo> info;
        private int flags;
        private long svu;
        private String name;
        private ClassInfo parent;

        private ClassInfo() {
        }
    }

    private static final class FieldInfo {
        private FieldType type;
        private String name;

        private FieldInfo() {
        }
    }

    private static enum FieldType {
        BOOLEAN(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<boolean> " + Boolean.toString(dis.readBoolean());
            }
        }
        ,
        BYTE(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<byte> " + Byte.toString(dis.readByte());
            }
        }
        ,
        CHAR(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<char> " + Character.toString(dis.readChar());
            }
        }
        ,
        DOUBLE(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<double> " + Double.toString(dis.readDouble());
            }
        }
        ,
        FLOAT(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<float> " + Float.toString(dis.readFloat());
            }
        }
        ,
        INTEGER(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<int> " + Integer.toString(dis.readInt());
            }
        }
        ,
        LONG(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<long> " + Long.toString(dis.readLong());
            }
        }
        ,
        SHORT(false){

            @Override
            public Object getValueString(DataInputStream dis) throws IOException {
                return "<short> " + Short.toString(dis.readShort());
            }
        }
        ,
        OBJECT(true){

            @Override
            public Object getValueString(DataInputStream dis) {
                return "<object>";
            }
        };

        private final boolean obj;

        private FieldType(boolean obj) {
            this.obj = obj;
        }

        public abstract Object getValueString(DataInputStream var1) throws IOException;

        public boolean isObject() {
            return this.obj;
        }

        public static FieldType fromTypeCode(int typeCode) {
            switch (typeCode) {
                case 66: {
                    return BYTE;
                }
                case 67: {
                    return CHAR;
                }
                case 68: {
                    return DOUBLE;
                }
                case 70: {
                    return FLOAT;
                }
                case 73: {
                    return INTEGER;
                }
                case 74: {
                    return LONG;
                }
                case 83: {
                    return SHORT;
                }
                case 90: {
                    return BOOLEAN;
                }
            }
            return OBJECT;
        }
    }
}

