/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutputStream;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectOutputStream;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.RiverMarshaller;
import org.jboss.marshalling.river.RiverPutField;
import org.jboss.marshalling.util.BooleanFieldPutter;
import org.jboss.marshalling.util.ByteFieldPutter;
import org.jboss.marshalling.util.CharFieldPutter;
import org.jboss.marshalling.util.DoubleFieldPutter;
import org.jboss.marshalling.util.FieldPutter;
import org.jboss.marshalling.util.FloatFieldPutter;
import org.jboss.marshalling.util.IntFieldPutter;
import org.jboss.marshalling.util.LongFieldPutter;
import org.jboss.marshalling.util.ObjectFieldPutter;
import org.jboss.marshalling.util.ShortFieldPutter;

class RiverObjectOutputStream
extends MarshallerObjectOutputStream {
    private static final int OFF = 0;
    private static final int UNWRITTEN_FIELDS = 1;
    private static final int ON = 2;
    private final RiverMarshaller marshaller;
    private int state;
    private RiverPutField putField;
    private SerializableClass serializableClass;
    private Object current;

    protected RiverObjectOutputStream(Marshaller delegateMarshaller, RiverMarshaller marshaller) throws IOException, SecurityException {
        super(delegateMarshaller);
        this.marshaller = marshaller;
    }

    private boolean compareAndSetState(int expect, int set) {
        if (this.state == expect) {
            this.state = set;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndSetState(int set) {
        try {
            int n = this.state;
            return n;
        }
        finally {
            this.state = set;
        }
    }

    public void writeFields() throws IOException {
        RiverPutField putField = this.putField;
        if (putField == null) {
            throw new NotActiveException("no current PutField object");
        }
        if (!this.compareAndSetState(1, 2)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        this.putField = null;
        putField.write((Marshaller)this.marshaller);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.state == 0) {
            throw new NotActiveException("No object is currently being serialized");
        }
        if (this.putField == null) {
            SerializableField[] serializableFields = this.serializableClass.getFields();
            int cnt = serializableFields.length;
            FieldPutter[] fields = new FieldPutter[cnt];
            String[] names = new String[cnt];
            block11: for (int i = 0; i < cnt; ++i) {
                SerializableField field = serializableFields[i];
                names[i] = field.getName();
                switch (field.getKind()) {
                    case BOOLEAN: {
                        fields[i] = new BooleanFieldPutter();
                        continue block11;
                    }
                    case BYTE: {
                        fields[i] = new ByteFieldPutter();
                        continue block11;
                    }
                    case CHAR: {
                        fields[i] = new CharFieldPutter();
                        continue block11;
                    }
                    case DOUBLE: {
                        fields[i] = new DoubleFieldPutter();
                        continue block11;
                    }
                    case FLOAT: {
                        fields[i] = new FloatFieldPutter();
                        continue block11;
                    }
                    case INT: {
                        fields[i] = new IntFieldPutter();
                        continue block11;
                    }
                    case LONG: {
                        fields[i] = new LongFieldPutter();
                        continue block11;
                    }
                    case OBJECT: {
                        fields[i] = new ObjectFieldPutter(field.isUnshared());
                        continue block11;
                    }
                    case SHORT: {
                        fields[i] = new ShortFieldPutter();
                    }
                }
            }
            this.putField = new RiverPutField(fields, names);
        }
        return this.putField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClass swapClass(SerializableClass newSerializableClass) {
        try {
            SerializableClass serializableClass = this.serializableClass;
            return serializableClass;
        }
        finally {
            this.serializableClass = newSerializableClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object current) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultWriteObject() throws IOException {
        if (!this.compareAndSetState(1, 2)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        try {
            this.marshaller.doWriteFields(this.serializableClass, this.current);
        }
        finally {
            this.putField = null;
            this.serializableClass = null;
            this.current = null;
        }
    }

    protected int start() throws IOException {
        return this.getAndSetState(1);
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        this.checkState();
        super.writeObjectOverride(obj);
    }

    public void writeUnshared(Object obj) throws IOException {
        this.checkState();
        super.writeUnshared(obj);
    }

    public void write(int val) throws IOException {
        this.checkState();
        super.write(val);
    }

    public void write(byte[] buf) throws IOException {
        this.checkState();
        super.write(buf);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.checkState();
        super.write(buf, off, len);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.checkState();
        super.writeBoolean(val);
    }

    public void writeByte(int val) throws IOException {
        this.checkState();
        super.writeByte(val);
    }

    public void writeShort(int val) throws IOException {
        this.checkState();
        super.writeShort(val);
    }

    public void writeChar(int val) throws IOException {
        this.checkState();
        super.writeChar(val);
    }

    public void writeInt(int val) throws IOException {
        this.checkState();
        super.writeInt(val);
    }

    public void writeLong(long val) throws IOException {
        this.checkState();
        super.writeLong(val);
    }

    public void writeFloat(float val) throws IOException {
        this.checkState();
        super.writeFloat(val);
    }

    public void writeDouble(double val) throws IOException {
        this.checkState();
        super.writeDouble(val);
    }

    public void writeBytes(String str) throws IOException {
        this.checkState();
        super.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        this.checkState();
        super.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        this.checkState();
        super.writeUTF(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(int restoreState) throws IOException {
        try {
            if (this.state == 1) {
                this.marshaller.doWriteEmptyFields(this.serializableClass);
            }
        }
        finally {
            this.state = restoreState;
        }
    }

    private void checkState() throws IOException {
        int state = this.state;
        if (state == 2) {
            return;
        }
        if (state == 0) {
            throw new NotActiveException("Object stream not active");
        }
        if (state == 1) {
            this.state = 2;
            this.marshaller.doWriteEmptyFields(this.serializableClass);
            return;
        }
        throw new IllegalStateException("Unknown state");
    }

    protected void fullReset() {
        this.state = 0;
        this.putField = null;
        this.serializableClass = null;
        this.current = null;
    }
}

