/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.RecordComponent;
import org.jboss.marshalling.reflect.SerializableField;

final class JDKSpecific {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    JDKSpecific() {
    }

    static boolean isRecord(Class<?> type) {
        return type.isRecord();
    }

    static SerializableField.RecordComponent[] getRecordComponents(Class<?> type) {
        RecordComponent[] recordComponents = type.getRecordComponents();
        SerializableField.RecordComponent[] result = new SerializableField.RecordComponent[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = new SerializableField.RecordComponent(recordComponents[i].getName(), recordComponents[i].getType(), i);
        }
        return result;
    }

    static Object getRecordComponentValue(Object recordObject, String name, Class<?> type) {
        try {
            MethodHandle methodHandle = LOOKUP.findVirtual(recordObject.getClass(), name, MethodType.methodType(type));
            return methodHandle.invoke(recordObject);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot invoke record getter " + name + " in object " + recordObject, e);
        }
    }

    static Object invokeRecordCanonicalConstructor(Class<?> recordType, SerializableField[] fields, Object[] args) {
        try {
            Class[] paramTypes = new Class[fields.length];
            for (SerializableField field : fields) {
                paramTypes[field.getRecordComponentIndex()] = field.getType();
            }
            MethodHandle constructorHandle = MethodHandles.privateLookupIn(recordType, LOOKUP).findConstructor(recordType, MethodType.methodType(Void.TYPE, paramTypes)).asType(MethodType.methodType(Object.class, paramTypes));
            return constructorHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error calling constructor on record class " + recordType, e);
        }
    }
}

