/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jboss.marshalling.ObjectInputFilterAdapter;
import org.jboss.marshalling.UnmarshallingObjectInputFilter;
import org.jboss.marshalling.UnmarshallingObjectInputFilterAdapter;
import sun.reflect.ReflectionFactory;

final class JDKSpecific {
    private static final Logger LOG = Logger.getLogger(JDKSpecific.class.getName());
    private static final ReflectionFactory reflectionFactory = System.getSecurityManager() == null ? ReflectionFactory.getReflectionFactory() : AccessController.doPrivileged(new PrivilegedAction<ReflectionFactory>(){

        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    });
    private static final StackWalker stackWalker = System.getSecurityManager() == null ? StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE) : AccessController.doPrivileged(new PrivilegedAction<StackWalker>(){

        @Override
        public StackWalker run() {
            return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        }
    });
    private static final Function<Stream<StackWalker.StackFrame>, Class<?>> callerFinder = new Function<Stream<StackWalker.StackFrame>, Class<?>>(){

        @Override
        public Class<?> apply(Stream<StackWalker.StackFrame> stream) {
            StackWalker.StackFrame frame;
            Iterator iterator = stream.iterator();
            do {
                if (iterator.hasNext()) continue;
                throw new IllegalStateException();
            } while ((frame = (StackWalker.StackFrame)iterator.next()).getDeclaringClass() != JDKSpecific.class);
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            return ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
        }
    };

    private JDKSpecific() {
    }

    static OptionalDataException createOptionalDataException(int length) {
        OptionalDataException optionalDataException = JDKSpecific.createOptionalDataException(false);
        optionalDataException.length = length;
        return optionalDataException;
    }

    static OptionalDataException createOptionalDataException(boolean eof) {
        return reflectionFactory.newOptionalDataExceptionForSerialization(eof);
    }

    static Class<?> getMyCaller() {
        return stackWalker.walk(callerFinder);
    }

    static void setObjectInputStreamFilter(ObjectInputStream ois, UnmarshallingObjectInputFilter filter) {
        LOG.finer(String.format("Setting UnmarshallingFilter %s to ObjectInputStream %s", filter, ois));
        ois.setObjectInputFilter(new ObjectInputFilterAdapter(filter));
    }

    static UnmarshallingObjectInputFilter getJEPS290ProcessWideFilter() {
        ObjectInputFilter serialFilter = ObjectInputFilter.Config.getSerialFilter();
        if (serialFilter != null) {
            return new UnmarshallingObjectInputFilterAdapter(serialFilter);
        }
        return null;
    }
}

