/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.log4j.Appender;
import org.apache.log4j.JBossFilterWrapper;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Logger;

final class JBossAppenderHandler
extends ExtHandler {
    private static final Logger.AttachmentKey<CopyOnWriteArrayList<Appender>> APPENDERS_KEY = new Logger.AttachmentKey();
    private final org.jboss.logmanager.Logger logger;

    private JBossAppenderHandler(org.jboss.logmanager.Logger logger) {
        this.logger = logger;
    }

    public static void createAndAttach(org.jboss.logmanager.Logger logger) {
        if (logger.getAttachment(APPENDERS_KEY) == null) {
            CopyOnWriteArrayList list = new CopyOnWriteArrayList();
            CopyOnWriteArrayList existing = (CopyOnWriteArrayList)logger.attachIfAbsent(APPENDERS_KEY, list);
            if (existing != null) {
                list = existing;
            } else {
                JBossAppenderHandler handler = new JBossAppenderHandler(logger);
                logger.addHandler((Handler)((Object)handler));
            }
        }
    }

    protected void doPublish(ExtLogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "";
        }
        if (loggerName.equals(this.logger.getName())) {
            LoggingEvent event = new LoggingEvent(record, JBossLogManagerFacade.getLogger(this.logger));
            List<Appender> appenders = JBossAppenderHandler.getAllAppenders(this.logger);
            for (Appender appender : appenders) {
                if (!new JBossFilterWrapper(appender.getFilter(), true).isLoggable((LogRecord)record)) continue;
                appender.doAppend(event);
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        JBossAppenderHandler.checkAccess((ExtHandler)this);
        JBossAppenderHandler.closeAppenders(this.logger);
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = 31 * hash + (this.logger == null ? 0 : this.logger.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBossAppenderHandler)) {
            return false;
        }
        JBossAppenderHandler other = (JBossAppenderHandler)((Object)obj);
        return this.logger == null ? other.logger == null : this.logger.equals(other.logger);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass() + "{" + this.logger.getName() + "}";
    }

    public static void attachAppender(org.jboss.logmanager.Logger logger, Appender appender) {
        JBossAppenderHandler.getAppenderList(logger).addIfAbsent(appender);
    }

    public static List<Appender> getAppenders(org.jboss.logmanager.Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = JBossAppenderHandler.getAppenderList(logger);
        if (appenders == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Appender>(appenders);
    }

    public static List<Appender> getAllAppenders(org.jboss.logmanager.Logger logger) {
        ArrayList<Appender> result = new ArrayList<Appender>();
        JBossAppenderHandler.getAllAppenders(logger, result);
        return result;
    }

    static void getAllAppenders(org.jboss.logmanager.Logger logger, List<Appender> result) {
        Logger category;
        result.addAll(JBossAppenderHandler.getAppenderList(logger));
        if (logger.getUseParentHandlers() && (category = JBossLogManagerFacade.getLogger(logger)) != null && category.getParent() != null) {
            JBossAppenderHandler.getAllAppenders(category.getParent().jblmLogger, result);
        }
    }

    public static Appender getAppender(org.jboss.logmanager.Logger logger, String name) {
        Appender result = null;
        if (name != null) {
            List<Appender> appenders = JBossAppenderHandler.getAppenders(logger);
            for (Appender appender : appenders) {
                if (!name.equals(appender.getName())) continue;
                result = appender;
                break;
            }
        }
        return result;
    }

    public static boolean isAppenderAttached(org.jboss.logmanager.Logger logger, Appender appender) {
        return JBossAppenderHandler.getAppenders(logger).contains(appender);
    }

    public static List<Appender> removeAllAppenders(org.jboss.logmanager.Logger logger) {
        List<Appender> result = Collections.emptyList();
        CopyOnWriteArrayList<Appender> currentAppenders = JBossAppenderHandler.getAppenderList(logger);
        if (currentAppenders != null && !currentAppenders.isEmpty()) {
            result = new ArrayList<Appender>(currentAppenders);
            currentAppenders.clear();
        }
        return result;
    }

    public static boolean removeAppender(org.jboss.logmanager.Logger logger, Appender appender) {
        boolean result = false;
        CopyOnWriteArrayList<Appender> currentAppenders = JBossAppenderHandler.getAppenderList(logger);
        if (currentAppenders != null) {
            result = currentAppenders.remove(appender);
        }
        return result;
    }

    public static void closeAppenders(org.jboss.logmanager.Logger logger) {
        CopyOnWriteArrayList<Appender> appenders = JBossAppenderHandler.getAppenderList(logger);
        for (Appender appender : appenders) {
            if (!(appender instanceof AppenderAttachable)) continue;
            appender.close();
        }
    }

    private static CopyOnWriteArrayList<Appender> getAppenderList(org.jboss.logmanager.Logger logger) {
        CopyOnWriteArrayList current;
        CopyOnWriteArrayList result = (CopyOnWriteArrayList)logger.getAttachment(APPENDERS_KEY);
        if (result == null && (current = (CopyOnWriteArrayList)logger.attachIfAbsent(APPENDERS_KEY, result = new CopyOnWriteArrayList())) != null) {
            result = current;
        }
        return result;
    }
}

