/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import javax.net.SocketFactory;
import org.jboss.logmanager.handlers.FlushableCloseable;

public class TcpOutputStream
extends OutputStream
implements FlushableCloseable {
    private static final long retryTimeout = 5L;
    private static final long maxRetryTimeout = 40L;
    private static final int maxErrors = 10;
    protected final Object outputLock = new Object();
    private final SocketFactory socketFactory;
    private final InetAddress address;
    private final int port;
    private final Deque<Exception> errors = new ArrayDeque<Exception>(10);
    private Thread reconnectThread;
    private boolean blockOnReconnect;
    private Socket socket;
    private boolean connected;

    public TcpOutputStream(InetAddress address, int port) throws IOException {
        this(SocketFactory.getDefault(), address, port);
    }

    public TcpOutputStream(InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this(SocketFactory.getDefault(), address, port, blockOnReconnect);
    }

    @Deprecated
    protected TcpOutputStream(Socket socket) {
        this.socketFactory = null;
        this.address = null;
        this.port = -1;
        this.socket = socket;
        this.reconnectThread = null;
        this.connected = true;
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port) throws IOException {
        this(socketFactory, address, port, false);
    }

    protected TcpOutputStream(SocketFactory socketFactory, InetAddress address, int port, boolean blockOnReconnect) throws IOException {
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.blockOnReconnect = blockOnReconnect;
        try {
            this.socket = socketFactory.createSocket(address, port);
            this.connected = true;
        }
        catch (IOException e) {
            this.connected = false;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            try {
                this.checkReconnect();
                if (this.connected) {
                    this.socket.getOutputStream().write(b, off, len);
                }
            }
            catch (SocketException e) {
                if (this.isReconnectAllowed()) {
                    TcpOutputStream.safeClose(this.socket);
                    this.connected = false;
                    this.addError(e);
                    this.reconnectThread = this.createThread();
                    if (this.blockOnReconnect) {
                        this.reconnectThread.run();
                        this.write(b, off, len);
                    } else {
                        this.reconnectThread.start();
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            try {
                this.socket.getOutputStream().flush();
            }
            catch (SocketException e) {
                if (this.isReconnectAllowed()) {
                    TcpOutputStream.safeClose(this.socket);
                    this.connected = false;
                    this.addError(e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.reconnectThread != null) {
                this.reconnectThread.interrupt();
            }
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockOnReconnect() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.blockOnReconnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockOnReconnect(boolean blockOnReconnect) {
        Object object = this.outputLock;
        synchronized (object) {
            this.blockOnReconnect = blockOnReconnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Exception> getErrors() {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (!this.errors.isEmpty()) {
                ArrayList<Exception> result = new ArrayList<Exception>(this.errors);
                this.errors.clear();
                return result;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(Exception e) {
        Deque<Exception> deque = this.errors;
        synchronized (deque) {
            if (this.errors.size() < 10) {
                this.errors.addLast(e);
            }
        }
    }

    private boolean isReconnectAllowed() {
        return this.socketFactory != null && this.reconnectThread == null;
    }

    private void checkReconnect() {
        if (!this.connected && this.isReconnectAllowed()) {
            this.reconnectThread = this.createThread();
            if (this.blockOnReconnect) {
                this.reconnectThread.run();
            } else {
                this.reconnectThread.start();
            }
        }
    }

    private Thread createThread() {
        Thread thread = new Thread(new RetryConnector());
        thread.setDaemon(true);
        thread.setName("LogManager Socket Reconnect Thread");
        return thread;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ SocketFactory access$100(TcpOutputStream x0) {
        return x0.socketFactory;
    }

    static /* synthetic */ InetAddress access$200(TcpOutputStream x0) {
        return x0.address;
    }

    static /* synthetic */ int access$300(TcpOutputStream x0) {
        return x0.port;
    }

    static /* synthetic */ void access$400(Closeable x0) {
        TcpOutputStream.safeClose(x0);
    }

    static /* synthetic */ Socket access$502(TcpOutputStream x0, Socket x1) {
        x0.socket = x1;
        return x0.socket;
    }

    static /* synthetic */ boolean access$602(TcpOutputStream x0, boolean x1) {
        x0.connected = x1;
        return x0.connected;
    }

    static /* synthetic */ Thread access$702(TcpOutputStream x0, Thread x1) {
        x0.reconnectThread = x1;
        return x0.reconnectThread;
    }

    static /* synthetic */ void access$800(TcpOutputStream x0, Exception x1) {
        x0.addError(x1);
    }

    private class RetryConnector
    implements Runnable {
        private int attempts = 0;

        private RetryConnector() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[MONITOR]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

