/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.logmanager.filters;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

/**
 * An accept-all filter.
 */
public final class AcceptAllFilter implements Filter {
    private AcceptAllFilter() {}

    private static final AcceptAllFilter INSTANCE = new AcceptAllFilter();

    /**
     * Always returns {@code true}.
     *
     * @param record ignored
     * @return {@code true}
     */
    public boolean isLoggable(final LogRecord record) {
        return true;
    }

    /**
     * Get the filter instance.
     *
     * @return the filter instance
     */
    public static AcceptAllFilter getInstance() {
        return INSTANCE;
    }
}