/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Suppressed;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static boolean isAnnotatedWith(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> clazz) {
        if (annotatedConstruct == null) {
            throw new IllegalArgumentException("The element parameter is null");
        }
        Annotation annotation = annotatedConstruct.getAnnotation(clazz);
        return annotation != null;
    }

    public static String getPrimaryClassNamePrefix(TypeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element parameter cannot be null");
        }
        if (!element.getKind().isInterface()) {
            throw new IllegalArgumentException("The element parameter is not an interface");
        }
        String translationFileName = element.getSimpleName().toString();
        for (Element enclosingElt = element.getEnclosingElement(); enclosingElt != null && enclosingElt instanceof TypeElement; enclosingElt = enclosingElt.getEnclosingElement()) {
            translationFileName = String.format("%s$%s", enclosingElt.getSimpleName().toString(), translationFileName);
        }
        return translationFileName;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!methodName.equals(method.getSimpleName())) continue;
            result.add(method);
        }
        return result;
    }

    public static Collection<ExecutableElement> findByName(Collection<ExecutableElement> methods, Name methodName, int paramCount) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            if (!methodName.equals(method.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) != paramCount) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean hasCause(Collection<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            if (!ElementHelper.isAnnotatedWith(variableElement, Cause.class)) continue;
            return true;
        }
        return false;
    }

    public static int parameterCount(Collection<? extends VariableElement> params) {
        int result = params.size();
        for (VariableElement variableElement : params) {
            if (!ElementHelper.isAnnotatedWith(variableElement, Param.class) && !ElementHelper.isAnnotatedWith(variableElement, Field.class) && !ElementHelper.isAnnotatedWith(variableElement, Property.class) && !ElementHelper.isAnnotatedWith(variableElement, Suppressed.class)) continue;
            --result;
        }
        return result - (ElementHelper.hasCause(params) ? 1 : 0);
    }

    public static boolean inheritsMessage(Collection<ExecutableElement> methods, ExecutableElement method) {
        if (ElementHelper.isAnnotatedWith(method, Message.class)) {
            return false;
        }
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!ElementHelper.isAnnotatedWith(m, Message.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverloaded(Collection<ExecutableElement> methods, ExecutableElement method) {
        Collection<ExecutableElement> allMethods = ElementHelper.findByName(methods, method.getSimpleName());
        for (ExecutableElement m : allMethods) {
            if (!method.getSimpleName().equals(m.getSimpleName()) || ElementHelper.parameterCount(method.getParameters()) == ElementHelper.parameterCount(m.getParameters())) continue;
            return true;
        }
        return false;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
            return (TypeElement)((DeclaredType)value.getValue()).asElement();
        }
        return null;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                return (TypeElement)((DeclaredType)map.get(executableElement).getValue()).asElement();
            }
        }
        return null;
    }

    public static List<TypeMirror> getClassArrayAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                List annotationValues = (List)map.get(executableElement).getValue();
                ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(annotationValues.size());
                for (AnnotationValue value : annotationValues) {
                    result.add((TypeMirror)value.getValue());
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static Collection<AnnotationMirror> getAnnotations(Element element, Class<? extends Annotation> groupedAnnotation, Class<? extends Annotation> annotation) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (ElementHelper.isSameType(groupedAnnotation, annotationMirror.getAnnotationType())) {
                result.addAll(ElementHelper.getContainingAnnotations(annotationMirror));
                continue;
            }
            if (!ElementHelper.isSameType(annotation, annotationMirror.getAnnotationType())) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    public static boolean hasConstructor(Types types, Element element, List<TypeMirror> args) {
        int len = args.size();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (len != parameters.size()) continue;
            boolean match = false;
            for (int i = 0; i < len; ++i) {
                VariableElement parameter;
                TypeMirror type = args.get(i);
                if (!types.isSameType(type, (parameter = parameters.get(i)).asType())) {
                    match = false;
                    break;
                }
                match = true;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static TypeMirror toType(Elements elements, Class<?> type) {
        return elements.getTypeElement(type.getCanonicalName()).asType();
    }

    private static boolean isSameType(Class<?> c, TypeMirror type) {
        return c != null && c.getCanonicalName().equals(type.toString());
    }

    private static Collection<AnnotationMirror> getContainingAnnotations(AnnotationMirror annotation) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> childAnnotations = annotation.getElementValues();
        childAnnotations.entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")).forEach(entry -> {
            Object value = ((AnnotationValue)entry.getValue()).getValue();
            if (value instanceof List) {
                List values = (List)value;
                for (AnnotationValue subValue : values) {
                    if (subValue instanceof AnnotationMirror) {
                        result.add((AnnotationMirror)((Object)subValue));
                        continue;
                    }
                    result.add((AnnotationMirror)subValue.getValue());
                }
            }
        });
        return result;
    }
}

