/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.processor.apt.report.AsciidocReportWriter;
import org.jboss.logging.processor.apt.report.ReportType;
import org.jboss.logging.processor.apt.report.XmlReportWriter;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

public abstract class ReportWriter
implements Closeable {
    protected final BufferedWriter writer;

    protected ReportWriter(BufferedWriter writer) {
        this.writer = writer;
    }

    public static ReportWriter of(ReportType reportType, BufferedWriter writer) {
        if (reportType == ReportType.ASCIIDOC) {
            return new AsciidocReportWriter(writer);
        }
        if (reportType == ReportType.XML) {
            try {
                return new XmlReportWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Failed to create XML report writer.", e);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)reportType) + " is not a known report type.");
    }

    public abstract void write(MessageInterface var1) throws IOException;

    public void writeStart(Optional<String> title) throws IOException {
    }

    public void writeEnd() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    protected String getLogLevel(MessageMethod method) {
        if (method.isLoggerMethod()) {
            String logLevel = method.logLevel();
            int index = logLevel.lastIndexOf(46);
            if (index > 0) {
                return logLevel.substring(index + 1);
            }
            return logLevel;
        }
        return "";
    }

    protected Collection<MessageMethod> getSortedMessageMethods(MessageInterface messageInterface) {
        ArrayList<MessageMethod> messageMethods = new ArrayList<MessageMethod>(messageInterface.methods());
        Collections.sort(messageMethods, MessageIdComparator.INSTANCE);
        return Collections.unmodifiableCollection(messageMethods);
    }

    static String createMessageIdFormat(MessageInterface messageInterface) {
        int idLen = messageInterface.getIdLength();
        if (idLen > 0) {
            return messageInterface.projectCode() + "%0" + messageInterface.getIdLength() + "d";
        }
        return messageInterface.projectCode() + "%d";
    }

    static class MessageIdComparator
    implements Comparator<MessageMethod> {
        static final MessageIdComparator INSTANCE = new MessageIdComparator();

        MessageIdComparator() {
        }

        @Override
        public int compare(MessageMethod o1, MessageMethod o2) {
            return Integer.compare(o1.message().id(), o2.message().id());
        }
    }
}

