/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LoggingClass;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.apt.AbstractMessageObjectType;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.util.Comparison;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class ParameterFactory {
    private ParameterFactory() {
    }

    public static Set<Parameter> of(Elements elements, Types types, ExecutableElement method) {
        LinkedHashSet<Parameter> result = new LinkedHashSet<Parameter>();
        List<? extends VariableElement> params = method.getParameters();
        int index = 0;
        for (VariableElement variableElement : params) {
            String qualifiedType;
            String formatClass;
            TypeElement formatClassType = ElementHelper.getClassAnnotationValue(variableElement, FormatWith.class);
            String string = formatClass = formatClassType == null ? null : formatClassType.getQualifiedName().toString();
            if (variableElement.asType().getKind().isPrimitive()) {
                qualifiedType = variableElement.asType().toString();
            } else {
                switch (variableElement.asType().getKind()) {
                    case ARRAY: {
                        qualifiedType = variableElement.asType().toString().replace("[]", "");
                        break;
                    }
                    default: {
                        qualifiedType = types.asElement(variableElement.asType()).toString();
                    }
                }
            }
            if (method.isVarArgs()) {
                result.add(new AptParameter(elements, types, qualifiedType, variableElement, formatClass, ++index == params.size()));
                continue;
            }
            result.add(new AptParameter(elements, types, qualifiedType, variableElement, formatClass, false));
        }
        return result;
    }

    public static Parameter forMessageMethod(final MessageMethod messageMethod) {
        return new Parameter(){

            @Override
            public String formatterClass() {
                return null;
            }

            @Override
            public Class<?> paramClass() {
                return null;
            }

            @Override
            public String targetName() {
                return "";
            }

            @Override
            public Transform transform() {
                return null;
            }

            @Override
            public Pos pos() {
                return null;
            }

            @Override
            public String type() {
                return String.class.getName();
            }

            @Override
            public String name() {
                return messageMethod.messageMethodName();
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isVarArgs() {
                return false;
            }

            @Override
            public Parameter.ParameterType parameterType() {
                return Parameter.ParameterType.MESSAGE;
            }

            public int hashCode() {
                return Objects.HashCodeBuilder.builder().add(this.type()).add(this.name()).toHashCode();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof AptParameter)) {
                    return false;
                }
                AptParameter other = (AptParameter)obj;
                return Objects.areEqual(this.type(), other.type()) && Objects.areEqual(this.name(), other.name());
            }

            @Override
            public int compareTo(Parameter other) {
                return Comparison.begin().compare((Comparable<?>)((Object)this.type()), (Comparable<?>)((Object)other.type())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
            }

            public String toString() {
                return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.type()).toString();
            }

            @Override
            public MessageMethod reference() {
                return messageMethod;
            }

            @Override
            public boolean isAssignableFrom(Class<?> type) {
                return String.class.isAssignableFrom(type);
            }

            @Override
            public boolean isSubtypeOf(Class<?> type) {
                return type.isAssignableFrom(String.class);
            }

            @Override
            public boolean isSameAs(Class<?> type) {
                return this.type().equals(type.getName());
            }
        };
    }

    private static class AptParameter
    extends AbstractMessageObjectType
    implements Parameter {
        private final VariableElement param;
        private final String qualifiedType;
        private final String formatterClass;
        private final Class<?> paramClass;
        private final boolean isVarArgs;
        private final Parameter.ParameterType parameterType;
        private final Transform transform;
        private final Pos pos;

        AptParameter(Elements elements, Types types, String qualifiedType, VariableElement param, String formatterClass, boolean isVarArgs) {
            super(elements, types, param);
            this.qualifiedType = qualifiedType;
            this.param = param;
            this.formatterClass = formatterClass;
            if (ElementHelper.isAnnotatedWith(param, Param.class)) {
                this.paramClass = Object.class;
                this.parameterType = Parameter.ParameterType.CONSTRUCTION;
                this.transform = null;
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, Cause.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.CAUSE;
                this.transform = null;
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, Field.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.FIELD;
                this.transform = null;
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, Property.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.PROPERTY;
                this.transform = null;
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, LoggingClass.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.FQCN;
                this.transform = null;
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, Transform.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.TRANSFORM;
                this.transform = param.getAnnotation(Transform.class);
                this.pos = null;
            } else if (ElementHelper.isAnnotatedWith(param, Pos.class)) {
                this.paramClass = null;
                this.parameterType = Parameter.ParameterType.POS;
                this.transform = null;
                this.pos = param.getAnnotation(Pos.class);
            } else {
                this.parameterType = Parameter.ParameterType.FORMAT;
                this.paramClass = null;
                this.transform = null;
                this.pos = null;
            }
            this.isVarArgs = isVarArgs;
        }

        @Override
        public String type() {
            return this.qualifiedType;
        }

        @Override
        public String formatterClass() {
            return this.formatterClass;
        }

        @Override
        public String name() {
            return this.param.getSimpleName().toString();
        }

        @Override
        public boolean isArray() {
            return this.param.asType().getKind() == TypeKind.ARRAY;
        }

        @Override
        public boolean isPrimitive() {
            return this.param.asType().getKind().isPrimitive();
        }

        @Override
        public boolean isVarArgs() {
            return this.isVarArgs;
        }

        @Override
        public Parameter.ParameterType parameterType() {
            return this.parameterType;
        }

        @Override
        public Class<?> paramClass() {
            return this.paramClass;
        }

        @Override
        public String targetName() {
            String result = "";
            Field field = this.param.getAnnotation(Field.class);
            Property property = this.param.getAnnotation(Property.class);
            if (field != null) {
                String name = field.name();
                result = name.isEmpty() ? this.param.getSimpleName().toString() : name;
            } else if (property != null) {
                String name = property.name();
                result = name.isEmpty() ? this.param.getSimpleName().toString() : name;
                result = "set" + Character.toUpperCase(result.charAt(0)) + result.substring(1);
            }
            return result;
        }

        @Override
        public Transform transform() {
            return this.transform;
        }

        @Override
        public Pos pos() {
            return this.pos;
        }

        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.qualifiedType).add(this.param).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptParameter)) {
                return false;
            }
            AptParameter other = (AptParameter)obj;
            return Objects.areEqual(this.param, other.param) && Objects.areEqual(this.qualifiedType, other.qualifiedType);
        }

        @Override
        public int compareTo(Parameter other) {
            return Comparison.begin().compare((Comparable<?>)((Object)this.type()), (Comparable<?>)((Object)other.type())).compare((Comparable<?>)((Object)this.name()), (Comparable<?>)((Object)other.name())).result();
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("name", this.name()).add("type", this.type()).toString();
        }

        @Override
        public VariableElement reference() {
            return this.param;
        }
    }
}

