/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class MessageBundleTranslator
extends ClassModel {
    private final Map<MessageMethod, String> translations;

    public MessageBundleTranslator(Filer filer, MessageInterface messageInterface, String className, String superClassName, Map<MessageMethod, String> translations) {
        super(filer, messageInterface, className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JClassDef generateModel() throws IllegalStateException {
        JClassDef classDef = super.generateModel();
        JMethodDef constructor = classDef.constructor(16);
        constructor.body().callSuper();
        JMethodDef readResolve = this.createReadResolveMethod();
        readResolve.annotate(Override.class);
        Set<Map.Entry<MessageMethod, String>> entries = this.translations.entrySet();
        LinkedHashSet<JMethodDef> methodNames = new LinkedHashSet<JMethodDef>();
        for (Map.Entry<MessageMethod, String> entry : entries) {
            JMethodDef method = this.addMessageMethod(entry.getKey(), entry.getValue());
            if (!methodNames.add(method)) continue;
            method.annotate(Override.class);
        }
        return classDef;
    }
}

