/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.arquillian.container;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.jsfunit.api.JSFUnitResource;
import org.jboss.jsfunit.arquillian.container.JSFUnitSessionFactory;
import org.jboss.jsfunit.arquillian.container.SecurityActions;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

public class JSFUnitTestEnricher
implements TestEnricher {
    public void enrich(Object testCase) {
        List<Field> annotatedFields = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), JSFUnitResource.class);
        try {
            for (Field field : annotatedFields) {
                JSFSession value = null;
                if (field.getType() == JSFSession.class) {
                    value = JSFUnitSessionFactory.findJSFSession(field);
                } else if (field.getType() == JSFClientSession.class) {
                    value = JSFUnitSessionFactory.getJSFClientSession(field);
                } else if (field.getType() == JSFServerSession.class) {
                    value = JSFUnitSessionFactory.getJSFServerSession(field);
                }
                field.set(testCase, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject members", e);
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (values[i] != null) continue;
                Class<?> parameterType = parameterTypes[i];
                JSFSession value = null;
                if (parameterType == JSFSession.class) {
                    value = JSFUnitSessionFactory.findJSFSession(method);
                } else if (parameterType == JSFClientSession.class) {
                    value = JSFUnitSessionFactory.getJSFClientSession(method);
                } else if (parameterType == JSFServerSession.class) {
                    value = JSFUnitSessionFactory.getJSFServerSession(method);
                }
                values[i] = value;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inject method parameters", e);
        }
        return values;
    }
}

