/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.arquillian.container;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.api.BasicAuthentication;
import org.jboss.jsfunit.api.Browser;
import org.jboss.jsfunit.api.BrowserVersion;
import org.jboss.jsfunit.api.Cookies;
import org.jboss.jsfunit.api.FormAuthentication;
import org.jboss.jsfunit.api.InitialPage;
import org.jboss.jsfunit.api.InitialRequest;
import org.jboss.jsfunit.api.Proxy;
import org.jboss.jsfunit.arquillian.container.JSFUnitTestEnricher;
import org.jboss.jsfunit.framework.BasicAuthenticationStrategy;
import org.jboss.jsfunit.framework.FormAuthenticationStrategy;
import org.jboss.jsfunit.framework.InitialRequestStrategy;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.jboss.jsfunit.jsfsession.JSFClientSession;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.jboss.jsfunit.jsfsession.JSFSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUnitSessionFactory {
    private static final String JSFSESSION_FIELD_INJECTED = JSFUnitTestEnricher.class.getName() + ".JSFSESSION_FIELD_INJECTED";
    private static final String JSFSESSION_METHOD_INJECTED = JSFUnitTestEnricher.class.getName() + ".JSFSESSION_METHOD_INJECTED";

    public static JSFClientSession getJSFClientSession(AnnotatedElement injectionPoint) throws IOException {
        return JSFUnitSessionFactory.findJSFSession(injectionPoint).getJSFClientSession();
    }

    public static JSFServerSession getJSFServerSession(AnnotatedElement injectionPoint) throws IOException {
        return JSFUnitSessionFactory.findJSFSession(injectionPoint).getJSFServerSession();
    }

    public static JSFSession findJSFSession(AnnotatedElement injectionPoint) throws IOException {
        JSFUnitSessionFactory factory = new JSFUnitSessionFactory();
        ElementType injectionType = factory.getElementType(injectionPoint);
        HttpSession httpSession = WebConversationFactory.getSessionFromThreadLocal();
        JSFSession jsfSession = null;
        if (injectionType == ElementType.FIELD) {
            jsfSession = (JSFSession)httpSession.getAttribute(JSFSESSION_FIELD_INJECTED);
        }
        if (injectionType == ElementType.METHOD) {
            jsfSession = (JSFSession)httpSession.getAttribute(JSFSESSION_METHOD_INJECTED);
        }
        if (jsfSession != null) {
            return jsfSession;
        }
        jsfSession = factory.createJSFSession(injectionPoint, injectionType, httpSession);
        return jsfSession;
    }

    private JSFSession createJSFSession(AnnotatedElement injectionPoint, ElementType injectionType, HttpSession httpSession) throws IOException {
        JSFSession jsfSession = new JSFSession(this.createWebClientSpec(injectionPoint, injectionType));
        if (injectionType == ElementType.FIELD) {
            httpSession.setAttribute(JSFSESSION_FIELD_INJECTED, (Object)jsfSession);
        }
        if (injectionType == ElementType.METHOD) {
            httpSession.setAttribute(JSFSESSION_METHOD_INJECTED, (Object)jsfSession);
        }
        return jsfSession;
    }

    private WebClientSpec createWebClientSpec(AnnotatedElement injectionPoint, ElementType injectionType) {
        String password;
        String userName;
        InitialPage initialPage = this.getAnnotation(InitialPage.class, injectionPoint, injectionType);
        if (initialPage == null) {
            throw new IllegalArgumentException("@InitialPage required for injection.  Specify at class level for field injection or at method level for method injection.");
        }
        Browser browser = null;
        BrowserVersion browserAnno = this.getAnnotation(BrowserVersion.class, injectionPoint, injectionType);
        if (browserAnno == null) {
            browser = Browser.DEFAULT;
        }
        if (browserAnno != null) {
            browser = browserAnno.value();
        }
        String host = null;
        int port = 0;
        Proxy proxyAnno = this.getAnnotation(Proxy.class, injectionPoint, injectionType);
        if (proxyAnno != null) {
            host = proxyAnno.host();
            port = proxyAnno.port();
        }
        WebClientSpec wcSpec = new WebClientSpec(initialPage.value(), browser.getVersion(), host, port);
        BasicAuthentication basicAuthAnno = this.getAnnotation(BasicAuthentication.class, injectionPoint, injectionType);
        FormAuthentication formAuthAnno = this.getAnnotation(FormAuthentication.class, injectionPoint, injectionType);
        InitialRequest initReqAnno = this.getAnnotation(InitialRequest.class, injectionPoint, injectionType);
        this.validateOneNonNullInitialRequest(injectionType, basicAuthAnno, formAuthAnno, initReqAnno);
        if (basicAuthAnno != null) {
            userName = basicAuthAnno.userName();
            password = basicAuthAnno.password();
            wcSpec.setInitialRequestStrategy((InitialRequestStrategy)new BasicAuthenticationStrategy(userName, password));
        }
        if (formAuthAnno != null) {
            userName = formAuthAnno.userName();
            password = formAuthAnno.password();
            String submitComponent = formAuthAnno.submitComponent();
            String userNameComponent = formAuthAnno.userNameComponent();
            String passwordComponent = formAuthAnno.passwordComponent();
            wcSpec.setInitialRequestStrategy((InitialRequestStrategy)new FormAuthenticationStrategy(userName, password, submitComponent, userNameComponent, passwordComponent));
        }
        if (initReqAnno != null) {
            Class<? extends InitialRequestStrategy> clazz = initReqAnno.value();
            InitialRequestStrategy initReq = JSFUnitSessionFactory.newInstance(clazz);
            wcSpec.setInitialRequestStrategy(initReq);
        }
        this.setCookies(wcSpec, injectionPoint, injectionType);
        return wcSpec;
    }

    private void setCookies(WebClientSpec wcSpec, AnnotatedElement injectionPoint, ElementType injectionType) {
        String[] values;
        Cookies cookiesAnno = this.getAnnotation(Cookies.class, injectionPoint, injectionType);
        if (cookiesAnno == null) {
            return;
        }
        String[] names = cookiesAnno.names();
        if (names.length != (values = cookiesAnno.values()).length) {
            throw new IllegalArgumentException("'names' and 'values' must have equal number of elements in @Cookies annotation.");
        }
        for (int i = 0; i < names.length; ++i) {
            wcSpec.addCookie(names[i], values[i]);
        }
    }

    private void validateOneNonNullInitialRequest(ElementType injectionType, Annotation ... initRequests) {
        boolean found = false;
        for (Annotation anno : initRequests) {
            if (anno != null && found) {
                if (injectionType == ElementType.METHOD) {
                    throw new IllegalArgumentException("Only one of @BasicAuthentication, @FormAuthentication, or @InitialRequest is allowed per method.");
                }
                if (injectionType == ElementType.FIELD) {
                    throw new IllegalArgumentException("Only one of @BasicAuthentication, @FormAuthentication, or @InitialRequest is allowed at the class level.");
                }
            }
            if (anno == null) continue;
            found = true;
        }
    }

    private ElementType getElementType(AnnotatedElement injectionPoint) {
        if (injectionPoint instanceof Method) {
            return ElementType.METHOD;
        }
        if (injectionPoint instanceof Field) {
            return ElementType.FIELD;
        }
        throw new IllegalArgumentException("JSFUnit artifacts are only injectable at method parameters or field.  Found InjectionPoint Member " + injectionPoint);
    }

    private <T extends Annotation> T getAnnotation(Class<T> annoClass, AnnotatedElement injectionPoint, ElementType injectionType) {
        if (injectionType == ElementType.METHOD) {
            return injectionPoint.getAnnotation(annoClass);
        }
        if (injectionType == ElementType.FIELD) {
            Class<?> clazz = ((Field)injectionPoint).getDeclaringClass();
            return clazz.getAnnotation(annoClass);
        }
        return null;
    }

    private static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

