/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.arquillian.client;

import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.jsfunit.arquillian.container.JSFUnitCleanupTestTreadFilter;
import org.jboss.jsfunit.framework.JSFUnitFilter;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUnitProtocolArchiveProcessor
implements ProtocolArchiveProcessor {
    private static final ArchivePath WEB_XML = ArchivePaths.create((String)"WEB-INF/web.xml");
    private static final Double WEB_XML_VERSION = 2.5;

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        WebAppDescriptor descriptor;
        WebArchive webArchive;
        if (WebArchive.class.isInstance(protocolArchive) && (webArchive = (WebArchive)WebArchive.class.cast(protocolArchive)).contains(WEB_XML) && this.shouldAddJSFUnitFilters(descriptor = this.loadDescriptor(webArchive.get(WEB_XML)))) {
            this.addJSFUnitFilters(descriptor);
            webArchive.delete(WEB_XML);
            webArchive.add((Asset)new StringAsset(descriptor.exportAsString()), WEB_XML);
        }
    }

    private boolean shouldAddJSFUnitFilters(WebAppDescriptor descriptor) {
        try {
            Double definedVersion = Double.parseDouble(descriptor.getVersion());
            return definedVersion <= WEB_XML_VERSION;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not parse the web.xml version number to determine if it is less or equal to 2.5, this so we can merge in the JSFUnit support", e);
        }
    }

    private WebAppDescriptor loadDescriptor(Node node) {
        return (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).from(node.getAsset().openStream());
    }

    private WebAppDescriptor addJSFUnitFilters(WebAppDescriptor descriptor) {
        return descriptor.filter(JSFUnitCleanupTestTreadFilter.class, new String[]{"/ArquillianServletRunner"}).filter(JSFUnitFilter.class, new String[]{"/ArquillianServletRunner"});
    }
}

