/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession;

import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlIsIndex;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import org.jboss.jsfunit.jsfsession.ComponentIDNotFoundException;
import org.jboss.jsfunit.jsfsession.DuplicateClientIDException;
import org.jboss.jsfunit.jsfsession.JSFServerSession;
import org.w3c.dom.Element;

public class JSFClientSession {
    private JSFServerSession jsfServerSession;
    private WebClient webClient;

    JSFClientSession(WebClient webClient, JSFServerSession jsfServerSession) {
        this.webClient = webClient;
        this.jsfServerSession = jsfServerSession;
    }

    public Page getContentPage() {
        return this.webClient.getCurrentWindow().getEnclosedPage();
    }

    public String getPageAsText() {
        if (this.getContentPage() instanceof HtmlPage) {
            return ((HtmlPage)this.getContentPage()).asXml();
        }
        if (this.getContentPage() instanceof TextPage) {
            return ((TextPage)this.getContentPage()).getContent();
        }
        if (this.getContentPage() instanceof XmlPage) {
            return ((XmlPage)this.getContentPage()).asXml();
        }
        if (this.getContentPage() instanceof JavaScriptPage) {
            return ((JavaScriptPage)this.getContentPage()).getContent();
        }
        throw new IllegalStateException("This page can not be converted to text.  Page type is " + this.getContentPage().getClass().getName());
    }

    public Element getElement(String componentID) {
        String xpathQuery;
        DomNode domPage = (DomNode)((Object)this.getContentPage());
        List<?> elements = domPage.getByXPath(xpathQuery = this.buildXPathQuery(componentID));
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return (Element)elements.get(0);
        }
        Element exactMatch = this.findExactMatch(elements, componentID);
        if (exactMatch != null) {
            return exactMatch;
        }
        throw new DuplicateClientIDException(elements, componentID);
    }

    private Element findExactMatch(List elements, String componentID) {
        for (Element element : elements) {
            String id = element.getAttribute("id");
            if (!id.equals(componentID)) continue;
            return element;
        }
        return null;
    }

    private String buildXPathQuery(String componentID) {
        return "//*[" + this.endsWith("ID", componentID) + " or " + this.endsWith("id", componentID) + "]";
    }

    private String endsWith(String attribute, String string) {
        return "('" + string + "' = substring(@" + attribute + ",string-length(@" + attribute + ") - string-length('" + string + "') + 1))";
    }

    public void setValue(String componentID, String value) {
        Element input = this.getElement(componentID);
        if (input == null) {
            throw new ComponentIDNotFoundException(componentID);
        }
        if (input instanceof HtmlInput) {
            ((HtmlInput)input).setValueAttribute(value);
            return;
        }
        if (input instanceof HtmlTextArea) {
            ((HtmlTextArea)input).setText(value);
            return;
        }
        if (input instanceof HtmlIsIndex) {
            ((HtmlIsIndex)input).setValue(value);
            return;
        }
        throw new IllegalArgumentException("This method can not be used on components of type " + input.getClass().getName());
    }

    public void type(String componentID, char c) throws IOException {
        HtmlElement element = (HtmlElement)this.getElement(componentID);
        if (element == null) {
            throw new ComponentIDNotFoundException(componentID);
        }
        element.type(c);
    }

    public void click(String componentID) throws IOException {
        Element element = this.getElement(componentID);
        if (element == null && this.parentIsHtmlSelect(componentID)) {
            this.clickSelect(componentID);
            return;
        }
        if (element == null && this.parentIsSelectOneRadio(componentID)) {
            this.clickRadio(componentID);
            return;
        }
        if (element == null) {
            throw new ComponentIDNotFoundException(componentID);
        }
        if (element instanceof HtmlElement) {
            ((HtmlElement)element).click();
            return;
        }
        throw new IllegalArgumentException("This method can not be used on components of type " + element.getClass().getName());
    }

    private boolean parentIsSelectOneRadio(String componentID) {
        String parentClientID = this.parentElementClientID(componentID);
        UIComponent parentComponent = this.jsfServerSession.findComponent(parentClientID);
        return parentComponent instanceof HtmlSelectOneRadio;
    }

    private boolean parentIsHtmlSelect(String componentID) {
        Element parentElement = this.getElement(this.parentElementClientID(componentID));
        return parentElement instanceof HtmlSelect;
    }

    private String parentElementClientID(String componentID) {
        FacesContext facesContext = this.jsfServerSession.getFacesContext();
        UIComponent component = this.jsfServerSession.findComponent(componentID);
        return component.getParent().getClientId(facesContext);
    }

    private void clickRadio(String componentID) throws IOException {
        String itemValue = this.getSelectItemValue(componentID);
        String parentID = this.parentElementClientID(componentID);
        HtmlRadioButtonInput radioInput = this.findRadioInput(parentID, itemValue);
        radioInput.click();
    }

    private String getSelectItemValue(String componentID) {
        UIComponent uiComponent = this.jsfServerSession.findComponent(componentID);
        if (!(uiComponent instanceof UISelectItem)) {
            throw new IllegalArgumentException(componentID + " is not a UISelectItem.");
        }
        return ((UISelectItem)uiComponent).getItemValue().toString();
    }

    private void clickSelect(String componentID) throws IOException {
        String parentID = this.parentElementClientID(componentID);
        Element element = this.getElement(parentID);
        HtmlSelect htmlSelect = (HtmlSelect)element;
        String optionValue = this.getSelectItemValue(componentID);
        HtmlOption htmlOption = htmlSelect.getOptionByValue(optionValue);
        htmlOption.click();
    }

    private HtmlRadioButtonInput findRadioInput(String componentID, String optionToSelect) {
        String clientID = this.jsfServerSession.getClientIDs().findClientID(componentID);
        HtmlPage htmlPage = (HtmlPage)this.getContentPage();
        List<HtmlElement> elements = htmlPage.getElementsByName(clientID);
        for (HtmlElement htmlElement : elements) {
            if (!(htmlElement instanceof HtmlRadioButtonInput) || !htmlElement.getAttribute("value").equals(optionToSelect)) continue;
            return (HtmlRadioButtonInput)htmlElement;
        }
        return null;
    }
}

