/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client.connector.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.RequestDirectives;
import org.apache.cactus.internal.WebRequestImpl;
import org.apache.cactus.internal.client.WebResponseObjectFactory;
import org.apache.cactus.internal.client.connector.http.DefaultHttpClient;
import org.apache.cactus.internal.client.connector.http.HttpProtocolState;
import org.apache.cactus.internal.configuration.WebConfiguration;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.spi.client.ResponseObjectFactory;
import org.apache.cactus.spi.client.connector.ProtocolHandler;
import org.apache.cactus.spi.client.connector.ProtocolState;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class HttpProtocolHandler
implements ProtocolHandler {
    private WebConfiguration configuration;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public HttpProtocolHandler(WebConfiguration theConfiguration) {
        this.configuration = theConfiguration;
    }

    public Request createRequest() {
        return new WebRequestImpl(this.getConfiguration());
    }

    public ProtocolState runTest(Test test, Test test2, Request request) throws Throwable {
        Test test3 = test;
        Test test4 = test2;
        Request request2 = request;
        Object[] objectArray = new Object[]{test3, test4, request2};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, objectArray);
        return (ProtocolState)HttpProtocolHandler.runTest_aroundBody1$advice(this, test3, test4, request2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public ResponseObjectFactory createResponseObjectFactory(ProtocolState protocolState) {
        ProtocolState protocolState2 = protocolState;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, protocolState2);
        return (ResponseObjectFactory)HttpProtocolHandler.createResponseObjectFactory_aroundBody3$advice(this, protocolState2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void afterTest(ProtocolState protocolState) throws IOException {
        ProtocolState protocolState2 = protocolState;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, protocolState2);
        HttpProtocolHandler.afterTest_aroundBody5$advice(this, protocolState2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private WebConfiguration getConfiguration() {
        return this.configuration;
    }

    private HttpURLConnection runWebTest(Test theDelegatedTest, Test theWrappedTest, WebRequest theRequest) throws Throwable {
        RequestDirectives directives = new RequestDirectives(theRequest);
        directives.setClassName(theDelegatedTest.getClass().getName());
        directives.setMethodName(this.getCurrentTestName(theDelegatedTest));
        directives.setAutoSession(theRequest.getAutomaticSession() ? "true" : "false");
        if (theWrappedTest != null) {
            directives.setWrappedTestName(theWrappedTest.getClass().getName());
        }
        if (theRequest.getURL() != null) {
            theRequest.getURL().saveToRequest(theRequest);
        }
        DefaultHttpClient client = new DefaultHttpClient(this.getConfiguration());
        HttpURLConnection connection = client.doTest(theRequest);
        return connection;
    }

    private String getCurrentTestName(Test theDelegatedTest) {
        return JUnitVersionHelper.getTestCaseName(theDelegatedTest);
    }

    static {
        Factory factory = new Factory("HttpProtocolHandler.java", Class.forName("org.apache.cactus.internal.client.connector.http.HttpProtocolHandler"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-runTest-org.apache.cactus.internal.client.connector.http.HttpProtocolHandler-junit.framework.Test:junit.framework.Test:org.apache.cactus.Request:-theDelegatedTest:theWrappedTest:theRequest:-java.lang.Throwable:-org.apache.cactus.spi.client.connector.ProtocolState-"), 74);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createResponseObjectFactory-org.apache.cactus.internal.client.connector.http.HttpProtocolHandler-org.apache.cactus.spi.client.connector.ProtocolState:-theState:--org.apache.cactus.spi.client.ResponseObjectFactory-"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterTest-org.apache.cactus.internal.client.connector.http.HttpProtocolHandler-org.apache.cactus.spi.client.connector.ProtocolState:-theState:-java.io.IOException:-void-"), 101);
    }

    private static final ProtocolState runTest_aroundBody0(HttpProtocolHandler httpProtocolHandler, Test test, Test test2, Request request, JoinPoint joinPoint) {
        WebRequest webRequest = (WebRequest)request;
        HttpURLConnection httpURLConnection = httpProtocolHandler.runWebTest(test, test2, webRequest);
        HttpProtocolState httpProtocolState = new HttpProtocolState();
        httpProtocolState.setConnection(httpURLConnection);
        return httpProtocolState;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object runTest_aroundBody1$advice(HttpProtocolHandler this_, Test ajc_aroundClosure, Test thisJoinPoint, Request request, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void exitString;
        void logger;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(logAspect, joinPoint2));
            AroundClosure aroundClosure2 = aroundClosure;
            ProtocolState protocolState = HttpProtocolHandler.runTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (Request)target, (JoinPoint)logger);
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(protocolState);
            stringBuffer.append(']');
            log.debug(String.valueOf('>') + stringBuffer.toString());
            return protocolState;
        }
        void var13_13 = exitString;
        return HttpProtocolHandler.runTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (Request)target, (JoinPoint)logger);
    }

    private static final ResponseObjectFactory createResponseObjectFactory_aroundBody2(HttpProtocolHandler httpProtocolHandler, ProtocolState protocolState, JoinPoint joinPoint) {
        HttpProtocolState httpProtocolState = (HttpProtocolState)protocolState;
        return new WebResponseObjectFactory(httpProtocolState.getConnection());
    }

    /*
     * WARNING - void declaration
     */
    private static final Object createResponseObjectFactory_aroundBody3$advice(HttpProtocolHandler this_, ProtocolState ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var10_8 = logger;
            ResponseObjectFactory responseObjectFactory = HttpProtocolHandler.createResponseObjectFactory_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(responseObjectFactory);
            stringBuffer.append(']');
            log.debug(String.valueOf('>') + stringBuffer.toString());
            return responseObjectFactory;
        }
        void var11_11 = logger;
        return HttpProtocolHandler.createResponseObjectFactory_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final void afterTest_aroundBody4(HttpProtocolHandler httpProtocolHandler, ProtocolState protocolState, JoinPoint joinPoint) {
        HttpProtocolState httpProtocolState = (HttpProtocolState)protocolState;
        httpProtocolState.getConnection().getInputStream().close();
    }

    /*
     * WARNING - void declaration
     */
    private static final Object afterTest_aroundBody5$advice(HttpProtocolHandler this_, ProtocolState ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint));
            void var9_8 = logger;
            HttpProtocolHandler.afterTest_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug(String.valueOf('>') + result.getSignature().getName());
            return var8_9;
        }
        void var10_10 = logger;
        HttpProtocolHandler.afterTest_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

