/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.tomcat;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.tomcat.AbstractCatalinaContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class Tomcat4xContainer
extends AbstractCatalinaContainer {
    private File contextXml;

    public final File getContextXml() {
        return this.contextXml;
    }

    public final void setContextXml(File theContextXml) {
        this.contextXml = theContextXml;
    }

    public final void init() {
        super.init();
        if (!this.getVersion().startsWith("4")) {
            throw new BuildException("This element doesn't support version " + this.getVersion() + " of Tomcat");
        }
    }

    public final void startUp() {
        try {
            this.prepare("tomcat4x", "cactus/tomcat4x");
            this.invokeBootstrap("start");
        }
        catch (IOException ioe) {
            this.getLog().error("Failed to startup the container", ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        this.invokeBootstrap("stop");
    }

    protected void prepare(String theResourcePrefix, String theDirName) throws IOException {
        super.prepare(theResourcePrefix, theDirName);
        FileUtils fileUtils = FileUtils.newFileUtils();
        File webappsDir = new File(this.getTmpDir(), "webapps");
        if (this.getContextXml() != null) {
            fileUtils.copyFile(this.getContextXml(), new File(webappsDir, this.getContextXml().getName()));
        }
    }
}

