/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.gae.GAEUtils;
import com.gargoylesoftware.htmlunit.protocol.javascript.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import org.apache.commons.lang.StringUtils;

abstract class URLCreator {
    URLCreator() {
    }

    abstract URL toUrlUnsafeClassic(String var1) throws MalformedURLException;

    static URLCreator getCreator() {
        if (!GAEUtils.isGaeMode()) {
            return new URLCreatorStandard();
        }
        return new URLCreatorGAE();
    }

    static class URLCreatorGAE
    extends URLCreator {
        URLCreatorGAE() {
        }

        URL toUrlUnsafeClassic(String url) throws MalformedURLException {
            if (TextUtil.startsWithIgnoreCase(url, "javascript:")) {
                return new URL("http://gaeHack_" + url.replaceFirst(":", "/"));
            }
            if (TextUtil.startsWithIgnoreCase(url, "about:")) {
                if (WebClient.URL_ABOUT_BLANK != null && StringUtils.equalsIgnoreCase(WebClient.URL_ABOUT_BLANK.toExternalForm(), url)) {
                    return WebClient.URL_ABOUT_BLANK;
                }
                return new URL("http://gaeHack_" + url.replaceFirst(":", "/"));
            }
            if (TextUtil.startsWithIgnoreCase(url, "data:")) {
                return new URL("http://gaeHack_" + url.replaceFirst(":", "/"));
            }
            return new URL(url);
        }
    }

    static class URLCreatorStandard
    extends URLCreator {
        private static final URLStreamHandler JS_HANDLER = new Handler();
        private static final URLStreamHandler ABOUT_HANDLER = new com.gargoylesoftware.htmlunit.protocol.about.Handler();
        private static final URLStreamHandler DATA_HANDLER = new com.gargoylesoftware.htmlunit.protocol.data.Handler();

        URLCreatorStandard() {
        }

        URL toUrlUnsafeClassic(String url) throws MalformedURLException {
            if (TextUtil.startsWithIgnoreCase(url, "javascript:")) {
                return new URL(null, url, JS_HANDLER);
            }
            if (TextUtil.startsWithIgnoreCase(url, "about:")) {
                if (WebClient.URL_ABOUT_BLANK != null && StringUtils.equalsIgnoreCase(WebClient.URL_ABOUT_BLANK.toExternalForm(), url)) {
                    return WebClient.URL_ABOUT_BLANK;
                }
                return new URL(null, url, ABOUT_HANDLER);
            }
            if (TextUtil.startsWithIgnoreCase(url, "data:")) {
                return new URL(null, url, DATA_HANDLER);
            }
            return new URL(url);
        }
    }
}

