/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSPrimitiveValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleDeclaration
extends SimpleScriptable {
    private static final long serialVersionUID = -1976370264911039311L;
    private static final Log LOG = LogFactory.getLog(CSSStyleDeclaration.class);
    private static Map<String, String> CSSColors_ = new HashMap<String, String>();
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private HTMLElement jsElement_;
    private org.w3c.dom.css.CSSStyleDeclaration styleDeclaration_;
    private long currentElementIndex_;

    public CSSStyleDeclaration() {
    }

    public CSSStyleDeclaration(HTMLElement element) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.initialize(element);
    }

    CSSStyleDeclaration(Scriptable parentScope, org.w3c.dom.css.CSSStyleDeclaration styleDeclaration) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.styleDeclaration_ = styleDeclaration;
    }

    void initialize(HTMLElement htmlElement) {
        WebAssert.notNull("htmlElement", htmlElement);
        this.jsElement_ = htmlElement;
        this.setDomNode(htmlElement.getDomNodeOrNull(), false);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_22)) {
            for (StyleElement element : this.getStyleMap(true).values()) {
                if (!"behavior".equals(element.getName())) continue;
                try {
                    Object[] url = URL_FORMAT.parse(element.getValue());
                    if (url.length <= 0) continue;
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                    break;
                }
                catch (ParseException e) {
                    LOG.warn("Invalid behavior: '" + element.getValue() + "'.");
                }
            }
        }
    }

    protected HTMLElement getElement() {
        return this.jsElement_;
    }

    protected String getStyleAttribute(String name, boolean camelCase) {
        if (this.styleDeclaration_ != null) {
            if (camelCase) {
                name = CSSStyleDeclaration.uncamelize(name);
            }
            return this.styleDeclaration_.getPropertyValue(name);
        }
        StyleElement element = this.getStyleMap(camelCase).get(name);
        if (element != null && element.getValue() != null) {
            return element.getValue();
        }
        return "";
    }

    private String getStyleAttribute(String name1, String name2, Shorthand shorthand, boolean camelCase) {
        boolean mayBeShorthand;
        String value;
        Map<String, StyleElement> styleMap = this.getStyleMap(camelCase);
        StyleElement element1 = styleMap.get(name1);
        StyleElement element2 = styleMap.get(name2);
        if (element1 == null && element2 == null) {
            return "";
        }
        if (element1 != null && element2 == null) {
            value = element1.getValue();
            mayBeShorthand = false;
        } else if (element1 == null && element2 != null) {
            value = element2.getValue();
            mayBeShorthand = true;
        } else if (element1.getIndex() > element2.getIndex()) {
            value = element1.getValue();
            mayBeShorthand = false;
        } else {
            value = element2.getValue();
            mayBeShorthand = true;
        }
        if (!mayBeShorthand) {
            return value;
        }
        String[] values = value.split("\\s+");
        switch (shorthand) {
            case TOP: {
                return values[0];
            }
            case RIGHT: {
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
            case BOTTOM: {
                if (values.length > 2) {
                    return values[2];
                }
                return values[0];
            }
            case LEFT: {
                if (values.length > 3) {
                    return values[3];
                }
                if (values.length > 1) {
                    return values[1];
                }
                return values[0];
            }
        }
        throw new IllegalStateException("Unknown shorthand value: " + (Object)((Object)shorthand));
    }

    protected void setStyleAttribute(String name, String newValue) {
        name = CSSStyleDeclaration.uncamelize(name);
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setProperty(name, newValue, null);
        } else {
            this.replaceStyleAttribute(name, newValue);
        }
    }

    private void replaceStyleAttribute(String name, String value) {
        if (value.trim().length() == 0) {
            this.removeStyleAttribute(name);
        } else {
            Map<String, StyleElement> styleMap = this.getStyleMap(false);
            StyleElement old = styleMap.get(name);
            Long index = old != null ? Long.valueOf(old.getIndex()) : Long.valueOf(this.getCurrentElementIndex());
            StyleElement element = new StyleElement(name, value, index);
            styleMap.put(name, element);
            this.writeToElement(styleMap);
        }
    }

    private Long removeStyleAttribute(String name) {
        Map<String, StyleElement> styleMap = this.getStyleMap(false);
        if (!styleMap.containsKey(name)) {
            return null;
        }
        StyleElement removed = styleMap.remove(name);
        this.writeToElement(styleMap);
        return removed.getIndex();
    }

    protected Map<String, StyleElement> getStyleMap(boolean camelCase) {
        LinkedHashMap<String, StyleElement> styleMap = new LinkedHashMap<String, StyleElement>();
        String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        for (String token : styleAttribute.split(";")) {
            int index = token.indexOf(":");
            if (index == -1) continue;
            String key = token.substring(0, index).trim().toLowerCase();
            if (camelCase) {
                key = CSSStyleDeclaration.camelize(key);
            }
            String value = token.substring(index + 1).trim();
            StyleElement element = new StyleElement(key, value, this.getCurrentElementIndex());
            styleMap.put(key, element);
        }
        return styleMap;
    }

    private void writeToElement(Map<String, StyleElement> styleMap) {
        StringBuilder buffer = new StringBuilder();
        TreeSet<StyleElement> sortedValues = new TreeSet<StyleElement>(styleMap.values());
        for (StyleElement e : sortedValues) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(e.getName());
            buffer.append(": ");
            buffer.append(e.getValue());
            buffer.append(";");
        }
        this.jsElement_.getDomNodeOrDie().setAttribute("style", buffer.toString());
    }

    protected long getCurrentElementIndex() {
        return this.currentElementIndex_++;
    }

    protected static String camelize(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(string);
        for (int i = 0; i < buffer.length() - 1; ++i) {
            if (buffer.charAt(i) != '-') continue;
            buffer.deleteCharAt(i);
            buffer.setCharAt(i, Character.toUpperCase(buffer.charAt(i)));
        }
        return buffer.toString();
    }

    protected static String uncamelize(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("([A-Z])", "-$1").toLowerCase();
    }

    public String jsxGet_azimuth() {
        return this.getStyleAttribute("azimuth", true);
    }

    public void jsxSet_azimuth(String azimuth) {
        this.setStyleAttribute("azimuth", azimuth);
    }

    public String jsxGet_background() {
        return this.getStyleAttribute("background", true);
    }

    public void jsxSet_background(String background) {
        this.setStyleAttribute("background", background);
    }

    public String jsxGet_backgroundAttachment() {
        return this.getStyleAttribute("backgroundAttachment", true);
    }

    public void jsxSet_backgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute("backgroundAttachment", backgroundAttachment);
    }

    public String jsxGet_backgroundColor() {
        String value = this.getStyleAttribute("backgroundColor", true);
        if (value.length() == 0 && (value = CSSStyleDeclaration.findColor(this.getStyleAttribute("background", true))) == null) {
            value = "";
        }
        return value;
    }

    public void jsxSet_backgroundColor(String backgroundColor) {
        this.setStyleAttribute("backgroundColor", backgroundColor);
    }

    public String jsxGet_backgroundImage() {
        return this.getStyleAttribute("backgroundImage", true);
    }

    public void jsxSet_backgroundImage(String backgroundImage) {
        this.setStyleAttribute("backgroundImage", backgroundImage);
    }

    public String jsxGet_backgroundPosition() {
        return this.getStyleAttribute("backgroundPosition", true);
    }

    public void jsxSet_backgroundPosition(String backgroundPosition) {
        this.setStyleAttribute("backgroundPosition", backgroundPosition);
    }

    public String jsxGet_backgroundPositionX() {
        return this.getStyleAttribute("backgroundPositionX", true);
    }

    public void jsxSet_backgroundPositionX(String backgroundPositionX) {
        this.setStyleAttribute("backgroundPositionX", backgroundPositionX);
    }

    public String jsxGet_backgroundPositionY() {
        return this.getStyleAttribute("backgroundPositionY", true);
    }

    public void jsxSet_backgroundPositionY(String backgroundPositionY) {
        this.setStyleAttribute("backgroundPositionY", backgroundPositionY);
    }

    public String jsxGet_backgroundRepeat() {
        return this.getStyleAttribute("backgroundRepeat", true);
    }

    public void jsxSet_backgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute("backgroundRepeat", backgroundRepeat);
    }

    public String jsxGet_behavior() {
        return this.getStyleAttribute("behavior", true);
    }

    public void jsxSet_behavior(String behavior) {
        this.setStyleAttribute("behavior", behavior);
        this.jsElement_.jsxFunction_removeBehavior(0);
        this.jsElement_.jsxFunction_removeBehavior(1);
        this.jsElement_.jsxFunction_removeBehavior(2);
        if (behavior.length() != 0) {
            try {
                Object[] url = URL_FORMAT.parse(behavior);
                if (url.length > 0) {
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                }
            }
            catch (ParseException e) {
                LOG.warn("Invalid behavior: '" + behavior + "'.");
            }
        }
    }

    public String jsxGet_border() {
        return this.getStyleAttribute("border", true);
    }

    public void jsxSet_border(String border) {
        this.setStyleAttribute("border", border);
    }

    public String jsxGet_borderBottom() {
        return this.getStyleAttribute("borderBottom", true);
    }

    public void jsxSet_borderBottom(String borderBottom) {
        this.setStyleAttribute("borderBottom", borderBottom);
    }

    public String jsxGet_borderBottomColor() {
        String value = this.getStyleAttribute("borderBottomColor", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute("borderBottom", true));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderBottomColor(String borderBottomColor) {
        this.setStyleAttribute("borderBottomColor", borderBottomColor);
    }

    public String jsxGet_borderBottomStyle() {
        String value = this.getStyleAttribute("borderBottomStyle", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("borderBottom", true));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute("borderBottomStyle", borderBottomStyle);
    }

    public String jsxGet_borderBottomWidth() {
        return this.getBorderWidth(Shorthand.BOTTOM);
    }

    public void jsxSet_borderBottomWidth(String borderBottomWidth) {
        this.setStyleAttributePixelInt("borderBottomWidth", borderBottomWidth);
    }

    public String jsxGet_borderCollapse() {
        return this.getStyleAttribute("borderCollapse", true);
    }

    public void jsxSet_borderCollapse(String borderCollapse) {
        this.setStyleAttribute("borderCollapse", borderCollapse);
    }

    public String jsxGet_borderColor() {
        return this.getStyleAttribute("borderColor", true);
    }

    public void jsxSet_borderColor(String borderColor) {
        this.setStyleAttribute("borderColor", borderColor);
    }

    public String jsxGet_borderLeft() {
        return this.getStyleAttribute("borderLeft", true);
    }

    public void jsxSet_borderLeft(String borderLeft) {
        this.setStyleAttribute("borderLeft", borderLeft);
    }

    public String jsxGet_borderLeftColor() {
        String value = this.getStyleAttribute("borderLeftColor", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute("borderLeft", true));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftColor(String borderLeftColor) {
        this.setStyleAttribute("borderLeftColor", borderLeftColor);
    }

    public String jsxGet_borderLeftStyle() {
        String value = this.getStyleAttribute("borderLeftStyle", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("borderLeft", true));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute("borderLeftStyle", borderLeftStyle);
    }

    public String jsxGet_borderLeftWidth() {
        return this.getBorderWidth(Shorthand.LEFT);
    }

    private String getBorderWidth(Shorthand side) {
        String value = this.getStyleAttribute("border" + (Object)((Object)side) + "Width", true);
        if (value.length() == 0) {
            String[] values;
            String borderWidth;
            value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute("border" + (Object)((Object)side), true));
            if (value == null && !StringUtils.isEmpty(borderWidth = this.getStyleAttribute("borderWidth", true)) && (values = borderWidth.split("\\s")).length > side.ordinal()) {
                value = values[side.ordinal()];
            }
            if (value == null) {
                value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderLeftWidth(String borderLeftWidth) {
        this.setStyleAttributePixelInt("borderLeftWidth", borderLeftWidth);
    }

    public String jsxGet_borderRight() {
        return this.getStyleAttribute("borderRight", true);
    }

    public void jsxSet_borderRight(String borderRight) {
        this.setStyleAttribute("borderRight", borderRight);
    }

    public String jsxGet_borderRightColor() {
        String value = this.getStyleAttribute("borderRightColor", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute("borderRight", true));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderRightColor(String borderRightColor) {
        this.setStyleAttribute("borderRightColor", borderRightColor);
    }

    public String jsxGet_borderRightStyle() {
        String value = this.getStyleAttribute("borderRightStyle", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("borderRight", true));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderRightStyle(String borderRightStyle) {
        this.setStyleAttribute("borderRightStyle", borderRightStyle);
    }

    public String jsxGet_borderRightWidth() {
        return this.getBorderWidth(Shorthand.RIGHT);
    }

    public void jsxSet_borderRightWidth(String borderRightWidth) {
        this.setStyleAttributePixelInt("borderRightWidth", borderRightWidth);
    }

    public String jsxGet_borderSpacing() {
        return this.getStyleAttribute("borderSpacing", true);
    }

    public void jsxSet_borderSpacing(String borderSpacing) {
        this.setStyleAttribute("borderSpacing", borderSpacing);
    }

    public String jsxGet_borderStyle() {
        return this.getStyleAttribute("borderStyle", true);
    }

    public void jsxSet_borderStyle(String borderStyle) {
        this.setStyleAttribute("borderStyle", borderStyle);
    }

    public String jsxGet_borderTop() {
        return this.getStyleAttribute("borderTop", true);
    }

    public void jsxSet_borderTop(String borderTop) {
        this.setStyleAttribute("borderTop", borderTop);
    }

    public String jsxGet_borderTopColor() {
        String value = this.getStyleAttribute("borderTopColor", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute("borderTop", true));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderTopColor(String borderTopColor) {
        this.setStyleAttribute("borderTopColor", borderTopColor);
    }

    public String jsxGet_borderTopStyle() {
        String value = this.getStyleAttribute("borderTopStyle", true);
        if (value.length() == 0) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("borderTop", true));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute("border", true));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    public void jsxSet_borderTopStyle(String borderTopStyle) {
        this.setStyleAttribute("borderTopStyle", borderTopStyle);
    }

    public String jsxGet_borderTopWidth() {
        return this.getBorderWidth(Shorthand.TOP);
    }

    public void jsxSet_borderTopWidth(String borderTopWidth) {
        this.setStyleAttributePixelInt("borderTopWidth", borderTopWidth);
    }

    public String jsxGet_borderWidth() {
        return this.getStyleAttribute("borderWidth", true);
    }

    public void jsxSet_borderWidth(String borderWidth) {
        this.setStyleAttribute("borderWidth", borderWidth);
    }

    public String jsxGet_bottom() {
        return this.getStyleAttribute("bottom", true);
    }

    public void jsxSet_bottom(String bottom) {
        this.setStyleAttributePixelInt("bottom", bottom);
    }

    public String jsxGet_captionSide() {
        return this.getStyleAttribute("captionSide", true);
    }

    public void jsxSet_captionSide(String captionSide) {
        this.setStyleAttribute("captionSide", captionSide);
    }

    public String jsxGet_clear() {
        return this.getStyleAttribute("clear", true);
    }

    public void jsxSet_clear(String clear) {
        this.setStyleAttribute("clear", clear);
    }

    public String jsxGet_clip() {
        return this.getStyleAttribute("clip", true);
    }

    public void jsxSet_clip(String clip) {
        this.setStyleAttribute("clip", clip);
    }

    public String jsxGet_color() {
        return this.getStyleAttribute("color", true);
    }

    public void jsxSet_color(String color) {
        this.setStyleAttribute("color", color);
    }

    public String jsxGet_content() {
        return this.getStyleAttribute("content", true);
    }

    public void jsxSet_content(String content) {
        this.setStyleAttribute("content", content);
    }

    public String jsxGet_counterIncrement() {
        return this.getStyleAttribute("counterIncrement", true);
    }

    public void jsxSet_counterIncrement(String counterIncrement) {
        this.setStyleAttribute("counterIncrement", counterIncrement);
    }

    public String jsxGet_counterReset() {
        return this.getStyleAttribute("counterReset", true);
    }

    public void jsxSet_counterReset(String counterReset) {
        this.setStyleAttribute("counterReset", counterReset);
    }

    public String jsxGet_cssFloat() {
        return this.getStyleAttribute("float", true);
    }

    public void jsxSet_cssFloat(String value) {
        this.setStyleAttribute("float", value);
    }

    public String jsxGet_cssText() {
        return this.jsElement_.getDomNodeOrDie().getAttribute("style");
    }

    public void jsxSet_cssText(String value) {
        this.jsElement_.getDomNodeOrDie().setAttribute("style", value);
    }

    public String jsxGet_cue() {
        return this.getStyleAttribute("cue", true);
    }

    public void jsxSet_cue(String cue) {
        this.setStyleAttribute("cue", cue);
    }

    public String jsxGet_cueAfter() {
        return this.getStyleAttribute("cueAfter", true);
    }

    public void jsxSet_cueAfter(String cueAfter) {
        this.setStyleAttribute("cueAfter", cueAfter);
    }

    public String jsxGet_cueBefore() {
        return this.getStyleAttribute("cueBefore", true);
    }

    public void jsxSet_cueBefore(String cueBefore) {
        this.setStyleAttribute("cueBefore", cueBefore);
    }

    public String jsxGet_cursor() {
        return this.getStyleAttribute("cursor", true);
    }

    public void jsxSet_cursor(String cursor) {
        this.setStyleAttribute("cursor", cursor);
    }

    public String jsxGet_direction() {
        return this.getStyleAttribute("direction", true);
    }

    public void jsxSet_direction(String direction) {
        this.setStyleAttribute("direction", direction);
    }

    public String jsxGet_display() {
        return this.getStyleAttribute("display", true);
    }

    public void jsxSet_display(String display) {
        this.setStyleAttribute("display", display);
    }

    public String jsxGet_elevation() {
        return this.getStyleAttribute("elevation", true);
    }

    public void jsxSet_elevation(String elevation) {
        this.setStyleAttribute("elevation", elevation);
    }

    public String jsxGet_emptyCells() {
        return this.getStyleAttribute("emptyCells", true);
    }

    public void jsxSet_emptyCells(String emptyCells) {
        this.setStyleAttribute("emptyCells", emptyCells);
    }

    public String jsxGet_filter() {
        return this.getStyleAttribute("filter", true);
    }

    public void jsxSet_filter(String filter) {
        this.setStyleAttribute("filter", filter);
    }

    public String jsxGet_font() {
        return this.getStyleAttribute("font", true);
    }

    public void jsxSet_font(String font) {
        this.setStyleAttribute("font", font);
    }

    public String jsxGet_fontFamily() {
        return this.getStyleAttribute("fontFamily", true);
    }

    public void jsxSet_fontFamily(String fontFamily) {
        this.setStyleAttribute("fontFamily", fontFamily);
    }

    public String jsxGet_fontSize() {
        return this.getStyleAttribute("fontSize", true);
    }

    public void jsxSet_fontSize(String fontSize) {
        this.setStyleAttributePixelInt("fontSize", fontSize);
    }

    public String jsxGet_fontSizeAdjust() {
        return this.getStyleAttribute("fontSizeAdjust", true);
    }

    public void jsxSet_fontSizeAdjust(String fontSizeAdjust) {
        this.setStyleAttribute("fontSizeAdjust", fontSizeAdjust);
    }

    public String jsxGet_fontStretch() {
        return this.getStyleAttribute("fontStretch", true);
    }

    public void jsxSet_fontStretch(String fontStretch) {
        this.setStyleAttribute("fontStretch", fontStretch);
    }

    public String jsxGet_fontStyle() {
        return this.getStyleAttribute("fontStyle", true);
    }

    public void jsxSet_fontStyle(String fontStyle) {
        this.setStyleAttribute("fontStyle", fontStyle);
    }

    public String jsxGet_fontVariant() {
        return this.getStyleAttribute("fontVariant", true);
    }

    public void jsxSet_fontVariant(String fontVariant) {
        this.setStyleAttribute("fontVariant", fontVariant);
    }

    public String jsxGet_fontWeight() {
        return this.getStyleAttribute("fontWeight", true);
    }

    public void jsxSet_fontWeight(String fontWeight) {
        this.setStyleAttribute("fontWeight", fontWeight);
    }

    public String jsxGet_height() {
        return this.getStyleAttribute("height", true);
    }

    public void jsxSet_height(String height) {
        this.setStyleAttributePixelInt("height", height);
    }

    public String jsxGet_imeMode() {
        return this.getStyleAttribute("imeMode", true);
    }

    public void jsxSet_imeMode(String imeMode) {
        this.setStyleAttribute("imeMode", imeMode);
    }

    public String jsxGet_layoutFlow() {
        return this.getStyleAttribute("layoutFlow", true);
    }

    public void jsxSet_layoutFlow(String layoutFlow) {
        this.setStyleAttribute("layoutFlow", layoutFlow);
    }

    public String jsxGet_layoutGrid() {
        return this.getStyleAttribute("layoutGrid", true);
    }

    public void jsxSet_layoutGrid(String layoutGrid) {
        this.setStyleAttribute("layoutGrid", layoutGrid);
    }

    public String jsxGet_layoutGridChar() {
        return this.getStyleAttribute("layoutGridChar", true);
    }

    public void jsxSet_layoutGridChar(String layoutGridChar) {
        this.setStyleAttribute("layoutGridChar", layoutGridChar);
    }

    public String jsxGet_layoutGridLine() {
        return this.getStyleAttribute("layoutGridLine", true);
    }

    public void jsxSet_layoutGridLine(String layoutGridLine) {
        this.setStyleAttribute("layoutGridLine", layoutGridLine);
    }

    public String jsxGet_layoutGridMode() {
        return this.getStyleAttribute("layoutGridMode", true);
    }

    public void jsxSet_layoutGridMode(String layoutGridMode) {
        this.setStyleAttribute("layoutGridMode", layoutGridMode);
    }

    public String jsxGet_layoutGridType() {
        return this.getStyleAttribute("layoutGridType", true);
    }

    public void jsxSet_layoutGridType(String layoutGridType) {
        this.setStyleAttribute("layoutGridType", layoutGridType);
    }

    public String jsxGet_left() {
        return this.getStyleAttribute("left", true);
    }

    public void jsxSet_left(String left) {
        this.setStyleAttributePixelInt("left", left);
    }

    public int jsxGet_length() {
        return 0;
    }

    public String jsxGet_letterSpacing() {
        return this.getStyleAttribute("letterSpacing", true);
    }

    public void jsxSet_letterSpacing(String letterSpacing) {
        this.setStyleAttributePixelInt("letterSpacing", letterSpacing);
    }

    public String jsxGet_lineBreak() {
        return this.getStyleAttribute("lineBreak", true);
    }

    public void jsxSet_lineBreak(String lineBreak) {
        this.setStyleAttribute("lineBreak", lineBreak);
    }

    public String jsxGet_lineHeight() {
        return this.getStyleAttribute("lineHeight", true);
    }

    public void jsxSet_lineHeight(String lineHeight) {
        this.setStyleAttribute("lineHeight", lineHeight);
    }

    public String jsxGet_listStyle() {
        return this.getStyleAttribute("listStyle", true);
    }

    public void jsxSet_listStyle(String listStyle) {
        this.setStyleAttribute("listStyle", listStyle);
    }

    public String jsxGet_listStyleImage() {
        return this.getStyleAttribute("listStyleImage", true);
    }

    public void jsxSet_listStyleImage(String listStyleImage) {
        this.setStyleAttribute("listStyleImage", listStyleImage);
    }

    public String jsxGet_listStylePosition() {
        return this.getStyleAttribute("listStylePosition", true);
    }

    public void jsxSet_listStylePosition(String listStylePosition) {
        this.setStyleAttribute("listStylePosition", listStylePosition);
    }

    public String jsxGet_listStyleType() {
        return this.getStyleAttribute("listStyleType", true);
    }

    public void jsxSet_listStyleType(String listStyleType) {
        this.setStyleAttribute("listStyleType", listStyleType);
    }

    public String jsxGet_margin() {
        return this.getStyleAttribute("margin", true);
    }

    public void jsxSet_margin(String margin) {
        this.setStyleAttribute("margin", margin);
    }

    public String jsxGet_marginBottom() {
        return this.getStyleAttribute("marginBottom", "margin", Shorthand.BOTTOM, true);
    }

    public void jsxSet_marginBottom(String marginBottom) {
        this.setStyleAttributePixelInt("marginBottom", marginBottom);
    }

    public String jsxGet_marginLeft() {
        return this.getStyleAttribute("marginLeft", "margin", Shorthand.LEFT, true);
    }

    public void jsxSet_marginLeft(String marginLeft) {
        this.setStyleAttributePixelInt("marginLeft", marginLeft);
    }

    public String jsxGet_marginRight() {
        return this.getStyleAttribute("marginRight", "margin", Shorthand.RIGHT, true);
    }

    public void jsxSet_marginRight(String marginRight) {
        this.setStyleAttributePixelInt("marginRight", marginRight);
    }

    public String jsxGet_marginTop() {
        return this.getStyleAttribute("marginTop", "margin", Shorthand.TOP, true);
    }

    public void jsxSet_marginTop(String marginTop) {
        this.setStyleAttributePixelInt("marginTop", marginTop);
    }

    public String jsxGet_markerOffset() {
        return this.getStyleAttribute("markerOffset", true);
    }

    public void jsxSet_markerOffset(String markerOffset) {
        this.setStyleAttribute("markerOffset", markerOffset);
    }

    public String jsxGet_marks() {
        return this.getStyleAttribute("marks", true);
    }

    public void jsxSet_marks(String marks) {
        this.setStyleAttribute("marks", marks);
    }

    public String jsxGet_maxHeight() {
        return this.getStyleAttribute("maxHeight", true);
    }

    public void jsxSet_maxHeight(String maxHeight) {
        this.setStyleAttributePixelInt("maxHeight", maxHeight);
    }

    public String jsxGet_maxWidth() {
        return this.getStyleAttribute("maxWidth", true);
    }

    public void jsxSet_maxWidth(String maxWidth) {
        this.setStyleAttributePixelInt("maxWidth", maxWidth);
    }

    public String jsxGet_minHeight() {
        return this.getStyleAttribute("minHeight", true);
    }

    public void jsxSet_minHeight(String minHeight) {
        this.setStyleAttributePixelInt("minHeight", minHeight);
    }

    public String jsxGet_minWidth() {
        return this.getStyleAttribute("minWidth", true);
    }

    public void jsxSet_minWidth(String minWidth) {
        this.setStyleAttributePixelInt("minWidth", minWidth);
    }

    public String jsxGet_MozAppearance() {
        return this.getStyleAttribute("MozAppearance", true);
    }

    public void jsxSet_MozAppearance(String mozAppearance) {
        this.setStyleAttribute("MozAppearance", mozAppearance);
    }

    public String jsxGet_MozBackgroundClip() {
        return this.getStyleAttribute("MozBackgroundClip", true);
    }

    public void jsxSet_MozBackgroundClip(String mozBackgroundClip) {
        this.setStyleAttribute("MozBackgroundClip", mozBackgroundClip);
    }

    public String jsxGet_MozBackgroundInlinePolicy() {
        return this.getStyleAttribute("MozBackgroundInlinePolicy", true);
    }

    public void jsxSet_MozBackgroundInlinePolicy(String mozBackgroundInlinePolicy) {
        this.setStyleAttribute("MozBackgroundInlinePolicy", mozBackgroundInlinePolicy);
    }

    public String jsxGet_MozBackgroundOrigin() {
        return this.getStyleAttribute("MozBackgroundOrigin", true);
    }

    public void jsxSet_MozBackgroundOrigin(String mozBackgroundOrigin) {
        this.setStyleAttribute("MozBackgroundOrigin", mozBackgroundOrigin);
    }

    public String jsxGet_MozBinding() {
        return this.getStyleAttribute("MozBinding", true);
    }

    public void jsxSet_MozBinding(String mozBinding) {
        this.setStyleAttribute("MozBinding", mozBinding);
    }

    public String jsxGet_MozBorderBottomColors() {
        return this.getStyleAttribute("MozBorderBottomColors", true);
    }

    public void jsxSet_MozBorderBottomColors(String mozBorderBottomColors) {
        this.setStyleAttribute("MozBorderBottomColors", mozBorderBottomColors);
    }

    public String jsxGet_MozBorderLeftColors() {
        return this.getStyleAttribute("MozBorderLeftColors", true);
    }

    public void jsxSet_MozBorderLeftColors(String mozBorderLeftColors) {
        this.setStyleAttribute("MozBorderLeftColors", mozBorderLeftColors);
    }

    public String jsxGet_MozBorderRadius() {
        return this.getStyleAttribute("MozBorderRadius", true);
    }

    public void jsxSet_MozBorderRadius(String mozBorderRadius) {
        this.setStyleAttribute("MozBorderRadius", mozBorderRadius);
    }

    public String jsxGet_MozBorderRadiusBottomleft() {
        return this.getStyleAttribute("MozBorderRadiusBottomleft", true);
    }

    public void jsxSet_MozBorderRadiusBottomleft(String mozBorderRadiusBottomleft) {
        this.setStyleAttribute("MozBorderRadiusBottomleft", mozBorderRadiusBottomleft);
    }

    public String jsxGet_MozBorderRadiusBottomright() {
        return this.getStyleAttribute("MozBorderRadiusBottomright", true);
    }

    public void jsxSet_MozBorderRadiusBottomright(String mozBorderRadiusBottomright) {
        this.setStyleAttribute("MozBorderRadiusBottomright", mozBorderRadiusBottomright);
    }

    public String jsxGet_MozBorderRadiusTopleft() {
        return this.getStyleAttribute("MozBorderRadiusTopleft", true);
    }

    public void jsxSet_MozBorderRadiusTopleft(String mozBorderRadiusTopleft) {
        this.setStyleAttribute("MozBorderRadiusTopleft", mozBorderRadiusTopleft);
    }

    public String jsxGet_MozBorderRadiusTopright() {
        return this.getStyleAttribute("MozBorderRadiusTopright", true);
    }

    public void jsxSet_MozBorderRadiusTopright(String mozBorderRadiusTopright) {
        this.setStyleAttribute("MozBorderRadiusTopright", mozBorderRadiusTopright);
    }

    public String jsxGet_MozBorderRightColors() {
        return this.getStyleAttribute("MozBorderRightColors", true);
    }

    public void jsxSet_MozBorderRightColors(String mozBorderRightColors) {
        this.setStyleAttribute("MozBorderRightColors", mozBorderRightColors);
    }

    public String jsxGet_MozBorderTopColors() {
        return this.getStyleAttribute("MozBorderTopColors", true);
    }

    public void jsxSet_MozBorderTopColors(String mozBorderTopColors) {
        this.setStyleAttribute("MozBorderTopColors", mozBorderTopColors);
    }

    public String jsxGet_MozBoxAlign() {
        return this.getStyleAttribute("MozBoxAlign", true);
    }

    public void jsxSet_MozBoxAlign(String mozBoxAlign) {
        this.setStyleAttribute("MozBoxAlign", mozBoxAlign);
    }

    public String jsxGet_MozBoxDirection() {
        return this.getStyleAttribute("MozBoxDirection", true);
    }

    public void jsxSet_MozBoxDirection(String mozBoxDirection) {
        this.setStyleAttribute("MozBoxDirection", mozBoxDirection);
    }

    public String jsxGet_MozBoxFlex() {
        return this.getStyleAttribute("MozBoxFlex", true);
    }

    public void jsxSet_MozBoxFlex(String mozBoxFlex) {
        this.setStyleAttribute("MozBoxFlex", mozBoxFlex);
    }

    public String jsxGet_MozBoxOrdinalGroup() {
        return this.getStyleAttribute("MozBoxOrdinalGroup", true);
    }

    public void jsxSet_MozBoxOrdinalGroup(String mozBoxOrdinalGroup) {
        this.setStyleAttribute("MozBoxOrdinalGroup", mozBoxOrdinalGroup);
    }

    public String jsxGet_MozBoxOrient() {
        return this.getStyleAttribute("MozBoxOrient", true);
    }

    public void jsxSet_MozBoxOrient(String mozBoxOrient) {
        this.setStyleAttribute("MozBoxOrient", mozBoxOrient);
    }

    public String jsxGet_MozBoxPack() {
        return this.getStyleAttribute("MozBoxPack", true);
    }

    public void jsxSet_MozBoxPack(String mozBoxPack) {
        this.setStyleAttribute("MozBoxPack", mozBoxPack);
    }

    public String jsxGet_MozBoxSizing() {
        return this.getStyleAttribute("MozBoxSizing", true);
    }

    public void jsxSet_MozBoxSizing(String mozBoxSizing) {
        this.setStyleAttribute("MozBoxSizing", mozBoxSizing);
    }

    public String jsxGet_MozColumnCount() {
        return this.getStyleAttribute("MozColumnCount", true);
    }

    public void jsxSet_MozColumnCount(String mozColumnCount) {
        this.setStyleAttribute("MozColumnCount", mozColumnCount);
    }

    public String jsxGet_MozColumnGap() {
        return this.getStyleAttribute("MozColumnGap", true);
    }

    public void jsxSet_MozColumnGap(String mozColumnGap) {
        this.setStyleAttribute("MozColumnGap", mozColumnGap);
    }

    public String jsxGet_MozColumnWidth() {
        return this.getStyleAttribute("MozColumnWidth", true);
    }

    public void jsxSet_MozColumnWidth(String mozColumnWidth) {
        this.setStyleAttribute("MozColumnWidth", mozColumnWidth);
    }

    public String jsxGet_MozFloatEdge() {
        return this.getStyleAttribute("MozFloatEdge", true);
    }

    public void jsxSet_MozFloatEdge(String mozFloatEdge) {
        this.setStyleAttribute("MozFloatEdge", mozFloatEdge);
    }

    public String jsxGet_MozForceBrokenImageIcon() {
        return this.getStyleAttribute("MozForceBrokenImageIcon", true);
    }

    public void jsxSet_MozForceBrokenImageIcon(String mozForceBrokenImageIcon) {
        this.setStyleAttribute("MozForceBrokenImageIcon", mozForceBrokenImageIcon);
    }

    public String jsxGet_MozImageRegion() {
        return this.getStyleAttribute("MozImageRegion", true);
    }

    public void jsxSet_MozImageRegion(String mozImageRegion) {
        this.setStyleAttribute("MozImageRegion", mozImageRegion);
    }

    public String jsxGet_MozMarginEnd() {
        return this.getStyleAttribute("MozMarginEnd", true);
    }

    public void jsxSet_MozMarginEnd(String mozMarginEnd) {
        this.setStyleAttribute("MozMarginEnd", mozMarginEnd);
    }

    public String jsxGet_MozMarginStart() {
        return this.getStyleAttribute("MozMarginStart", true);
    }

    public void jsxSet_MozMarginStart(String mozMarginStart) {
        this.setStyleAttribute("MozMarginStart", mozMarginStart);
    }

    public String jsxGet_MozOpacity() {
        return this.getStyleAttribute("MozOpacity", true);
    }

    public void jsxSet_MozOpacity(String mozOpacity) {
        this.setStyleAttribute("MozOpacity", mozOpacity);
    }

    public String jsxGet_MozOutline() {
        return this.getStyleAttribute("MozOutline", true);
    }

    public void jsxSet_MozOutline(String mozOutline) {
        this.setStyleAttribute("MozOutline", mozOutline);
    }

    public String jsxGet_MozOutlineColor() {
        return this.getStyleAttribute("MozOutlineColor", true);
    }

    public void jsxSet_MozOutlineColor(String mozOutlineColor) {
        this.setStyleAttribute("MozOutlineColor", mozOutlineColor);
    }

    public String jsxGet_MozOutlineOffset() {
        return this.getStyleAttribute("MozOutlineOffset", true);
    }

    public void jsxSet_MozOutlineOffset(String mozOutlineOffset) {
        this.setStyleAttribute("MozOutlineOffset", mozOutlineOffset);
    }

    public String jsxGet_MozOutlineRadius() {
        return this.getStyleAttribute("MozOutlineRadius", true);
    }

    public void jsxSet_MozOutlineRadius(String mozOutlineRadius) {
        this.setStyleAttribute("MozOutlineRadius", mozOutlineRadius);
    }

    public String jsxGet_MozOutlineRadiusBottomleft() {
        return this.getStyleAttribute("MozOutlineRadiusBottomleft", true);
    }

    public void jsxSet_MozOutlineRadiusBottomleft(String mozOutlineRadiusBottomleft) {
        this.setStyleAttribute("MozOutlineRadiusBottomleft", mozOutlineRadiusBottomleft);
    }

    public String jsxGet_MozOutlineRadiusBottomright() {
        return this.getStyleAttribute("MozOutlineRadiusBottomright", true);
    }

    public void jsxSet_MozOutlineRadiusBottomright(String mozOutlineRadiusBottomright) {
        this.setStyleAttribute("MozOutlineRadiusBottomright", mozOutlineRadiusBottomright);
    }

    public String jsxGet_MozOutlineRadiusTopleft() {
        return this.getStyleAttribute("MozOutlineRadiusTopleft", true);
    }

    public void jsxSet_MozOutlineRadiusTopleft(String mozOutlineRadiusTopleft) {
        this.setStyleAttribute("MozOutlineRadiusTopleft", mozOutlineRadiusTopleft);
    }

    public String jsxGet_MozOutlineRadiusTopright() {
        return this.getStyleAttribute("MozOutlineRadiusTopright", true);
    }

    public void jsxSet_MozOutlineRadiusTopright(String mozOutlineRadiusTopright) {
        this.setStyleAttribute("MozOutlineRadiusTopright", mozOutlineRadiusTopright);
    }

    public String jsxGet_MozOutlineStyle() {
        return this.getStyleAttribute("MozOutlineStyle", true);
    }

    public void jsxSet_MozOutlineStyle(String mozOutlineStyle) {
        this.setStyleAttribute("MozOutlineStyle", mozOutlineStyle);
    }

    public String jsxGet_MozOutlineWidth() {
        return this.getStyleAttribute("MozOutlineWidth", true);
    }

    public void jsxSet_MozOutlineWidth(String mozOutlineWidth) {
        this.setStyleAttribute("MozOutlineWidth", mozOutlineWidth);
    }

    public String jsxGet_MozPaddingEnd() {
        return this.getStyleAttribute("MozPaddingEnd", true);
    }

    public void jsxSet_MozPaddingEnd(String mozPaddingEnd) {
        this.setStyleAttribute("MozPaddingEnd", mozPaddingEnd);
    }

    public String jsxGet_MozPaddingStart() {
        return this.getStyleAttribute("MozPaddingStart", true);
    }

    public void jsxSet_MozPaddingStart(String mozPaddingStart) {
        this.setStyleAttribute("MozPaddingStart", mozPaddingStart);
    }

    public String jsxGet_MozUserFocus() {
        return this.getStyleAttribute("MozUserFocus", true);
    }

    public void jsxSet_MozUserFocus(String mozUserFocus) {
        this.setStyleAttribute("MozUserFocus", mozUserFocus);
    }

    public String jsxGet_MozUserInput() {
        return this.getStyleAttribute("MozUserInput", true);
    }

    public void jsxSet_MozUserInput(String mozUserInput) {
        this.setStyleAttribute("MozUserInput", mozUserInput);
    }

    public String jsxGet_MozUserModify() {
        return this.getStyleAttribute("MozUserModify", true);
    }

    public void jsxSet_MozUserModify(String mozUserModify) {
        this.setStyleAttribute("MozUserModify", mozUserModify);
    }

    public String jsxGet_MozUserSelect() {
        return this.getStyleAttribute("MozUserSelect", true);
    }

    public void jsxSet_MozUserSelect(String mozUserSelect) {
        this.setStyleAttribute("MozUserSelect", mozUserSelect);
    }

    public String jsxGet_msInterpolationMode() {
        return this.getStyleAttribute("msInterpolationMode", true);
    }

    public void jsxSet_msInterpolationMode(String msInterpolationMode) {
        this.setStyleAttribute("msInterpolationMode", msInterpolationMode);
    }

    public String jsxGet_opacity() {
        return this.getStyleAttribute("opacity", true);
    }

    public void jsxSet_opacity(String opacity) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_23)) {
            this.setStyleAttribute("opacity", opacity);
        } else if (com.gargoylesoftware.htmlunit.util.StringUtils.isFloat(opacity, true) || opacity.length() == 0) {
            this.setStyleAttribute("opacity", opacity.trim());
        }
    }

    public String jsxGet_orphans() {
        return this.getStyleAttribute("orphans", true);
    }

    public void jsxSet_orphans(String orphans) {
        this.setStyleAttribute("orphans", orphans);
    }

    public String jsxGet_outline() {
        return this.getStyleAttribute("outline", true);
    }

    public void jsxSet_outline(String outline) {
        this.setStyleAttribute("outline", outline);
    }

    public String jsxGet_outlineColor() {
        return this.getStyleAttribute("outlineColor", true);
    }

    public void jsxSet_outlineColor(String outlineColor) {
        this.setStyleAttribute("outlineColor", outlineColor);
    }

    public String jsxGet_outlineOffset() {
        return this.getStyleAttribute("outlineOffset", true);
    }

    public void jsxSet_outlineOffset(String outlineOffset) {
        this.setStyleAttribute("outlineOffset", outlineOffset);
    }

    public String jsxGet_outlineStyle() {
        return this.getStyleAttribute("outlineStyle", true);
    }

    public void jsxSet_outlineStyle(String outlineStyle) {
        this.setStyleAttribute("outlineStyle", outlineStyle);
    }

    public String jsxGet_outlineWidth() {
        return this.getStyleAttribute("outlineWidth", true);
    }

    public void jsxSet_outlineWidth(String outlineWidth) {
        this.setStyleAttributePixelInt("outlineWidth", outlineWidth);
    }

    public String jsxGet_overflow() {
        return this.getStyleAttribute("overflow", true);
    }

    public void jsxSet_overflow(String overflow) {
        this.setStyleAttribute("overflow", overflow);
    }

    public String jsxGet_overflowX() {
        return this.getStyleAttribute("overflowX", true);
    }

    public void jsxSet_overflowX(String overflowX) {
        this.setStyleAttribute("overflowX", overflowX);
    }

    public String jsxGet_overflowY() {
        return this.getStyleAttribute("overflowY", true);
    }

    public void jsxSet_overflowY(String overflowY) {
        this.setStyleAttribute("overflowY", overflowY);
    }

    public String jsxGet_padding() {
        return this.getStyleAttribute("padding", true);
    }

    public void jsxSet_padding(String padding) {
        this.setStyleAttribute("padding", padding);
    }

    public String jsxGet_paddingBottom() {
        return this.getStyleAttribute("paddingBottom", "padding", Shorthand.BOTTOM, true);
    }

    public void jsxSet_paddingBottom(String paddingBottom) {
        this.setStyleAttributePixelInt("paddingBottom", paddingBottom);
    }

    public String jsxGet_paddingLeft() {
        return this.getStyleAttribute("paddingLeft", "padding", Shorthand.LEFT, true);
    }

    public void jsxSet_paddingLeft(String paddingLeft) {
        this.setStyleAttributePixelInt("paddingLeft", paddingLeft);
    }

    public String jsxGet_paddingRight() {
        return this.getStyleAttribute("paddingRight", "padding", Shorthand.RIGHT, true);
    }

    public void jsxSet_paddingRight(String paddingRight) {
        this.setStyleAttributePixelInt("paddingRight", paddingRight);
    }

    public String jsxGet_paddingTop() {
        return this.getStyleAttribute("paddingTop", "padding", Shorthand.TOP, true);
    }

    public void jsxSet_paddingTop(String paddingTop) {
        this.setStyleAttributePixelInt("paddingTop", paddingTop);
    }

    public String jsxGet_page() {
        return this.getStyleAttribute("page", true);
    }

    public void jsxSet_page(String page) {
        this.setStyleAttribute("page", page);
    }

    public String jsxGet_pageBreakAfter() {
        return this.getStyleAttribute("pageBreakAfter", true);
    }

    public void jsxSet_pageBreakAfter(String pageBreakAfter) {
        this.setStyleAttribute("pageBreakAfter", pageBreakAfter);
    }

    public String jsxGet_pageBreakBefore() {
        return this.getStyleAttribute("pageBreakBefore", true);
    }

    public void jsxSet_pageBreakBefore(String pageBreakBefore) {
        this.setStyleAttribute("pageBreakBefore", pageBreakBefore);
    }

    public String jsxGet_pageBreakInside() {
        return this.getStyleAttribute("pageBreakInside", true);
    }

    public void jsxSet_pageBreakInside(String pageBreakInside) {
        this.setStyleAttribute("pageBreakInside", pageBreakInside);
    }

    public String jsxGet_pause() {
        return this.getStyleAttribute("pause", true);
    }

    public void jsxSet_pause(String pause) {
        this.setStyleAttribute("pause", pause);
    }

    public String jsxGet_pauseAfter() {
        return this.getStyleAttribute("pauseAfter", true);
    }

    public void jsxSet_pauseAfter(String pauseAfter) {
        this.setStyleAttribute("pauseAfter", pauseAfter);
    }

    public String jsxGet_pauseBefore() {
        return this.getStyleAttribute("pauseBefore", true);
    }

    public void jsxSet_pauseBefore(String pauseBefore) {
        this.setStyleAttribute("pauseBefore", pauseBefore);
    }

    public String jsxGet_pitch() {
        return this.getStyleAttribute("pitch", true);
    }

    public void jsxSet_pitch(String pitch) {
        this.setStyleAttribute("pitch", pitch);
    }

    public String jsxGet_pitchRange() {
        return this.getStyleAttribute("pitchRange", true);
    }

    public void jsxSet_pitchRange(String pitchRange) {
        this.setStyleAttribute("pitchRange", pitchRange);
    }

    public int jsxGet_pixelBottom() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_bottom());
    }

    public void jsxSet_pixelBottom(int pixelBottom) {
        this.jsxSet_bottom(pixelBottom + "px");
    }

    public int jsxGet_pixelLeft() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_left());
    }

    public void jsxSet_pixelLeft(int pixelLeft) {
        this.jsxSet_left(pixelLeft + "px");
    }

    public int jsxGet_pixelRight() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_right());
    }

    public void jsxSet_pixelRight(int pixelRight) {
        this.jsxSet_right(pixelRight + "px");
    }

    public int jsxGet_pixelTop() {
        return CSSStyleDeclaration.pixelValue(this.jsxGet_top());
    }

    public void jsxSet_pixelTop(int pixelTop) {
        this.jsxSet_top(pixelTop + "px");
    }

    public int jsxGet_posBottom() {
        return 0;
    }

    public void jsxSet_posBottom(int posBottom) {
    }

    public int jsxGet_posHeight() {
        return 0;
    }

    public void jsxSet_posHeight(int posHeight) {
    }

    public String jsxGet_position() {
        return this.getStyleAttribute("position", true);
    }

    public void jsxSet_position(String position) {
        this.setStyleAttribute("position", position);
    }

    public int jsxGet_posLeft() {
        return 0;
    }

    public void jsxSet_posLeft(int posLeft) {
    }

    public int jsxGet_posRight() {
        return 0;
    }

    public void jsxSet_posRight(int posRight) {
    }

    public int jsxGet_posTop() {
        return 0;
    }

    public void jsxSet_posTop(int posTop) {
    }

    public int jsxGet_posWidth() {
        return 0;
    }

    public void jsxSet_posWidth(int posWidth) {
    }

    public String jsxGet_quotes() {
        return this.getStyleAttribute("quotes", true);
    }

    public void jsxSet_quotes(String quotes) {
        this.setStyleAttribute("quotes", quotes);
    }

    public String jsxGet_richness() {
        return this.getStyleAttribute("richness", true);
    }

    public void jsxSet_richness(String richness) {
        this.setStyleAttribute("richness", richness);
    }

    public String jsxGet_right() {
        return this.getStyleAttribute("right", true);
    }

    public void jsxSet_right(String right) {
        this.setStyleAttributePixelInt("right", right);
    }

    public String jsxGet_rubyAlign() {
        return this.getStyleAttribute("rubyAlign", true);
    }

    public void jsxSet_rubyAlign(String rubyAlign) {
        this.setStyleAttribute("rubyAlign", rubyAlign);
    }

    public String jsxGet_rubyOverhang() {
        return this.getStyleAttribute("rubyOverhang", true);
    }

    public void jsxSet_rubyOverhang(String rubyOverhang) {
        this.setStyleAttribute("rubyOverhang", rubyOverhang);
    }

    public String jsxGet_rubyPosition() {
        return this.getStyleAttribute("rubyPosition", true);
    }

    public void jsxSet_rubyPosition(String rubyPosition) {
        this.setStyleAttribute("rubyPosition", rubyPosition);
    }

    public String jsxGet_scrollbar3dLightColor() {
        return this.getStyleAttribute("scrollbar3dLightColor", true);
    }

    public void jsxSet_scrollbar3dLightColor(String scrollbar3dLightColor) {
        this.setStyleAttribute("scrollbar3dLightColor", scrollbar3dLightColor);
    }

    public String jsxGet_scrollbarArrowColor() {
        return this.getStyleAttribute("scrollbarArrowColor", true);
    }

    public void jsxSet_scrollbarArrowColor(String scrollbarArrowColor) {
        this.setStyleAttribute("scrollbarArrowColor", scrollbarArrowColor);
    }

    public String jsxGet_scrollbarBaseColor() {
        return this.getStyleAttribute("scrollbarBaseColor", true);
    }

    public void jsxSet_scrollbarBaseColor(String scrollbarBaseColor) {
        this.setStyleAttribute("scrollbarBaseColor", scrollbarBaseColor);
    }

    public String jsxGet_scrollbarDarkShadowColor() {
        return this.getStyleAttribute("scrollbarDarkShadowColor", true);
    }

    public void jsxSet_scrollbarDarkShadowColor(String scrollbarDarkShadowColor) {
        this.setStyleAttribute("scrollbarDarkShadowColor", scrollbarDarkShadowColor);
    }

    public String jsxGet_scrollbarFaceColor() {
        return this.getStyleAttribute("scrollbarFaceColor", true);
    }

    public void jsxSet_scrollbarFaceColor(String scrollbarFaceColor) {
        this.setStyleAttribute("scrollbarFaceColor", scrollbarFaceColor);
    }

    public String jsxGet_scrollbarHighlightColor() {
        return this.getStyleAttribute("scrollbarHighlightColor", true);
    }

    public void jsxSet_scrollbarHighlightColor(String scrollbarHighlightColor) {
        this.setStyleAttribute("scrollbarHighlightColor", scrollbarHighlightColor);
    }

    public String jsxGet_scrollbarShadowColor() {
        return this.getStyleAttribute("scrollbarShadowColor", true);
    }

    public void jsxSet_scrollbarShadowColor(String scrollbarShadowColor) {
        this.setStyleAttribute("scrollbarShadowColor", scrollbarShadowColor);
    }

    public String jsxGet_scrollbarTrackColor() {
        return this.getStyleAttribute("scrollbarTrackColor", true);
    }

    public void jsxSet_scrollbarTrackColor(String scrollbarTrackColor) {
        this.setStyleAttribute("scrollbarTrackColor", scrollbarTrackColor);
    }

    public String jsxGet_size() {
        return this.getStyleAttribute("size", true);
    }

    public void jsxSet_size(String size) {
        this.setStyleAttribute("size", size);
    }

    public String jsxGet_speak() {
        return this.getStyleAttribute("speak", true);
    }

    public void jsxSet_speak(String speak) {
        this.setStyleAttribute("speak", speak);
    }

    public String jsxGet_speakHeader() {
        return this.getStyleAttribute("speakHeader", true);
    }

    public void jsxSet_speakHeader(String speakHeader) {
        this.setStyleAttribute("speakHeader", speakHeader);
    }

    public String jsxGet_speakNumeral() {
        return this.getStyleAttribute("speakNumeral", true);
    }

    public void jsxSet_speakNumeral(String speakNumeral) {
        this.setStyleAttribute("speakNumeral", speakNumeral);
    }

    public String jsxGet_speakPunctuation() {
        return this.getStyleAttribute("speakPunctuation", true);
    }

    public void jsxSet_speakPunctuation(String speakPunctuation) {
        this.setStyleAttribute("speakPunctuation", speakPunctuation);
    }

    public String jsxGet_speechRate() {
        return this.getStyleAttribute("speechRate", true);
    }

    public void jsxSet_speechRate(String speechRate) {
        this.setStyleAttribute("speechRate", speechRate);
    }

    public String jsxGet_stress() {
        return this.getStyleAttribute("stress", true);
    }

    public void jsxSet_stress(String stress) {
        this.setStyleAttribute("stress", stress);
    }

    public String jsxGet_styleFloat() {
        return this.getStyleAttribute("float", true);
    }

    public void jsxSet_styleFloat(String value) {
        this.setStyleAttribute("float", value);
    }

    public String jsxGet_tableLayout() {
        return this.getStyleAttribute("tableLayout", true);
    }

    public void jsxSet_tableLayout(String tableLayout) {
        this.setStyleAttribute("tableLayout", tableLayout);
    }

    public String jsxGet_textAlign() {
        return this.getStyleAttribute("textAlign", true);
    }

    public void jsxSet_textAlign(String textAlign) {
        this.setStyleAttribute("textAlign", textAlign);
    }

    public String jsxGet_textAlignLast() {
        return this.getStyleAttribute("textAlignLast", true);
    }

    public void jsxSet_textAlignLast(String textAlignLast) {
        this.setStyleAttribute("textAlignLast", textAlignLast);
    }

    public String jsxGet_textAutospace() {
        return this.getStyleAttribute("textAutospace", true);
    }

    public void jsxSet_textAutospace(String textAutospace) {
        this.setStyleAttribute("textAutospace", textAutospace);
    }

    public String jsxGet_textDecoration() {
        return this.getStyleAttribute("textDecoration", true);
    }

    public void jsxSet_textDecoration(String textDecoration) {
        this.setStyleAttribute("textDecoration", textDecoration);
    }

    public boolean jsxGet_textDecorationBlink() {
        return false;
    }

    public void jsxSet_textDecorationBlink(boolean textDecorationBlink) {
    }

    public boolean jsxGet_textDecorationLineThrough() {
        return false;
    }

    public void jsxSet_textDecorationLineThrough(boolean textDecorationLineThrough) {
    }

    public boolean jsxGet_textDecorationNone() {
        return false;
    }

    public void jsxSet_textDecorationNone(boolean textDecorationNone) {
    }

    public boolean jsxGet_textDecorationOverline() {
        return false;
    }

    public void jsxSet_textDecorationOverline(boolean textDecorationOverline) {
    }

    public boolean jsxGet_textDecorationUnderline() {
        return false;
    }

    public void jsxSet_textDecorationUnderline(boolean textDecorationUnderline) {
    }

    public String jsxGet_textIndent() {
        return this.getStyleAttribute("textIndent", true);
    }

    public void jsxSet_textIndent(String textIndent) {
        this.setStyleAttributePixelInt("textIndent", textIndent);
    }

    public String jsxGet_textJustify() {
        return this.getStyleAttribute("textJustify", true);
    }

    public void jsxSet_textJustify(String textJustify) {
        this.setStyleAttribute("textJustify", textJustify);
    }

    public String jsxGet_textJustifyTrim() {
        return this.getStyleAttribute("textJustifyTrim", true);
    }

    public void jsxSet_textJustifyTrim(String textJustifyTrim) {
        this.setStyleAttribute("textJustifyTrim", textJustifyTrim);
    }

    public String jsxGet_textKashida() {
        return this.getStyleAttribute("textKashida", true);
    }

    public void jsxSet_textKashida(String textKashida) {
        this.setStyleAttribute("textKashida", textKashida);
    }

    public String jsxGet_textKashidaSpace() {
        return this.getStyleAttribute("textKashidaSpace", true);
    }

    public void jsxSet_textKashidaSpace(String textKashidaSpace) {
        this.setStyleAttribute("textKashidaSpace", textKashidaSpace);
    }

    public String jsxGet_textOverflow() {
        return this.getStyleAttribute("textOverflow", true);
    }

    public void jsxSet_textOverflow(String textOverflow) {
        this.setStyleAttribute("textOverflow", textOverflow);
    }

    public String jsxGet_textShadow() {
        return this.getStyleAttribute("textShadow", true);
    }

    public void jsxSet_textShadow(String textShadow) {
        this.setStyleAttribute("textShadow", textShadow);
    }

    public String jsxGet_textTransform() {
        return this.getStyleAttribute("textTransform", true);
    }

    public void jsxSet_textTransform(String textTransform) {
        this.setStyleAttribute("textTransform", textTransform);
    }

    public String jsxGet_textUnderlinePosition() {
        return this.getStyleAttribute("textUnderlinePosition", true);
    }

    public void jsxSet_textUnderlinePosition(String textUnderlinePosition) {
        this.setStyleAttribute("textUnderlinePosition", textUnderlinePosition);
    }

    public String jsxGet_top() {
        return this.getStyleAttribute("top", true);
    }

    public void jsxSet_top(String top) {
        this.setStyleAttributePixelInt("top", top);
    }

    public String jsxGet_unicodeBidi() {
        return this.getStyleAttribute("unicodeBidi", true);
    }

    public void jsxSet_unicodeBidi(String unicodeBidi) {
        this.setStyleAttribute("unicodeBidi", unicodeBidi);
    }

    public String jsxGet_verticalAlign() {
        return this.getStyleAttribute("verticalAlign", true);
    }

    public void jsxSet_verticalAlign(String verticalAlign) {
        this.setStyleAttributePixelInt("verticalAlign", verticalAlign);
    }

    public String jsxGet_visibility() {
        return this.getStyleAttribute("visibility", true);
    }

    public void jsxSet_visibility(String visibility) {
        this.setStyleAttribute("visibility", visibility);
    }

    public String jsxGet_voiceFamily() {
        return this.getStyleAttribute("voiceFamily", true);
    }

    public void jsxSet_voiceFamily(String voiceFamily) {
        this.setStyleAttribute("voiceFamily", voiceFamily);
    }

    public String jsxGet_volume() {
        return this.getStyleAttribute("volume", true);
    }

    public void jsxSet_volume(String volume) {
        this.setStyleAttribute("volume", volume);
    }

    public String jsxGet_whiteSpace() {
        return this.getStyleAttribute("whiteSpace", true);
    }

    public void jsxSet_whiteSpace(String whiteSpace) {
        this.setStyleAttribute("whiteSpace", whiteSpace);
    }

    public String jsxGet_widows() {
        return this.getStyleAttribute("widows", true);
    }

    public void jsxSet_widows(String widows) {
        this.setStyleAttribute("widows", widows);
    }

    public String jsxGet_width() {
        return this.getStyleAttribute("width", true);
    }

    public void jsxSet_width(String width) {
        this.setStyleAttributePixelInt("width", width);
    }

    public String jsxGet_wordBreak() {
        return this.getStyleAttribute("wordBreak", true);
    }

    public void jsxSet_wordBreak(String wordBreak) {
        this.setStyleAttribute("wordBreak", wordBreak);
    }

    public String jsxGet_wordSpacing() {
        return this.getStyleAttribute("wordSpacing", true);
    }

    public void jsxSet_wordSpacing(String wordSpacing) {
        this.setStyleAttributePixelInt("wordSpacing", wordSpacing);
    }

    public String jsxGet_wordWrap() {
        return this.getStyleAttribute("wordWrap", true);
    }

    public void jsxSet_wordWrap(String wordWrap) {
        this.setStyleAttribute("wordWrap", wordWrap);
    }

    public String jsxGet_writingMode() {
        return this.getStyleAttribute("writingMode", true);
    }

    public void jsxSet_writingMode(String writingMode) {
        this.setStyleAttribute("writingMode", writingMode);
    }

    public Object jsxGet_zIndex() {
        String value = this.getStyleAttribute("zIndex", true);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_24)) {
            if (value == null || value.length() == 0) {
                return 0;
            }
            return Integer.parseInt(value);
        }
        return value;
    }

    protected void setRoundedStyleAttribute(String name, Object value) {
        if (value == null || value.toString().length() == 0) {
            this.setStyleAttribute(name, "0");
        } else {
            Double d = value instanceof Double ? (Double)value : Double.valueOf(Double.parseDouble(value.toString()));
            this.setStyleAttribute(name, Integer.valueOf(Math.round(d.floatValue())).toString());
        }
    }

    protected void setIntegerStyleAttribute(String name, Object value) {
        if (value == null || value.toString().length() == 0) {
            this.setStyleAttribute(name, "0");
        } else {
            String valueString = value.toString();
            if (value instanceof Number) {
                Number number = (Number)value;
                if (number.doubleValue() % 1.0 == 0.0) {
                    this.setStyleAttribute(name, Integer.valueOf(number.intValue()).toString());
                }
            } else if (valueString.indexOf(46) == -1) {
                this.setStyleAttribute(name, valueString);
            }
        }
    }

    public void jsxSet_zIndex(Object zIndex) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_25)) {
            this.setRoundedStyleAttribute("zIndex", zIndex);
        } else {
            this.setIntegerStyleAttribute("zIndex", zIndex);
        }
    }

    public String jsxGet_zoom() {
        return this.getStyleAttribute("zoom", true);
    }

    public void jsxSet_zoom(String zoom) {
        this.setStyleAttribute("zoom", zoom);
    }

    public String jsxFunction_getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, CSSStyleDeclaration.camelize(name))) instanceof String) {
            return (String)value;
        }
        return this.getStyleAttribute(name, false);
    }

    public CSSValue jsxFunction_getPropertyCSSValue(String name) {
        org.w3c.dom.css.CSSValue cssValue;
        LOG.info("getPropertyCSSValue(" + name + "): getPropertyCSSValue support is experimental");
        if (this.styleDeclaration_ == null) {
            String uri = ((DomNode)this.getDomNodeOrDie()).getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
            String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttribute("style");
            InputSource source = new InputSource(new StringReader(styleAttribute));
            source.setURI(uri);
            ErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser(new SACParserCSS21());
            parser.setErrorHandler(errorHandler);
            try {
                this.styleDeclaration_ = parser.parseStyleDeclaration(source);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((cssValue = this.styleDeclaration_.getPropertyCSSValue(name)) == null) {
            CSSValueImpl newValue = new CSSValueImpl();
            newValue.setFloatValue((short)5, 0.0f);
            cssValue = newValue;
        }
        if (cssValue.getCssText().startsWith("rgb(")) {
            cssValue.setCssText(cssValue.getCssText().replaceAll(",", ", "));
        }
        return new CSSPrimitiveValue(this.jsElement_, (org.w3c.dom.css.CSSPrimitiveValue)cssValue);
    }

    public void jsxFunction_setExpression(String propertyName, String expression, String language) {
    }

    public boolean jsxFunction_removeExpression(String propertyName) {
        return true;
    }

    public Object jsxFunction_getAttribute(String name, int flag) {
        if (flag == 1) {
            return this.getStyleAttribute(name, true);
        }
        Map<String, StyleElement> map = this.getStyleMap(true);
        for (String key : map.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return map.get(key).getValue();
        }
        return "";
    }

    public void jsxFunction_setAttribute(String name, String value, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber(flag);
        if (flagInt == 0) {
            Map<String, StyleElement> map = this.getStyleMap(true);
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                this.setStyleAttribute(key, value);
            }
        } else if (this.getStyleAttribute(name, true).length() > 0) {
            this.setStyleAttribute(name, value);
        }
    }

    public boolean jsxFunction_removeAttribute(String name, Object flag) {
        int flagInt = flag == Undefined.instance ? 1 : (int)Context.toNumber(flag);
        if (flagInt == 0) {
            String lastName = null;
            Map<String, StyleElement> map = this.getStyleMap(true);
            for (String key : map.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                lastName = key;
            }
            if (lastName != null) {
                this.removeStyleAttribute(lastName);
                return true;
            }
            return false;
        }
        String s = this.getStyleAttribute(name, true);
        if (s.length() > 0) {
            this.removeStyleAttribute(name);
            return true;
        }
        return false;
    }

    private static String findColor(String text) {
        String[] tokens;
        Pattern p = Pattern.compile("(rgb.*?\\(.*?\\d{1,3}.*?,.*?\\d{1,3}.*?,.*?\\d{1,3}.*?\\))");
        Matcher m = p.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        for (String token : tokens = text.split(" ")) {
            if (CSSStyleDeclaration.isColorKeyword(token)) {
                return token;
            }
            if (!CSSStyleDeclaration.isColorHexadecimal(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : text.split(" ")) {
            if (!CSSStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderWidth(String text) {
        for (String token : text.split(" ")) {
            if (!CSSStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isColorHexadecimal(String token) {
        return token.toLowerCase().matches("#([0-9a-f]{3}|[0-9a-f]{6})");
    }

    private static boolean isColorKeyword(String token) {
        return CSSColors_.containsKey(token.toLowerCase());
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSSColors_.get(color.toLowerCase());
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    private static boolean isBorderStyle(String token) {
        return token.equalsIgnoreCase("none") || token.equalsIgnoreCase("hidden") || token.equalsIgnoreCase("dotted") || token.equalsIgnoreCase("dashed") || token.equalsIgnoreCase("solid") || token.equalsIgnoreCase("double") || token.equalsIgnoreCase("groove") || token.equalsIgnoreCase("ridge") || token.equalsIgnoreCase("inset") || token.equalsIgnoreCase("outset");
    }

    private static boolean isBorderWidth(String token) {
        return token.equalsIgnoreCase("thin") || token.equalsIgnoreCase("medium") || token.equalsIgnoreCase("thick ") || CSSStyleDeclaration.isLength(token);
    }

    private static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Float.parseFloat(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static int pixelValue(HTMLElement element, CssValue value) {
        String s = value.get(element);
        if (s.endsWith("%") || s.length() == 0 && element instanceof HTMLHtmlElement) {
            int i = NumberUtils.toInt(s.replaceAll("(\\d+).*", "$1"), 100);
            HTMLElement parent = element.getParentHTMLElement();
            int absoluteValue = parent == null ? value.getWindowDefaultValue() : CSSStyleDeclaration.pixelValue(parent, value);
            return (int)((double)i / 100.0 * (double)absoluteValue);
        }
        return CSSStyleDeclaration.pixelValue(s);
    }

    protected static int pixelValue(String value) {
        int i = NumberUtils.toInt(value.replaceAll("(\\d+).*", "$1"), 0);
        if (value.endsWith("px")) {
            return i;
        }
        if (value.endsWith("em")) {
            return i * 16;
        }
        if (value.endsWith("ex")) {
            return i * 10;
        }
        if (value.endsWith("in")) {
            return i * 150;
        }
        if (value.endsWith("cm")) {
            return i * 50;
        }
        if (value.endsWith("mm")) {
            return i * 5;
        }
        if (value.endsWith("pt")) {
            return i * 2;
        }
        if (value.endsWith("pc")) {
            return i * 24;
        }
        return i;
    }

    public String toString() {
        if (this.jsElement_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        String style = this.jsElement_.getDomNodeOrDie().getAttribute("style");
        return "CSSStyleDeclaration for '" + style + "'";
    }

    protected void setStyleAttributePixelInt(String name, String value) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        try {
            float floatValue = Float.parseFloat(value);
            value = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_26) ? Integer.toString((int)floatValue) + "px" : (floatValue % 1.0f == 0.0f ? Integer.toString((int)floatValue) + "px" : Float.toString(floatValue) + "px");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setStyleAttribute(name, value);
    }

    static {
        CSSColors_.put("aqua", "rgb(0, 255, 255)");
        CSSColors_.put("black", "rgb(0, 0, 0)");
        CSSColors_.put("blue", "rgb(0, 0, 255)");
        CSSColors_.put("fuchsia", "rgb(255, 0, 255)");
        CSSColors_.put("gray", "rgb(128, 128, 128)");
        CSSColors_.put("green", "rgb(0, 128, 0)");
        CSSColors_.put("lime", "rgb(0, 255, 0)");
        CSSColors_.put("maroon", "rgb(128, 0, 0)");
        CSSColors_.put("navy", "rgb(0, 0, 128)");
        CSSColors_.put("olive", "rgb(128, 128, 0)");
        CSSColors_.put("purple", "rgb(128, 0, 128)");
        CSSColors_.put("red", "rgb(255, 0, 0)");
        CSSColors_.put("silver", "rgb(192, 192, 192)");
        CSSColors_.put("teal", "rgb(0, 128, 128)");
        CSSColors_.put("white", "rgb(255, 255, 255)");
        CSSColors_.put("yellow", "rgb(255, 255, 0)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StyleElement
    implements Comparable<StyleElement> {
        private final String name_;
        private final String value_;
        private final String priority_;
        private final long index_;
        private final SelectorSpecificity specificity_;

        protected StyleElement(String name, String value, String priority, SelectorSpecificity specificity, long index) {
            this.name_ = name;
            this.value_ = value;
            this.priority_ = priority;
            this.index_ = index;
            this.specificity_ = specificity;
        }

        protected StyleElement(String name, String value, long index) {
            this(name, value, "", SelectorSpecificity.FROM_STYLE_ATTRIBUTE, index);
        }

        protected StyleElement(String name, String value) {
            this(name, value, Long.MIN_VALUE);
        }

        public String getName() {
            return this.name_;
        }

        public String getValue() {
            return this.value_;
        }

        public String getPriority() {
            return this.priority_;
        }

        public SelectorSpecificity getSpecificity() {
            return this.specificity_;
        }

        public long getIndex() {
            return this.index_;
        }

        public boolean isDefault() {
            return this.index_ == Long.MIN_VALUE;
        }

        public String toString() {
            return "[" + this.index_ + "]" + this.name_ + "=" + this.value_;
        }

        @Override
        public int compareTo(StyleElement e) {
            if (e != null) {
                return new Long(this.index_).compareTo(e.index_);
            }
            return 1;
        }
    }

    protected static abstract class CssValue {
        private final int windowDefaultValue_;

        public CssValue(int windowDefaultValue) {
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public final String get(HTMLElement element) {
            ComputedCSSStyleDeclaration style = element.jsxGet_currentStyle();
            String value = this.get(style);
            return value;
        }

        public abstract String get(ComputedCSSStyleDeclaration var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Shorthand {
        TOP("Top"),
        RIGHT("Right"),
        BOTTOM("Bottom"),
        LEFT("Left");

        private final String string_;

        private Shorthand(String stringRepresentation) {
            this.string_ = stringRepresentation;
        }

        public String toString() {
            return this.string_;
        }
    }
}

