/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class ActiveXObjectImpl
extends SimpleScriptable {
    private static final long serialVersionUID = 6954481782205807262L;
    private static final Class<?> activeXComponentClass_;
    private static final Method METHOD_getProperty_;
    private final Object object_;
    private static final Method METHOD_callN_;
    private static final Method METHOD_getvt_;
    private static final Method METHOD_getDispatch_;

    public ActiveXObjectImpl(String activeXName) throws Exception {
        this(activeXComponentClass_.getConstructor(String.class).newInstance(activeXName));
    }

    private ActiveXObjectImpl(Object object) {
        this.object_ = object;
    }

    public Object get(final String name, Scriptable start) {
        try {
            Object variant = METHOD_getProperty_.invoke(this.object_, name);
            return this.wrapIfNecessary(variant);
        }
        catch (Exception e) {
            return new Function(){

                @Override
                public Object call(Context arg0, Scriptable arg1, Scriptable arg2, Object[] arg3) {
                    try {
                        Object rv = METHOD_callN_.invoke(null, ActiveXObjectImpl.this.object_, name, arg3);
                        return ActiveXObjectImpl.this.wrapIfNecessary(rv);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx(e);
                    }
                }

                @Override
                public Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void delete(String arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void delete(int arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object get(String arg0, Scriptable arg1) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object get(int arg0, Scriptable arg1) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getClassName() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object getDefaultValue(Class<?> arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object[] getIds() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Scriptable getParentScope() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Scriptable getPrototype() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean has(String arg0, Scriptable arg1) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean has(int arg0, Scriptable arg1) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasInstance(Scriptable arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void put(String arg0, Scriptable arg1, Object arg2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void put(int arg0, Scriptable arg1, Object arg2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setParentScope(Scriptable arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setPrototype(Scriptable arg0) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private Object wrapIfNecessary(Object variant) throws Exception {
        if ((Short)METHOD_getvt_.invoke(variant, new Object[0]) == 9) {
            return new ActiveXObjectImpl(METHOD_getDispatch_.invoke(variant, new Object[0]));
        }
        return variant;
    }

    public void put(String name, Scriptable start, Object value) {
        try {
            Method setMethod = activeXComponentClass_.getMethod("setProperty", String.class, value.getClass());
            setMethod.invoke(this.object_, name, Context.toString(value));
        }
        catch (Exception e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    static {
        try {
            activeXComponentClass_ = Class.forName("com.jacob.activeX.ActiveXComponent");
            METHOD_getProperty_ = activeXComponentClass_.getMethod("getProperty", String.class);
            Class<?> dispatchClass = Class.forName("com.jacob.com.Dispatch");
            METHOD_callN_ = dispatchClass.getMethod("callN", dispatchClass, String.class, Object[].class);
            Class<?> variantClass = Class.forName("com.jacob.com.Variant");
            METHOD_getvt_ = variantClass.getMethod("getvt", new Class[0]);
            METHOD_getDispatch_ = variantClass.getMethod("getDispatch", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

