/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptableProxy;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScriptable
extends ScriptableObject
implements Cloneable {
    private static final long serialVersionUID = 3120000176890886780L;
    private static final Log LOG = LogFactory.getLog(SimpleScriptable.class);
    private DomNode domNode_;
    private boolean caseSensitive_ = true;

    @Override
    public Object get(String name, Scriptable start) {
        Object response;
        if (!this.caseSensitive_) {
            for (Object o : this.getAllIds()) {
                if (!name.equalsIgnoreCase(Context.toString(o))) continue;
                name = Context.toString(o);
                break;
            }
        }
        if ((response = super.get(name, start)) != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            return this.getWithPreemption(name);
        }
        return NOT_FOUND;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    @Override
    public String getClassName() {
        String javaClassName = this.getClass().getName();
        int index = javaClassName.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("No dot in classname: " + javaClassName);
        }
        return javaClassName.substring(index + 1);
    }

    public <N extends DomNode> N getDomNodeOrDie() throws IllegalStateException {
        if (this.domNode_ == null) {
            String clazz = this.getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return (N)this.domNode_;
    }

    public <N extends DomNode> N getDomNodeOrNull() {
        return (N)this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        WebAssert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptObject(this);
        }
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        this.setDomNode(htmlElement);
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((WebWindow)object).getScriptObject();
        }
        DomNode domNode = (DomNode)object;
        ScriptableObject scriptObject = domNode.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        Class<? extends SimpleScriptable> javaScriptClass = null;
        for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
            javaScriptClass = JavaScriptConfiguration.getHtmlJavaScriptMapping().get(c);
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("No JavaScript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement");
            }
        } else {
            try {
                scriptable = (SimpleScriptable)javaScriptClass.newInstance();
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        WebWindow enclosingWindow = domNode.getPage().getEnclosingWindow();
        if (enclosingWindow.getEnclosedPage() == domNode.getPage()) {
            scriptable.setParentScope((Scriptable)enclosingWindow.getScriptObject());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope(domNode.getPage().getScriptObject()));
        }
    }

    protected Scriptable getPrototype(Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = this.getWindow().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    protected Transformer getTransformerScriptableFor() {
        return new Transformer(){

            public Object transform(Object obj) {
                return SimpleScriptable.this.getScriptableFor(obj);
            }
        };
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JAVASCRIPT_OBJECT_ONLY)) {
                return "[object]";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JAVASCRIPT_OBJECT_PREFIX)) {
                return "[object " + this.getClassName() + "]";
            }
            Window window = (Window)SimpleScriptable.getTopLevelScope(this);
            if (ScriptableObject.getProperty((Scriptable)window, this.getClassName()) == this) {
                return "[" + this.getClassName() + "]";
            }
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    public Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow(this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope(s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        return (Scriptable)Context.getCurrentContext().getThreadLocal("startingScope");
    }

    @Override
    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = clazz.getMethods();
        Method getter = SimpleScriptable.findMethod(methods, getterName);
        Method setter = SimpleScriptable.findMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter, attributes);
    }

    @Override
    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = clazz.getMethods();
        for (String name : names) {
            Method method = SimpleScriptable.findMethod(methods, name);
            if (method == null) {
                throw Context.reportRuntimeError("Method \"" + name + "\" not found in \"" + clazz.getName() + '\"');
            }
            FunctionObject f = new FunctionObject(name, method, this);
            this.defineProperty(name, f, attributes);
        }
    }

    private static Method findMethod(Method[] methods, String name) {
        for (Method m : methods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    protected BrowserVersion getBrowserVersion() {
        Object node = this.getDomNodeOrNull();
        if (node != null) {
            return ((DomNode)node).getPage().getWebClient().getBrowserVersion();
        }
        return this.getWindow().getWebWindow().getWebClient().getBrowserVersion();
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        if (this.getPrototype() == null) {
            ScriptableObject p = (ScriptableObject)this.get("prototype", (Scriptable)this);
            return p.hasInstance(instance);
        }
        return super.hasInstance(instance);
    }

    @Override
    protected Object equivalentValues(Object value) {
        if (value instanceof SimpleScriptableProxy) {
            value = ((SimpleScriptableProxy)value).getDelegee();
        }
        return super.equivalentValues(value);
    }

    public SimpleScriptable clone() {
        try {
            return (SimpleScriptable)super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
        Scriptable prototype = this.getPrototype();
        if (prototype instanceof SimpleScriptable) {
            ((SimpleScriptable)prototype).setCaseSensitive(caseSensitive);
        }
    }
}

