/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceAnnotationMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyListValueMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceElementValueMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceJBXBValueMetaData;
import org.jboss.system.metadata.ServiceJavaBeanValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaDataParser {
    private static final Logger log = Logger.getLogger(ServiceMetaDataParser.class);
    private Element config;
    private ControllerMode serverMode;

    public ServiceMetaDataParser(Element config) {
        if (config == null) {
            throw new IllegalArgumentException("Null config");
        }
        this.config = config;
    }

    public List<ServiceMetaData> parse() throws DeploymentException {
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        try {
            String tagName = this.config.getTagName();
            if ("mbean".equals(tagName)) {
                this.internalParse(services, this.config, true);
            } else {
                if ("server".equals(tagName)) {
                    this.parseServer(this.config);
                }
                NodeList nl = this.config.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element element;
                    if (nl.item(i).getNodeType() != 1 || !"mbean".equals((element = (Element)nl.item(i)).getTagName())) continue;
                    Element mbean = (Element)nl.item(i);
                    this.internalParse(services, mbean, true);
                }
            }
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Unable to parse service configuration", t);
        }
        return services;
    }

    private void parseServer(Element serverElement) throws Exception {
        String modeString = serverElement.getAttribute("mode");
        if (modeString != null && (modeString = modeString.trim()).length() != 0) {
            this.serverMode = ControllerMode.getInstance((String)modeString);
        }
    }

    private ObjectName internalParse(List<ServiceMetaData> services, Element mbeanElement, boolean replace) throws Exception {
        ServiceMetaData service = new ServiceMetaData();
        ObjectName mbeanName = this.parseObjectName(mbeanElement, replace);
        service.setObjectName(mbeanName);
        String code = this.parseCode(mbeanName, mbeanElement);
        service.setCode(code);
        ControllerMode mode = this.parseMode(mbeanName, mbeanElement);
        if (mode == null) {
            mode = this.serverMode;
        }
        service.setMode(mode);
        ServiceConstructorMetaData constructor = this.parseConstructor(mbeanName, mbeanElement, replace);
        service.setConstructor(constructor);
        String interfaceName = this.parseInterface(mbeanName, mbeanElement);
        service.setInterfaceName(interfaceName);
        String xmbeandd = this.parseXMBeanDD(mbeanName, mbeanElement);
        service.setXMBeanDD(xmbeandd);
        String xmbeanCode = this.parseXMBeanCode(mbeanName, mbeanElement);
        service.setXMBeanCode(xmbeanCode);
        if (xmbeandd != null && xmbeandd.length() == 0) {
            Element xmbeanDescriptor = this.parseXMBeanDescriptor(mbeanName, mbeanElement);
            service.setXMBeanDescriptor(xmbeanDescriptor);
        }
        ArrayList<ServiceAnnotationMetaData> annotations = new ArrayList<ServiceAnnotationMetaData>();
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        NodeList attrs = mbeanElement.getChildNodes();
        for (int j = 0; j < attrs.getLength(); ++j) {
            ServiceAttributeMetaData attribute;
            if (attrs.item(j).getNodeType() != 1) continue;
            Element element = (Element)attrs.item(j);
            boolean replaceAttribute = true;
            if (element.getTagName().equals("attribute")) {
                String trimAttr;
                String attributeName = element.getAttribute("name");
                if (attributeName == null) {
                    throw new DeploymentException("No attribute name for " + mbeanName);
                }
                boolean trim = true;
                String replaceAttr = element.getAttribute("replace");
                if (replaceAttr.length() > 0) {
                    replaceAttribute = Boolean.valueOf(replaceAttr);
                }
                if ((trimAttr = element.getAttribute("trim")).length() > 0) {
                    trim = Boolean.valueOf(trimAttr);
                }
                String serialDataType = element.getAttribute("serialDataType");
                if (!element.hasChildNodes()) continue;
                AbstractMetaDataVisitorNode value = null;
                if (serialDataType.equals("javaBean")) {
                    value = new ServiceJavaBeanValueMetaData(element);
                } else if (serialDataType.equals("jbxb")) {
                    value = new ServiceJBXBValueMetaData(element);
                } else {
                    NodeList nl = element.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element el = (Element)n;
                        String tagName = el.getTagName();
                        if ("inject".equals(tagName)) {
                            String dependency = el.getAttribute("bean");
                            String property = null;
                            Attr attr = el.getAttributeNode("property");
                            if (attr != null) {
                                property = attr.getValue();
                            }
                            ControllerState requiredState = ControllerState.INSTALLED;
                            attr = el.getAttributeNode("state");
                            if (attr != null) {
                                requiredState = new ControllerState(attr.getValue());
                            }
                            value = new ServiceInjectionValueMetaData(dependency, property, requiredState);
                            break;
                        }
                        value = new ServiceElementValueMetaData((Element)n);
                        break;
                    }
                    if (value == null) {
                        value = new ServiceTextValueMetaData(ServiceMetaDataParser.getElementTextContent(element, trim, replaceAttribute));
                    }
                }
                ServiceAttributeMetaData attribute2 = new ServiceAttributeMetaData();
                attribute2.setName(attributeName);
                attribute2.setReplace(replaceAttribute);
                attribute2.setTrim(trim);
                attribute2.setValue((ServiceValueMetaData)((Object)value));
                attributes.add(attribute2);
                continue;
            }
            if (element.getTagName().equals("depends")) {
                String mbeanRefName = element.getAttribute("optional-attribute-name");
                mbeanRefName = "".equals(mbeanRefName) ? null : StringPropertyReplacer.replaceProperties((String)mbeanRefName);
                String proxyType = element.getAttribute("proxy-type");
                proxyType = "".equals(proxyType) ? null : StringPropertyReplacer.replaceProperties((String)proxyType);
                String dependsObjectName = this.processDependency(mbeanName, mbeanRefName, element, services, replace);
                if (mbeanRefName != null) {
                    ServiceDependencyValueMetaData value = new ServiceDependencyValueMetaData(dependsObjectName, proxyType);
                    attribute = new ServiceAttributeMetaData();
                    attribute.setName(mbeanRefName);
                    attribute.setValue(value);
                    attributes.add(attribute);
                    continue;
                }
                ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
                dependency.setIDependOn(dependsObjectName);
                dependencies.add(dependency);
                continue;
            }
            if (element.getTagName().equals("depends-list")) {
                String dependsListName = element.getAttribute("optional-attribute-name");
                if ("".equals(dependsListName)) {
                    dependsListName = null;
                }
                NodeList dependsList = element.getChildNodes();
                ArrayList<String> dependsListNames = new ArrayList<String>();
                for (int l = 0; l < dependsList.getLength(); ++l) {
                    Element dependsElement;
                    if (dependsList.item(l).getNodeType() != 1 || !(dependsElement = (Element)dependsList.item(l)).getTagName().equals("depends-list-element")) continue;
                    String dependsObjectName = this.processDependency(mbeanName, dependsListName, dependsElement, services, replace);
                    if (!dependsListNames.contains(dependsObjectName)) {
                        dependsListNames.add(dependsObjectName);
                    }
                    if (dependsListName != null) continue;
                    ServiceDependencyMetaData dependency = new ServiceDependencyMetaData();
                    dependency.setIDependOn(dependsObjectName);
                    dependencies.add(dependency);
                }
                if (dependsListName == null) continue;
                ServiceDependencyListValueMetaData value = new ServiceDependencyListValueMetaData(dependsListNames);
                attribute = new ServiceAttributeMetaData();
                attribute.setName(dependsListName);
                attribute.setValue(value);
                attributes.add(attribute);
                continue;
            }
            if (element.getTagName().equals("alias")) {
                List<String> aliases = service.getAliases();
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                    service.setAliases(aliases);
                }
                aliases.add(ServiceMetaDataParser.getElementTextContent(element, true, true));
                continue;
            }
            if (!element.getTagName().equals("annotation")) continue;
            String ann = ServiceMetaDataParser.getElementTextContent(element, true, true);
            ServiceAnnotationMetaData amd = new ServiceAnnotationMetaData(ann);
            annotations.add(amd);
        }
        service.setAttributes(attributes);
        service.setDependencies(dependencies);
        service.setAnnotations(annotations);
        services.add(service);
        return mbeanName;
    }

    private ObjectName parseObjectName(Element mbeanElement, boolean replace) throws Exception {
        String name = mbeanElement.getAttribute("name");
        if (name == null || name.trim().length() == 0) {
            throw new DeploymentException("Missing or empty 'name' attribute for mbean.");
        }
        if (replace) {
            name = StringPropertyReplacer.replaceProperties((String)name);
        }
        return new ObjectName(name);
    }

    private String parseCode(ObjectName name, Element mbeanElement) throws Exception {
        return mbeanElement.getAttribute("code");
    }

    private ControllerMode parseMode(ObjectName name, Element mbeanElement) throws Exception {
        String modeString = mbeanElement.getAttribute("mode");
        if (modeString == null) {
            return null;
        }
        if ((modeString = modeString.trim()).length() == 0) {
            return null;
        }
        return ControllerMode.getInstance((String)modeString);
    }

    private ServiceConstructorMetaData parseConstructor(ObjectName name, Element mbeanElement, boolean replace) throws Exception {
        ServiceConstructorMetaData result = new ServiceConstructorMetaData();
        NodeList list = mbeanElement.getElementsByTagName("constructor");
        if (list.getLength() > 1 && list.item(0).getParentNode() == mbeanElement) {
            throw new DeploymentException("only one <constructor> element may be defined for " + name);
        }
        if (list.getLength() == 1) {
            Element element = (Element)list.item(0);
            list = element.getElementsByTagName("arg");
            int length = list.getLength();
            String[] params = new String[length];
            String[] signature = new String[length];
            for (int j = 0; j < length; ++j) {
                Element arg = (Element)list.item(j);
                String typeName = null;
                Attr attr = arg.getAttributeNode("type");
                if (attr != null) {
                    typeName = attr.getValue();
                }
                String value = null;
                attr = arg.getAttributeNode("value");
                if (attr != null) {
                    value = attr.getValue();
                }
                signature[j] = typeName;
                params[j] = value;
            }
            result.setParams(params);
            result.setSignature(signature);
        }
        return result;
    }

    private String parseInterface(ObjectName name, Element mbeanElement) throws Exception {
        Attr attr = mbeanElement.getAttributeNode("interface");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private String parseXMBeanDD(ObjectName name, Element mbeanElement) throws Exception {
        Attr attr = mbeanElement.getAttributeNode("xmbean-dd");
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private String parseXMBeanCode(ObjectName name, Element mbeanElement) throws Exception {
        Attr attr = mbeanElement.getAttributeNode("xmbean-code");
        if (attr != null) {
            return attr.getValue();
        }
        return "org.jboss.mx.modelmbean.XMBean";
    }

    private Element parseXMBeanDescriptor(ObjectName name, Element mbeanElement) throws Exception {
        NodeList mbeans = mbeanElement.getElementsByTagName("xmbean");
        if (mbeans.getLength() == 0) {
            throw new DeploymentException("No nested mbean element given for xmbean for " + name);
        }
        return (Element)mbeans.item(0);
    }

    private String processDependency(ObjectName mbeanName, String attributeName, Element element, List<ServiceMetaData> services, boolean replace) throws Exception {
        String dependsObjectName = null;
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element child = (Element)childNode;
            String tagName = child.getTagName();
            if ("mbean".equals(tagName)) {
                dependsObjectName = this.internalParse(services, child, replace).getCanonicalName();
                break;
            }
            if (attributeName != null) {
                log.warn((Object)("Non mbean child <" + tagName + "/> in depends tag for " + mbeanName + " attribute: " + attributeName));
                continue;
            }
            log.warn((Object)("Non mbean child <" + tagName + "/> in depends tag for " + mbeanName));
        }
        if (dependsObjectName == null) {
            dependsObjectName = ServiceMetaDataParser.getElementTextContent(element, true, replace);
        }
        return dependsObjectName;
    }

    public static String getElementTextContent(Element element, boolean trim, boolean replace) throws Exception {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText = attributeText + ((Text)n).getData();
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        if (replace) {
            attributeText = StringPropertyReplacer.replaceProperties((String)attributeText);
        }
        return attributeText;
    }
}

