/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerFactory;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.Strings;
import org.jboss.util.stream.Streams;
import org.jboss.util.xml.JBossEntityResolver;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SARDeployer
extends SubDeployerSupport
implements SARDeployerMBean {
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"050:.deployer", "050:-deployer.xml", "150:.sar", "150:-service.xml"};
    private static final String JBOSS_SERVICE = "META-INF/jboss-service.xml";
    private ServiceControllerMBean serviceController;
    private File dataDir;
    private URL serverHomeURL;
    private HashMap serviceDeploymentMap = new HashMap();
    private Map suffixToDescriptorMap = new ConcurrentReaderHashMap();
    private boolean useNamespaceAwareParser;

    public SARDeployer() {
        this.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(JBOSS_SERVICE);
        tmp.add("META-INF/hibernate-service.xml");
        this.suffixToDescriptorMap.put(".har", tmp);
    }

    public boolean isUseNamespaceAwareParser() {
        return this.useNamespaceAwareParser;
    }

    public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser) {
        this.useNamespaceAwareParser = useNamespaceAwareParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentInfo getService(ObjectName serviceName) {
        DeploymentInfo di = null;
        HashMap hashMap = this.serviceDeploymentMap;
        synchronized (hashMap) {
            di = (DeploymentInfo)this.serviceDeploymentMap.get(serviceName);
        }
        return di;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        try {
            di.watch = di.url.getPath().endsWith("/") ? new URL(di.url, JBOSS_SERVICE) : di.url;
            this.parseDocument(di);
            NodeList loaders = di.document.getElementsByTagName("loader-repository");
            if (loaders.getLength() > 0) {
                Element loader = (Element)loaders.item(0);
                LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig((Element)loader);
                di.setRepositoryInfo(config);
            }
            this.parseXMLClasspath(di);
            NodeList lds = di.document.getElementsByTagName("local-directory");
            this.log.debug((Object)("about to copy " + lds.getLength() + " local directories"));
            for (int i = 0; i < lds.getLength(); ++i) {
                Element ld = (Element)lds.item(i);
                String path = ld.getAttribute("path");
                this.log.debug((Object)("about to copy local directory at " + path));
                this.log.debug((Object)("copying from " + di.localUrl + path + " -> " + this.dataDir));
                this.inflateJar(di.localUrl, this.dataDir, path);
            }
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        super.init(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("Deploying SAR, create step: url " + di.url));
            ObjectName uclName = di.ucl.getObjectName();
            if (!this.getServer().isRegistered(uclName)) {
                this.log.debug((Object)("Registering service UCL=" + uclName));
                this.getServer().registerMBean(di.ucl, uclName);
            }
            List<ObjectName> mbeans = di.mbeans;
            mbeans.clear();
            List<ObjectName> descriptorMbeans = this.serviceController.install(di.document.getDocumentElement(), uclName);
            mbeans.addAll(descriptorMbeans);
            for (ObjectName service : di.mbeans) {
                this.serviceController.create(service);
                HashMap hashMap = this.serviceDeploymentMap;
                synchronized (hashMap) {
                    this.serviceDeploymentMap.put(service, di);
                }
            }
            super.create(di);
        }
        catch (DeploymentException e) {
            this.log.debug((Object)("create operation failed for package " + di.url), (Throwable)((Object)e));
            this.destroy(di);
            throw e;
        }
        catch (Exception e) {
            this.log.debug((Object)("create operation failed for package " + di.url), (Throwable)e);
            this.destroy(di);
            throw new DeploymentException("create operation failed for package " + di.url, e);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("Deploying SAR, start step: url " + di.url));
        try {
            for (ObjectName service : di.mbeans) {
                this.serviceController.start(service);
            }
            super.start(di);
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("start operation failed on package " + di.url, e);
        }
    }

    public void stop(DeploymentInfo di) {
        this.log.debug((Object)("undeploying document " + di.url));
        List<ObjectName> services = di.mbeans;
        int lastService = services.size();
        ListIterator<ObjectName> i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            ObjectName name = i.previous();
            this.log.debug((Object)("stopping mbean " + name));
            try {
                this.serviceController.stop(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not stop mbean: " + name), (Throwable)e);
            }
        }
        try {
            super.stop(di);
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(DeploymentInfo di) {
        ObjectName name;
        List<ObjectName> services = di.mbeans;
        int lastService = services.size();
        ListIterator<ObjectName> i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            name = i.previous();
            this.log.debug((Object)("destroying mbean " + name));
            HashMap hashMap = this.serviceDeploymentMap;
            synchronized (hashMap) {
                this.serviceDeploymentMap.remove(name);
            }
            try {
                this.serviceController.destroy(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not destroy mbean: " + name), (Throwable)e);
            }
        }
        i = services.listIterator(lastService);
        while (i.hasPrevious()) {
            name = i.previous();
            this.log.debug((Object)("removing mbean " + name));
            try {
                this.serviceController.remove(name);
            }
            catch (Exception e) {
                this.log.error((Object)("Could not remove mbean: " + name), (Throwable)e);
            }
        }
        try {
            ObjectName uclName = di.ucl.getObjectName();
            if (this.getServer().isRegistered(uclName)) {
                this.log.debug((Object)("Unregistering service UCL=" + uclName));
                this.getServer().unregisterMBean(uclName);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            super.destroy(di);
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    protected void startService() throws Exception {
        super.startService();
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        ServerConfig config = ServerConfigLocator.locate();
        this.dataDir = config.getServerDataDir();
        this.serverHomeURL = config.getServerHomeURL();
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.serviceController = null;
        this.serverHomeURL = null;
        this.dataDir = null;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected File[] listFiles(String urlspec) throws Exception {
        URL url = Strings.toURL((String)urlspec);
        File dir = new File(url.getFile());
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        return files;
    }

    protected void parseXMLClasspath(DeploymentInfo di) throws Exception {
        ArrayList<URL> classpath = new ArrayList<URL>();
        URLListerFactory listerFactory = new URLListerFactory();
        NodeList children = di.document.getDocumentElement().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            URL codebaseUrl;
            Element classpathElement;
            if (children.item(i).getNodeType() != 1 || !(classpathElement = (Element)children.item(i)).getTagName().equals("classpath")) continue;
            this.log.debug((Object)("Found classpath element: " + classpathElement));
            if (!classpathElement.hasAttribute("codebase")) {
                throw new DeploymentException("Invalid classpath element missing codebase: " + classpathElement);
            }
            String codebase = classpathElement.getAttribute("codebase").trim();
            codebase = StringPropertyReplacer.replaceProperties((String)codebase);
            String archives = null;
            if (classpathElement.hasAttribute("archives")) {
                archives = classpathElement.getAttribute("archives").trim();
                if ("".equals(archives = StringPropertyReplacer.replaceProperties((String)archives))) {
                    archives = null;
                }
            }
            if (".".equals(codebase)) {
                codebaseUrl = new URL(di.url, "./");
            } else {
                if (archives != null && !codebase.endsWith("/")) {
                    codebase = codebase + "/";
                }
                codebaseUrl = new URL(this.serverHomeURL, codebase);
            }
            this.log.debug((Object)("codebase URL is " + codebaseUrl));
            if (archives == null) {
                classpath.add(codebaseUrl);
                this.log.debug((Object)"added codebase to classpath");
                continue;
            }
            this.log.debug((Object)("listing codebase for archives matching " + archives));
            URLLister lister = listerFactory.createURLLister(codebaseUrl);
            this.log.debug((Object)("URLLister class is " + lister.getClass().getName()));
            classpath.addAll(lister.listMembers(codebaseUrl, archives));
        }
        for (URL neededURL : classpath) {
            di.addLibraryJar(neededURL);
            this.log.debug((Object)("deployed classes for " + neededURL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDocument(DeploymentInfo di) throws Exception {
        InputStream stream = null;
        try {
            if (di.document == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(this.useNamespaceAwareParser);
                DocumentBuilder parser = factory.newDocumentBuilder();
                URL docURL = di.localUrl;
                URLClassLoader localCL = di.localCl;
                if (!di.isXML) {
                    String[] descriptors = this.getDescriptorName(di);
                    for (int n = 0; n < descriptors.length; ++n) {
                        String descriptor = descriptors[n];
                        docURL = localCL.findResource(descriptor);
                        if (docURL == null) continue;
                        if (!di.url.getPath().endsWith("/")) break;
                        di.watch = new URL(di.url, descriptor);
                        this.log.debug((Object)("Updated watch URL to: " + di.watch));
                        break;
                    }
                    if (docURL == null) {
                        docURL = localCL.findResource(JBOSS_SERVICE);
                    }
                }
                if (docURL == null) {
                    throw new DeploymentException("Failed to find META-INF/jboss-service.xml for archive " + di.shortName);
                }
                stream = docURL.openStream();
                InputSource is = new InputSource(stream);
                is.setSystemId(docURL.toString());
                parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
                di.document = parser.parse(is);
            } else {
                this.log.debug((Object)"Using existing deployment.document");
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inflateJar(URL url, File destDir, String path) throws DeploymentException, IOException {
        String filename = url.getFile();
        JarFile jarFile = new JarFile(filename);
        try {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                File outFile;
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (path != null && !name.startsWith(path) || (outFile = new File(destDir, name)).exists()) continue;
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                Streams.copyb((InputStream)jarFile.getInputStream(entry), (OutputStream)new FileOutputStream(outFile));
            }
        }
        finally {
            jarFile.close();
        }
    }

    private String[] getDescriptorName(DeploymentInfo sdi) {
        String suffix;
        List descriptors;
        String[] descriptorNames = new String[]{JBOSS_SERVICE};
        String shortName = sdi.shortName;
        int dot = shortName.lastIndexOf(46);
        if (dot >= 0 && (descriptors = (List)this.suffixToDescriptorMap.get(suffix = shortName.substring(dot))) != null) {
            descriptorNames = new String[descriptors.size()];
            descriptors.toArray(descriptorNames);
        }
        return descriptorNames;
    }
}

