/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jboss.mx.mxbean.ItemMetaData;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.util.UnexpectedThrowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTypeMetaData {
    private Class<?> clazz;
    private CompositeType compositeType;
    private List<ItemMetaData> items = new ArrayList<ItemMetaData>();

    public CompositeTypeMetaData(Class<?> clazz) {
        this.clazz = clazz;
    }

    public CompositeType getCompositeType() {
        if (this.compositeType == null) {
            String typeName = this.clazz.getName();
            if (this.items.size() == 0) {
                return CompositeTypeMetaData.generateAnObject(typeName);
            }
            String[] itemNames = new String[this.items.size()];
            OpenType[] itemTypes = new OpenType[this.items.size()];
            for (int i = 0; i < this.items.size(); ++i) {
                ItemMetaData item = this.items.get(i);
                itemNames[i] = item.getName();
                itemTypes[i] = item.getOpenType();
            }
            try {
                this.compositeType = new CompositeType(typeName, typeName, itemNames, itemNames, itemTypes);
            }
            catch (Throwable t) {
                throw new UnexpectedThrowable("Error creating composite type for: " + typeName, t);
            }
        }
        return this.compositeType;
    }

    public void generate() {
        Method[] methods;
        if (Object.class.equals(this.clazz)) {
            this.compositeType = CompositeTypeMetaData.generateObject();
            return;
        }
        if (Class.class.equals(this.clazz)) {
            this.compositeType = CompositeTypeMetaData.generateClass();
            return;
        }
        if (ClassLoader.class.equals(this.clazz)) {
            this.compositeType = CompositeTypeMetaData.generateClassLoader();
            return;
        }
        for (Method method : methods = this.clazz.getMethods()) {
            String key;
            Type returnType = method.getGenericReturnType();
            Class<?> declaring = method.getDeclaringClass();
            if (Object.class.equals(declaring) || (key = MXBeanUtils.getCompositeDataKey(method)) == null) continue;
            this.items.add(new ItemMetaData(key, returnType));
        }
    }

    public static CompositeType generateObject() {
        return CompositeTypeMetaData.generateAnObject(Object.class.getName());
    }

    private static CompositeType generateAnObject(String name) {
        String[] itemNames = new String[]{"class"};
        OpenType[] openTypes = new OpenType[]{CompositeTypeMetaData.generateClass()};
        return CompositeTypeMetaData.safeCreateCompositeType(name, itemNames, openTypes);
    }

    public static CompositeType generateClass() {
        String name = Object.class.getName();
        String[] itemNames = new String[]{"name"};
        OpenType[] openTypes = new OpenType[]{SimpleType.STRING};
        return CompositeTypeMetaData.safeCreateCompositeType(name, itemNames, openTypes);
    }

    public static CompositeType generateClassLoader() {
        String name = Object.class.getName();
        String[] itemNames = new String[]{"name"};
        OpenType[] openTypes = new OpenType[]{SimpleType.STRING};
        return CompositeTypeMetaData.safeCreateCompositeType(name, itemNames, openTypes);
    }

    private static CompositeType safeCreateCompositeType(String name, String[] itemNames, OpenType[] openTypes) {
        try {
            return new CompositeType(name, name, itemNames, itemNames, openTypes);
        }
        catch (Exception e) {
            throw new UnexpectedThrowable((Throwable)e);
        }
    }
}

