/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.notcompliant;

import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.notcompliant.NoConstructor;
import org.jboss.test.jmx.compliance.notcompliant.support.DynamicAndStandard;
import org.jboss.test.jmx.compliance.notcompliant.support.InterfaceProblems;
import org.jboss.test.jmx.compliance.notcompliant.support.NullDynamic;
import org.jboss.test.jmx.compliance.notcompliant.support.OverloadedAttribute1;
import org.jboss.test.jmx.compliance.notcompliant.support.OverloadedAttribute2;
import org.jboss.test.jmx.compliance.notcompliant.support.OverloadedAttribute3;
import org.jboss.test.jmx.compliance.notcompliant.support.OverloadedAttribute4;
import org.jboss.test.jmx.compliance.notcompliant.support.OverloadedAttribute5;

public class NCMBeanTEST
extends TestCase {
    public NCMBeanTEST(String s) {
        super(s);
    }

    public void testOverloadedAttribute1() {
        this.registerAndTest(new OverloadedAttribute1());
    }

    public void testOverloadedAttribute2() {
        this.registerAndTest(new OverloadedAttribute2());
    }

    public void testOverloadedAttribute3() {
        this.registerAndTest(new OverloadedAttribute3());
    }

    public void testOverloadedAttribute4() {
        this.registerAndTest(new OverloadedAttribute4());
    }

    public void testOverloadedAttribute5() {
        this.registerAndTest(new OverloadedAttribute5());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedDynamicStandard() {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            server.registerMBean(new DynamicAndStandard(), new ObjectName("test:foo=bar"));
            MBeanInfo info = server.getMBeanInfo(new ObjectName("test:foo=bar"));
            NCMBeanTEST.assertTrue((String)"A mixed dynamic and standard mbean should be dynamic", (boolean)info.getDescription().equals("dynamic mbeaninfo"));
        }
        catch (NotCompliantMBeanException e) {
            NCMBeanTEST.fail((String)"A mixed dynamic and standardmbean is allowed from jmx 1.1");
        }
        catch (Exception e) {
            NCMBeanTEST.fail((String)("unexpected exception when registering " + DynamicAndStandard.class.getName() + ": " + e.getMessage()));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testNoConstructor() {
        try {
            this.registerAndDontTest(NoConstructor.getInstance());
        }
        catch (NotCompliantMBeanException e) {
            NCMBeanTEST.fail((String)"An MBean without a public constructor is allowed from jmx 1.1");
        }
    }

    public void testInterfaceProblems() {
        try {
            this.registerAndDontTest(new InterfaceProblems());
        }
        catch (NotCompliantMBeanException e) {
            NCMBeanTEST.fail((String)"FAILS IN RI: Cannot cope with overriden get/is in interfaces");
        }
    }

    public void testNullDynamic() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectName name = new ObjectName("test:test=test");
        boolean caught = false;
        try {
            server.registerMBean(new NullDynamic(), name);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        NCMBeanTEST.assertTrue((String)"Expected NCME for null MBeanInfo", (boolean)caught);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAndTest(Object mbean) {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            server.registerMBean(mbean, new ObjectName("test:foo=bar"));
            NCMBeanTEST.fail((String)("expected a NotCompliantMBeanException for " + mbean.getClass().getName()));
        }
        catch (NotCompliantMBeanException e) {
        }
        catch (Exception e) {
            NCMBeanTEST.fail((String)("unexpected exception when registering " + mbean.getClass().getName() + ": " + e));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAndDontTest(Object mbean) throws NotCompliantMBeanException {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            server.registerMBean(mbean, new ObjectName("test:foo=bar"));
        }
        catch (NotCompliantMBeanException e) {
            throw e;
        }
        catch (Exception e) {
            NCMBeanTEST.fail((String)("unexpected exception when registering " + mbean.getClass().getName() + ": " + e.getMessage()));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }
}

