/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.vfs.VFSMessages;

public class PathTokenizer {
    private static final String CURRENT_PATH = ".";
    private static final String REVERSE_PATH = "..";
    private static final int STATE_INITIAL = 0;
    private static final int STATE_NORMAL = 1;
    private static final int STATE_MAYBE_CURRENT_PATH = 2;
    private static final int STATE_MAYBE_REVERSE_PATH = 3;

    private PathTokenizer() {
    }

    protected static String getRemainingPath(List<String> tokens, int i, int end) {
        if (tokens == null) {
            throw VFSMessages.MESSAGES.nullArgument("tokens");
        }
        if (i < 0 || i >= end) {
            throw new IllegalArgumentException("i is not in the range of tokens: 0-" + (end - 1));
        }
        if (i == end - 1) {
            return tokens.get(end - 1);
        }
        StringBuilder buffer = new StringBuilder();
        while (i < end - 1) {
            buffer.append(tokens.get(i));
            buffer.append("/");
            ++i;
        }
        buffer.append(tokens.get(end - 1));
        return buffer.toString();
    }

    public static List<String> getTokens(String path) {
        if (path == null) {
            throw VFSMessages.MESSAGES.nullArgument("path");
        }
        ArrayList<String> list = new ArrayList<String>();
        PathTokenizer.getTokens(list, path);
        return list;
    }

    public static void getTokens(List<String> list, String path) {
        int start = -1;
        int length = path.length();
        int state = 0;
        block25: for (int index = 0; index < length; ++index) {
            char ch = path.charAt(index);
            switch (ch) {
                case '/': 
                case '\\': {
                    switch (state) {
                        case 0: {
                            continue block25;
                        }
                        case 2: {
                            list.add(CURRENT_PATH);
                            state = 0;
                            continue block25;
                        }
                        case 3: {
                            list.add(REVERSE_PATH);
                            state = 0;
                            continue block25;
                        }
                        case 1: {
                            list.add(path.substring(start, index));
                            state = 0;
                            continue block25;
                        }
                    }
                    continue block25;
                }
                case '.': {
                    switch (state) {
                        case 0: {
                            state = 2;
                            start = index;
                            continue block25;
                        }
                        case 2: {
                            state = 3;
                            continue block25;
                        }
                        case 3: {
                            state = 1;
                            continue block25;
                        }
                    }
                    continue block25;
                }
                default: {
                    switch (state) {
                        case 0: {
                            state = 1;
                            start = index;
                            continue block25;
                        }
                        case 2: 
                        case 3: {
                            state = 1;
                        }
                    }
                }
            }
        }
        switch (state) {
            case 0: {
                break;
            }
            case 2: {
                list.add(CURRENT_PATH);
                break;
            }
            case 3: {
                list.add(REVERSE_PATH);
                break;
            }
            case 1: {
                list.add(path.substring(start));
            }
        }
    }

    public static String getRemainingPath(List<String> tokens, int i) {
        if (tokens == null) {
            throw VFSMessages.MESSAGES.nullArgument("tokens");
        }
        return PathTokenizer.getRemainingPath(tokens, i, tokens.size());
    }

    public static String applySpecialPaths(String path) throws IllegalArgumentException {
        List<String> tokens = PathTokenizer.getTokens(path);
        if (tokens == null) {
            return null;
        }
        int i = 0;
        for (int j = 0; j < tokens.size(); ++j) {
            String token = tokens.get(j);
            if (PathTokenizer.isCurrentToken(token)) continue;
            if (PathTokenizer.isReverseToken(token)) {
                --i;
            } else {
                tokens.set(i++, token);
            }
            if (i >= 0) continue;
            throw VFSMessages.MESSAGES.onRootPath();
        }
        return PathTokenizer.getRemainingPath(tokens, 0, i);
    }

    public static List<String> applySpecialPaths(List<String> pathTokens) throws IllegalArgumentException {
        ArrayList<String> newTokens = new ArrayList<String>();
        for (String pathToken : pathTokens) {
            if (PathTokenizer.isCurrentToken(pathToken)) continue;
            if (PathTokenizer.isReverseToken(pathToken)) {
                int size = newTokens.size();
                if (size == 0) {
                    throw VFSMessages.MESSAGES.onRootPath();
                }
                newTokens.remove(size - 1);
                continue;
            }
            newTokens.add(pathToken);
        }
        return newTokens;
    }

    public static boolean isCurrentToken(String token) {
        return CURRENT_PATH == token;
    }

    public static boolean isReverseToken(String token) {
        return REVERSE_PATH == token;
    }
}

