/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.cache.CacheStatistics;
import org.jboss.virtual.spi.cache.VFSCache;

public abstract class AbstractVFSCache
implements VFSCache,
CacheStatistics {
    protected Logger log = Logger.getLogger(this.getClass());
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private long timestamp;

    public long lastInsert() {
        return this.timestamp;
    }

    protected abstract void check();

    public VFSContext findContext(URL url) {
        try {
            return this.findContext(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract VFSContext getContext(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContext(VFSContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.check();
        if (this.log.isTraceEnabled()) {
            Object[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.log.trace((Object)("VFSContext: " + context + ", Stack-trace:\n" + Arrays.toString(stackTraceElements)));
        }
        String path = VFSUtils.getKey(context);
        this.writeLock();
        try {
            this.putContext(path, context);
            this.timestamp = System.currentTimeMillis();
        }
        finally {
            this.writeUnlock();
        }
    }

    protected abstract void putContext(String var1, VFSContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(VFSContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.check();
        String path = VFSUtils.getKey(context);
        this.writeLock();
        try {
            this.removeContext(path, context);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected abstract void removeContext(String var1, VFSContext var2);

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }
}

