/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.temp;

import java.io.File;
import java.io.IOException;
import org.jboss.util.file.Files;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VirtualFileHandler;

public class BasicTempInfo
implements TempInfo {
    private final String path;
    private volatile File file;
    private volatile VirtualFileHandler handler;

    public BasicTempInfo(String path, File file, VirtualFileHandler handler) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (file == null && handler == null) {
            throw new IllegalArgumentException("Both, file and handler, are null");
        }
        this.path = path;
        this.file = file;
        this.handler = handler;
    }

    public String getPath() {
        return this.path;
    }

    public File getTempFile() {
        return this.file;
    }

    public void cleanup() {
        if (this.handler != null) {
            this.handler.cleanup();
        } else if (this.file != null && this.file.exists()) {
            Files.delete((File)this.file);
        }
        this.handler = null;
        this.file = null;
    }

    public VirtualFileHandler getHandler() {
        return this.handler;
    }

    public boolean isValid() {
        try {
            return this.handler != null && this.handler.exists() && this.file != null && this.file.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.getPath() + " / " + this.getTempFile().getName();
    }
}

