/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.ReplacementHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.zip.ZipDirWrapper;
import org.jboss.virtual.plugins.context.zip.ZipEntryHandler;
import org.jboss.virtual.plugins.context.zip.ZipEntryTempInfo;
import org.jboss.virtual.plugins.context.zip.ZipEntryWrapper;
import org.jboss.virtual.plugins.context.zip.ZipFileWrapper;
import org.jboss.virtual.plugins.context.zip.ZipStreamWrapper;
import org.jboss.virtual.plugins.context.zip.ZipWrapper;
import org.jboss.virtual.plugins.copy.AbstractCopyMechanism;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.Options;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextConstraints;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryContext
extends AbstractVFSContext {
    private static final Logger log = Logger.getLogger(ZipEntryContext.class);
    private static boolean forceCopy;
    private static final byte[] NO_BYTES;
    private static final Set<VFSContextConstraints> CONSTRAINTS;
    private volatile ZipWrapper zipSource;
    private volatile String rootEntryPath = "";
    private volatile String filePath = null;
    private final boolean autoClean;
    private final Map<String, EntryInfo> entries = new ConcurrentHashMap<String, EntryInfo>(16, 0.75f, 4);
    private volatile InitializationStatus initStatus = InitializationStatus.NOT_INITIALIZED;
    private volatile URL realURL;

    public ZipEntryContext(URL rootURL) throws URISyntaxException, IOException {
        this(rootURL, false);
    }

    public ZipEntryContext(URL rootURL, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(rootURL, null, null);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, URL localRootUrl) throws URISyntaxException, IOException {
        this(rootURL, peer, localRootUrl, false);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, URL localRootUrl, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(localRootUrl, peer, null);
    }

    public ZipEntryContext(URL rootURL, VirtualFileHandler peer, ZipWrapper zipWrapper, boolean autoClean) throws URISyntaxException, IOException {
        super(VFSUtils.toURI(ZipEntryContext.fixUrl(rootURL)));
        this.autoClean = autoClean;
        this.init(null, peer, zipWrapper);
    }

    private void init(URL localRootURL, VirtualFileHandler peer, ZipWrapper zipWrapper) throws IOException, URISyntaxException {
        int namePos;
        if (zipWrapper == null) {
            if (localRootURL == null) {
                throw new IllegalArgumentException("No ZipWrapper specified and localRootURL is null");
            }
            this.filePath = this.initRootAndPath(localRootURL);
        } else {
            this.zipSource = zipWrapper;
        }
        this.setRootPeer(peer);
        String name = this.getRootURI().getPath();
        int toPos = name.length();
        if (name.length() != 0 && name.charAt(name.length() - 1) == '/') {
            --toPos;
        }
        if ((name = name.substring((namePos = name.lastIndexOf("/", toPos - 1)) + 1, toPos)).length() != 0 && name.charAt(name.length() - 1) == '!') {
            name = name.substring(0, name.length() - 1);
        }
        this.entries.put("", new EntryInfo(new ZipEntryHandler(this, null, name, false), null));
    }

    protected synchronized ZipWrapper getZipSource() {
        if (this.zipSource == null) {
            try {
                this.zipSource = this.createZipSource(this.filePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize ZipWrapper: " + this.filePath, e);
            }
        }
        return this.zipSource;
    }

    public Options getAggregatedOptions() {
        Options aggregatedOptions = this.createNewOptions();
        VFSContext peerContext = this.getPeerContext();
        if (peerContext != null) {
            aggregatedOptions.merge(peerContext.getOptions());
        }
        aggregatedOptions.merge(super.getOptions());
        return aggregatedOptions;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        ExceptionHandler eh = super.getExceptionHandler();
        if (eh != null) {
            return eh;
        }
        VFSContext peerContext = this.getPeerContext();
        return peerContext != null ? peerContext.getExceptionHandler() : null;
    }

    protected ZipWrapper createZipSource(String rootPath) throws IOException {
        File file = null;
        String relative = null;
        File fp = new File(VFSUtils.decode(rootPath));
        if (fp.exists()) {
            file = fp;
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    file = curr;
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        if (file == null) {
            throw new IOException("VFS file does not exist: " + rootPath);
        }
        RealURLInfo urlInfo = new RealURLInfo(file);
        if (relative != null) {
            ZipWrapper wrapper = this.findEntry(new FileInputStream(file), relative, urlInfo);
            this.realURL = urlInfo.toURL();
            return wrapper;
        }
        Options aggregatedOptions = this.getAggregatedOptions();
        boolean noReaper = aggregatedOptions.getBooleanOption("noReaper");
        this.realURL = urlInfo.toURL();
        boolean isAutoClean = this.autoClean || aggregatedOptions.getBooleanOption("IS_TEMP_FILE");
        return new ZipFileWrapper(file, isAutoClean, noReaper);
    }

    protected ZipWrapper findEntry(InputStream is, String relative, RealURLInfo urlInfo) throws IOException {
        String entryName;
        ZipEntry entry;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        VFSUtils.copyStreamAndClose(is, baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ZipInputStream zis = new ZipInputStream(bais);
        String longestNameMatch = null;
        while ((entry = zis.getNextEntry()) != null) {
            String match = entryName = entry.getName();
            if (entry.isDirectory()) {
                match = match.substring(0, match.length() - 1);
            }
            if (!relative.startsWith(match)) continue;
            if (match.equals(relative)) {
                if (entry.isDirectory()) {
                    this.rootEntryPath = relative;
                    return new ZipDirWrapper(zis, entryName, System.currentTimeMillis(), bais);
                }
                if (!JarUtils.isArchive(match)) {
                    return new ZipEntryWrapper(zis, entryName, System.currentTimeMillis());
                }
                return new ZipStreamWrapper(zis, entryName, System.currentTimeMillis());
            }
            if (longestNameMatch != null && longestNameMatch.length() >= entryName.length()) continue;
            longestNameMatch = entryName;
        }
        if (longestNameMatch == null) {
            throw new IllegalArgumentException("Cannot find entry: " + is + ", " + relative);
        }
        bais.reset();
        zis = new ZipInputStream(bais);
        while ((entry = zis.getNextEntry()) != null) {
            entryName = entry.getName();
            if (!entryName.equals(longestNameMatch)) continue;
            if (urlInfo != null) {
                urlInfo.relativePath = longestNameMatch;
            }
            relative = relative.substring(longestNameMatch.length() + 1);
            return this.findEntry(zis, relative, null);
        }
        throw new IllegalArgumentException("No such entry: " + is + ", " + relative);
    }

    @Override
    public Set<VFSContextConstraints> getConstraints() {
        return CONSTRAINTS;
    }

    @Override
    public String getName() {
        VirtualFileHandler peer = this.getRootPeer();
        if (peer != null) {
            return peer.getName();
        }
        return this.getZipSource().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initEntries() throws IOException, URISyntaxException {
        boolean trace = log.isTraceEnabled();
        HashMap<String, ZipEntry> relevant = new HashMap<String, ZipEntry>();
        ZipWrapper zipSource = this.getZipSource();
        zipSource.acquire();
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipSource.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ent = zipEntries.nextElement();
                if (!ent.getName().startsWith(this.rootEntryPath)) continue;
                relevant.put(ent.getName(), ent);
            }
            TreeMap orderedRelevant = new TreeMap(relevant);
            for (Map.Entry entry : orderedRelevant.entrySet()) {
                AbstractVirtualFileHandler parent;
                ZipEntry ent = (ZipEntry)entry.getValue();
                String fullName = ent.getName().substring(this.rootEntryPath.length());
                String[] split = ZipEntryContext.splitParentChild(fullName);
                String parentPath = split[0];
                String name = split[1];
                EntryInfo ei = null;
                if (!"".equals(name) && (ei = this.entries.get(parentPath)) == null) {
                    ei = this.makeDummyParent(parentPath);
                }
                AbstractVirtualFileHandler abstractVirtualFileHandler = parent = ei != null ? ei.handler : null;
                if (!ent.isDirectory() && JarUtils.isArchive(ent.getName())) {
                    DelegatingHandler delegator;
                    boolean useCopyMode = forceCopy;
                    if (!useCopyMode) {
                        useCopyMode = this.getAggregatedOptions().getBooleanOption("useCopyJarHandler");
                    }
                    if (useCopyMode) {
                        boolean createNewTempInfo;
                        TempInfo ti;
                        File dest = null;
                        String entryName = ent.getName();
                        String path = null;
                        VFSContext context = this.getPeerContext();
                        if (context != null && (ti = context.getTempInfo(path = this.getPath(context, entryName))) != null && ti.isValid()) {
                            dest = ti.getTempFile();
                        }
                        boolean bl = createNewTempInfo = dest == null || !dest.exists();
                        if (createNewTempInfo) {
                            dest = new File(ZipEntryContext.getTempDir() + "/" + ZipEntryContext.getTempFileName(entryName));
                            dest.deleteOnExit();
                            if (trace) {
                                Object[] stackTraceElements = Thread.currentThread().getStackTrace();
                                log.trace((Object)("Dest: " + dest + ", Stack-trace:\n" + Arrays.toString(stackTraceElements)));
                            }
                            dest.getParentFile().mkdirs();
                            InputStream is = zipSource.openStream(ent);
                            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dest));
                            VFSUtils.copyStreamAndClose(is, os);
                        }
                        delegator = this.mountZipFile(parent, name, dest);
                        if (context != null && path != null && createNewTempInfo) {
                            context.addTempInfo(new ZipEntryTempInfo(path, dest, delegator, this));
                        }
                    } else {
                        delegator = this.mountZipStream(parent, name, zipSource.openStream(ent));
                    }
                    this.entries.put(delegator.getLocalPathName(), new EntryInfo(delegator, ent));
                    this.addChild(parent, delegator);
                    continue;
                }
                ZipEntryHandler wrapper = new ZipEntryHandler(this, parent, name, !ent.isDirectory());
                this.entries.put(wrapper.getLocalPathName(), new EntryInfo(wrapper, ent));
            }
        }
        finally {
            zipSource.release();
        }
    }

    protected String getPath(VFSContext peer, String entryName) {
        URI peerURI = peer.getRootURI();
        String peerString = VFSUtils.stripProtocol(peerURI);
        String thisString = VFSUtils.stripProtocol(this.getRootURI());
        return thisString.substring(peerString.length()) + entryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureEntries() {
        block8: {
            if (this.initStatus != InitializationStatus.NOT_INITIALIZED) {
                return;
            }
            try {
                this.initStatus = InitializationStatus.INITIALIZING;
                this.initEntries();
                this.initStatus = InitializationStatus.INITIALIZED;
            }
            catch (Exception ex) {
                ExceptionHandler eh = this.getExceptionHandler();
                if (eh != null) {
                    eh.handleZipEntriesInitException(ex, this.getZipSource().getName());
                    break block8;
                }
                throw new RuntimeException("Failed to read zip file: " + this.getZipSource(), ex);
            }
            finally {
                if (this.initStatus == InitializationStatus.INITIALIZING) {
                    this.initStatus = InitializationStatus.NOT_INITIALIZED;
                }
            }
        }
    }

    synchronized void resetInitStatus() {
        if (this.initStatus != InitializationStatus.NOT_INITIALIZED) {
            EntryInfo rootInfo = this.entries.get("");
            this.entries.clear();
            this.entries.put("", rootInfo);
            this.initStatus = InitializationStatus.NOT_INITIALIZED;
        }
    }

    protected DelegatingHandler mountZipFile(VirtualFileHandler parent, String name, File file) throws IOException, URISyntaxException {
        URL fileUrl;
        DelegatingHandler delegator = new DelegatingHandler(this, parent, name);
        URL delegatorUrl = fileUrl = file.toURI().toURL();
        if (parent != null) {
            delegatorUrl = this.getChildURL(parent, name);
        }
        delegatorUrl = this.setOptionsToURL(delegatorUrl);
        ZipEntryContext ctx = new ZipEntryContext(delegatorUrl, (VirtualFileHandler)delegator, fileUrl, true);
        VirtualFileHandler handler = ctx.getRoot();
        delegator.setDelegate(handler);
        return delegator;
    }

    protected DelegatingHandler mountZipStream(VirtualFileHandler parent, String name, InputStream zipStream) throws IOException, URISyntaxException {
        DelegatingHandler delegator = new DelegatingHandler(this, parent, name);
        ZipStreamWrapper wrapper = new ZipStreamWrapper(zipStream, name, parent.getLastModified());
        URL delegatorUrl = null;
        if (parent != null) {
            delegatorUrl = this.getChildURL(parent, name);
        }
        delegatorUrl = this.setOptionsToURL(delegatorUrl);
        ZipEntryContext ctx = new ZipEntryContext(delegatorUrl, (VirtualFileHandler)delegator, wrapper, false);
        VirtualFileHandler handler = ctx.getRoot();
        delegator.setDelegate(handler);
        return delegator;
    }

    private EntryInfo makeDummyParent(String parentPath) throws IOException {
        String[] split = ZipEntryContext.splitParentChild(parentPath);
        String grandPa = split[0];
        EntryInfo eiParent = this.entries.get(grandPa);
        if (eiParent == null) {
            eiParent = this.makeDummyParent(grandPa);
        }
        ZipEntryHandler handler = new ZipEntryHandler(this, eiParent.handler, split[1], false);
        EntryInfo ei = new EntryInfo(handler, null);
        this.entries.put(parentPath, ei);
        return ei;
    }

    private String initRootAndPath(URL localRootUrl) {
        int queryStart;
        String filePath;
        String zipPath = filePath = localRootUrl.toString();
        int pos = filePath.indexOf("!");
        if (pos > 0) {
            zipPath = filePath.substring(0, pos);
            this.rootEntryPath = filePath.substring(pos + 2);
            if (this.rootEntryPath.length() != 0) {
                this.rootEntryPath = this.rootEntryPath + "/";
            }
        }
        if ((queryStart = (filePath = zipPath.substring((pos = zipPath.indexOf(":/")) + 1)).indexOf("?")) != -1) {
            filePath = filePath.substring(0, queryStart);
        }
        return filePath;
    }

    private synchronized void checkIfModified() {
        if (this.initStatus == InitializationStatus.NOT_INITIALIZED) {
            this.ensureEntries();
        } else if (this.initStatus == InitializationStatus.INITIALIZED && this.getZipSource().hasBeenModified()) {
            EntryInfo rootInfo = this.entries.get("");
            this.entries.clear();
            this.entries.put("", rootInfo);
            if (this.getZipSource().exists()) {
                try {
                    this.initEntries();
                }
                catch (Exception ignored) {
                    log.warn((Object)("IGNORING: Failed to reinitialize context: " + this.getRootURI()), (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public VirtualFileHandler getRoot() {
        return this.entries.get("").handler;
    }

    VirtualFileHandler getChild(ZipEntryHandler parent, String name) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.checkIfModified();
        String pathName = parent.getLocalPathName();
        pathName = "".equals(pathName) ? name : pathName + "/" + name;
        EntryInfo ei = this.entries.get(pathName);
        if (ei != null) {
            return ei.handler;
        }
        return null;
    }

    @Override
    public List<VirtualFileHandler> getChildren(VirtualFileHandler parent, boolean ignoreErrors) throws IOException {
        AbstractVirtualFileHandler parentHandler;
        EntryInfo parentEntry;
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.checkIfModified();
        if (parent instanceof AbstractVirtualFileHandler && (parentEntry = this.entries.get((parentHandler = (AbstractVirtualFileHandler)parent).getLocalPathName())) != null) {
            if (parentEntry.handler instanceof DelegatingHandler) {
                return parentEntry.handler.getChildren(ignoreErrors);
            }
            return parentEntry.getChildren();
        }
        return Collections.emptyList();
    }

    boolean delete(ZipEntryHandler handler, int gracePeriod) throws IOException {
        return this.getRoot().equals(handler) && this.getZipSource().delete(gracePeriod);
    }

    void cleanup(ZipEntryHandler handler) {
        VirtualFileHandler rootHandler = this.getRoot();
        if (rootHandler.equals(handler)) {
            this.getZipSource().close();
        }
    }

    long getLastModified(ZipEntryHandler handler) {
        EntryInfo ei;
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (!this.getRoot().equals(handler)) {
            this.checkIfModified();
        }
        if ((ei = this.entries.get(handler.getLocalPathName())) == null) {
            return 0L;
        }
        if (ei.entry == null) {
            return this.getZipSource().getLastModified();
        }
        return ei.entry.getTime();
    }

    long getSize(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.getRoot().equals(handler)) {
            return this.getZipSource().getSize();
        }
        this.checkIfModified();
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        if (ei == null || ei.entry == null) {
            return 0L;
        }
        return ei.entry.getSize();
    }

    boolean exists(ZipEntryHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.getRoot().equals(handler)) {
            return this.getZipSource().exists();
        }
        this.checkIfModified();
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        return ei != null;
    }

    boolean isLeaf(ZipEntryHandler handler) {
        EntryInfo ei;
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (!this.getRoot().equals(handler)) {
            this.checkIfModified();
        }
        if ((ei = this.entries.get(handler.getLocalPathName())) == null || ei.entry == null) {
            return false;
        }
        return !ei.entry.isDirectory();
    }

    boolean isArchive(ZipEntryHandler handler) {
        return this.getRoot().equals(handler);
    }

    static boolean isArchive(VirtualFileHandler handler) {
        if (handler instanceof ZipEntryHandler && "".equals(handler.getLocalPathName())) {
            return true;
        }
        return handler instanceof DelegatingHandler && ((DelegatingHandler)handler).getDelegate() instanceof ZipEntryHandler;
    }

    static VirtualFileHandler getParent(VirtualFileHandler handler) throws IOException {
        VirtualFileHandler peer;
        VirtualFileHandler parent = handler.getParent();
        if (parent == null && (peer = handler.getVFSContext().getRootPeer()) != null) {
            parent = peer.getParent();
        }
        return parent;
    }

    static boolean isNested(VirtualFileHandler handler) throws IOException {
        VirtualFileHandler parent = ZipEntryContext.getParent(handler);
        while (parent != null) {
            if (ZipEntryContext.isArchive(parent)) {
                return true;
            }
            parent = ZipEntryContext.getParent(parent);
        }
        return false;
    }

    InputStream openStream(ZipEntryHandler handler) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (this.getRoot().equals(handler)) {
            return this.getZipSource().getRootAsStream();
        }
        this.checkIfModified();
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        if (ei == null) {
            String uriStr;
            try {
                uriStr = handler.toURI().toString();
            }
            catch (Exception ex) {
                throw new RuntimeException("ASSERTION ERROR - uri generation failed for ZipEntryHandler: " + handler, ex);
            }
            throw new FileNotFoundException(uriStr);
        }
        if (ei.entry == null) {
            return new ByteArrayInputStream(NO_BYTES);
        }
        return this.getZipSource().openStream(ei.entry);
    }

    void addChild(AbstractVirtualFileHandler parent, AbstractVirtualFileHandler child) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        EntryInfo parentEntry = this.entries.get(parent.getLocalPathName());
        if (parentEntry == null) {
            throw new RuntimeException("Parent does not exist: " + parent);
        }
        parentEntry.add(child);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.zipSource != null) {
                this.zipSource.close();
            }
        }
        catch (Throwable ignored) {
            log.debug((Object)("IGNORING: Failed to close zip source: " + this.zipSource), ignored);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceChild(ZipEntryHandler parent, AbstractVirtualFileHandler original, VirtualFileHandler replacement) {
        this.ensureEntries();
        EntryInfo parentEntry = this.entries.get(parent.getLocalPathName());
        if (parentEntry != null) {
            DelegatingHandler newOne = replacement instanceof DelegatingHandler ? (DelegatingHandler)replacement : new ReplacementHandler(this, parent, original.getName(), replacement);
            ZipEntryContext zipEntryContext = this;
            synchronized (zipEntryContext) {
                parentEntry.replaceChild(original, newOne);
                EntryInfo ei = this.entries.get(original.getLocalPathName());
                ei.handler = newOne;
                ei.entry = null;
                ei.clearChildren();
            }
        } else {
            throw new RuntimeException("Parent does not exist: " + parent);
        }
    }

    URL getRealURL() {
        this.getZipSource();
        return this.realURL;
    }

    Certificate[] getCertificates(ZipEntryHandler handler) {
        EntryInfo ei = this.entries.get(handler.getLocalPathName());
        if (ei != null && ei.entry != null) {
            ZipEntry entry = ei.entry;
            JarEntry je = entry instanceof JarEntry ? (JarEntry)entry : new JarEntry(entry);
            return je.getCertificates();
        }
        return null;
    }

    private static URL fixUrl(URL rootURL) throws MalformedURLException {
        String urlStr = rootURL.toExternalForm();
        int pos = urlStr.indexOf("!");
        if (pos != -1) {
            String tmp = urlStr.substring(0, pos);
            if (pos < urlStr.length() - 1) {
                tmp = tmp + urlStr.substring(pos + 1);
            }
            urlStr = tmp;
        }
        if (!"vfszip".equals(rootURL.getProtocol())) {
            pos = urlStr.indexOf(":/");
            if (pos != -1) {
                urlStr = urlStr.substring(pos);
            }
            return new URL("vfszip" + urlStr);
        }
        return rootURL;
    }

    public static String[] splitParentChild(String pathName) {
        int delimPos;
        if (pathName.startsWith("/")) {
            pathName = pathName.substring(1);
        }
        if (pathName.length() == 0) {
            return new String[]{null, pathName};
        }
        int toPos = pathName.length();
        if (pathName.charAt(pathName.length() - 1) == '/') {
            --toPos;
        }
        String[] ret = (delimPos = pathName.lastIndexOf(47, toPos - 1)) == -1 ? new String[]{"", pathName.substring(delimPos + 1, toPos)} : new String[]{pathName.substring(0, delimPos), pathName.substring(delimPos + 1, toPos)};
        return ret;
    }

    private static String getTempFileName(String name) {
        int delim = name.lastIndexOf("/");
        if (delim != -1) {
            name = name.substring(delim + 1);
        }
        return UUID.randomUUID().toString().substring(0, 8) + "_" + name;
    }

    private static String getTempDir() {
        File dir = new File(AbstractCopyMechanism.getTempDirectory(), "vfs-nested.tmp");
        return dir.toString();
    }

    private static void deleteTmpDirContents() {
        try {
            File tmpDir = new File(ZipEntryContext.getTempDir());
            File[] files = tmpDir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (file.isDirectory() || file.isHidden()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ZipEntryContext.deleteTmpDirContents();
        forceCopy = AccessController.doPrivileged(new CheckForceCopy());
        if (forceCopy) {
            log.info((Object)"VFS force nested jars copy-mode is enabled.");
        }
        NO_BYTES = new byte[0];
        CONSTRAINTS = Collections.singleton(VFSContextConstraints.CACHEABLE);
    }

    private static class RealURLInfo {
        String rootURL;
        String relativePath;

        RealURLInfo(File file) throws MalformedURLException {
            String url = file.toURI().toURL().toExternalForm();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            this.rootURL = "jar:" + url + "!/";
        }

        URL toURL() throws MalformedURLException {
            if (this.relativePath == null || this.relativePath.length() == 0) {
                return new URL(this.rootURL);
            }
            if (this.relativePath.startsWith("/")) {
                this.relativePath = this.relativePath.substring(1);
            }
            return new URL(this.rootURL + this.relativePath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitializationStatus {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceCopy
    implements PrivilegedAction<Boolean> {
        private CheckForceCopy() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceCopy", "false");
            return Boolean.valueOf(forceString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryInfo {
        private AbstractVirtualFileHandler handler;
        private ZipEntry entry;
        private Map<String, AbstractVirtualFileHandler> children;

        EntryInfo(AbstractVirtualFileHandler handler, ZipEntry entry) {
            this.handler = handler;
            this.entry = entry;
        }

        public synchronized List<VirtualFileHandler> getChildren() {
            if (this.children == null) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFileHandler>(this.children.values());
        }

        public synchronized void replaceChild(AbstractVirtualFileHandler original, AbstractVirtualFileHandler replacement) {
            String name;
            if (this.children != null && this.children.containsKey(name = original.getName())) {
                this.children.put(name, replacement);
            }
        }

        public synchronized void clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        public synchronized void add(AbstractVirtualFileHandler child) {
            if (this.children == null) {
                this.children = new LinkedHashMap<String, AbstractVirtualFileHandler>();
            }
            this.children.put(child.getName(), child);
        }
    }
}

