/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.spi.cache;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.helpers.NoopVFSCache;

public class VFSCacheFactory {
    private static final Object lock = new Object();
    private static Logger log = Logger.getLogger(VFSCacheFactory.class);
    private static VFSCache instance;

    private VFSCacheFactory() {
    }

    public static VFSCache getInstance() {
        return VFSCacheFactory.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFSCache getInstance(String defaultCacheImpl) {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = AccessController.doPrivileged(new VFSCacheCreatorAction(defaultCacheImpl));
                }
            }
        }
        return instance;
    }

    public static void setInstance(VFSCache cache) {
        if (cache != null && instance != null && !(instance instanceof NoopVFSCache)) {
            throw new IllegalArgumentException("Instance already set!");
        }
        instance = cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VFSCacheCreatorAction
    implements PrivilegedAction<VFSCache> {
        private String defaultCacheImpl;

        VFSCacheCreatorAction(String defaultCacheImpl) {
            this.defaultCacheImpl = defaultCacheImpl;
        }

        @Override
        public VFSCache run() {
            try {
                String className = this.defaultCacheImpl;
                if (className == null || className.length() == 0) {
                    className = System.getProperty("jboss.vfs.cache");
                }
                if (className != null) {
                    log.info((Object)("Initializing VFSCache [" + className + "] ..."));
                    ClassLoader cl = VFSCacheFactory.class.getClassLoader();
                    Class<?> clazz = cl.loadClass(className);
                    VFSCache cache = (VFSCache)VFSCache.class.cast(clazz.newInstance());
                    cache.start();
                    log.info((Object)("Using VFSCache [" + cache + "] ..."));
                    return cache;
                }
            }
            catch (Throwable t) {
                log.warn((Object)"Exception instantiating VFS cache: ", t);
            }
            log.info((Object)"Using VFSCache [NoopVFSCache] ...");
            return new NoopVFSCache();
        }
    }
}

