/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import org.jboss.util.CachePolicy;
import org.jboss.util.LRUCachePolicy;
import org.jboss.virtual.plugins.cache.CachePolicyVFSCache;

public class LRUVFSCache
extends CachePolicyVFSCache {
    private Integer min;
    private Integer max;

    public LRUVFSCache() {
    }

    public LRUVFSCache(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    protected CachePolicy createCachePolicy() {
        if (this.min == null) {
            this.min = LRUVFSCache.parseInteger(LRUVFSCache.readSystemProperty("jboss.vfs.cache.LRUPolicyCaching.min", null));
        }
        if (this.max == null) {
            this.max = LRUVFSCache.parseInteger(LRUVFSCache.readSystemProperty("jboss.vfs.cache.LRUPolicyCaching.max", null));
        }
        if (this.min == null || this.max == null) {
            throw new IllegalArgumentException("Missing min (" + this.min + ") or max (" + this.max + ").");
        }
        this.log.debug((Object)("Creating LRU cache policy, min: " + this.min + ", max: " + this.max));
        return new LRUCachePolicy(this.min.intValue(), this.max.intValue());
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public void setMax(Integer max) {
        this.max = max;
    }
}

