/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.cache.CacheStatistics;
import org.jboss.virtual.spi.cache.VFSCache;

public abstract class AbstractVFSCache
implements VFSCache,
CacheStatistics {
    protected Logger log = Logger.getLogger(this.getClass());
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private long timestamp;

    public long lastInsert() {
        return this.timestamp;
    }

    protected abstract void check();

    public VirtualFile getFile(URI uri) throws IOException {
        this.check();
        VFSContext context = this.findContext(uri);
        if (context != null) {
            VirtualFileHandler root = context.getRoot();
            String relativePath = this.getRelativePath(context, uri);
            VirtualFileHandler child = root.getChild(relativePath);
            return child.getVirtualFile();
        }
        return VFS.getRoot(uri);
    }

    protected String getRelativePath(VFSContext context, URI uri) {
        String uriPath = AbstractVFSCache.stripProtocol(uri);
        String contextKey = AbstractVFSCache.getKey(context);
        return uriPath.substring(contextKey.length());
    }

    public VirtualFile getFile(URL url) throws IOException {
        this.check();
        try {
            return this.getFile(VFSUtils.toURI(url));
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected static String stripProtocol(URI uri) {
        String path = uri.getPath();
        if (path != null && path.length() > 0) {
            StringBuilder sb = new StringBuilder(path);
            if (sb.charAt(0) != '/') {
                sb.insert(0, '/');
            }
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            path = sb.toString();
        } else {
            path = "/";
        }
        return path;
    }

    protected abstract VFSContext getContext(String var1);

    protected abstract VFSContext findContext(URI var1);

    protected static String getKey(VFSContext context) {
        URI uri = context.getRootURI();
        return AbstractVFSCache.stripProtocol(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContext(VFSContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.check();
        if (this.log.isTraceEnabled()) {
            Object[] stackTraceElements = Thread.currentThread().getStackTrace();
            this.log.trace((Object)("VFSContext: " + context + ", Stack-trace:\n" + Arrays.toString(stackTraceElements)));
        }
        String path = AbstractVFSCache.getKey(context);
        this.writeLock();
        try {
            this.putContext(path, context);
            this.timestamp = System.currentTimeMillis();
        }
        finally {
            this.writeUnlock();
        }
    }

    protected abstract void putContext(String var1, VFSContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(VFSContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.check();
        String path = AbstractVFSCache.getKey(context);
        this.writeLock();
        try {
            this.removeContext(path, context);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected abstract void removeContext(String var1, VFSContext var2);

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }
}

